/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.api.generic;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.immcraft.api.IImmersiveCraft;
import mcjty.immcraft.api.block.IOrientedBlock;
import mcjty.immcraft.api.generic.GenericTE;
import mcjty.immcraft.api.handles.HandleSelector;
import mcjty.immcraft.api.helpers.InventoryHelper;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GenericBlock
extends BaseBlock
implements IOrientedBlock {
    private final Map<String, HandleSelector> selectors = new HashMap<String, HandleSelector>();

    protected void addSelector(HandleSelector selector) {
        this.selectors.put(selector.getId(), selector);
    }

    public Map<String, HandleSelector> getSelectors() {
        return this.selectors;
    }

    protected abstract IImmersiveCraft getApi();

    public GenericBlock(Material material, ModBase mod, String name, Function<Block, ItemBlock> itemBlockFactory) {
        super(mod, material, name, itemBlockFactory);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    @Override
    public EnumFacing worldToBlockSpace(World world, BlockPos pos, EnumFacing side) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return OrientationTools.worldToBlockSpaceHoriz((EnumFacing)side, (IBlockState)world.func_180495_p(pos));
            }
            case ROTATION: {
                return OrientationTools.worldToBlockSpace((EnumFacing)side, (IBlockState)world.func_180495_p(pos));
            }
        }
        return side;
    }

    public Vec3d blockToWorldSpace(World world, BlockPos pos, Vec3d v) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return OrientationTools.blockToWorldSpaceHoriz((Vec3d)v, (IBlockState)world.func_180495_p(pos));
            }
            case ROTATION: {
                return OrientationTools.blockToWorldSpace((Vec3d)v, (IBlockState)world.func_180495_p(pos));
            }
        }
        return v;
    }

    public Vec3d worldToBlockSpace(World world, BlockPos pos, Vec3d v) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return OrientationTools.worldToBlockSpaceHoriz((Vec3d)v, (IBlockState)world.func_180495_p(pos));
            }
            case ROTATION: {
                return OrientationTools.worldToBlockSpace((Vec3d)v, (IBlockState)world.func_180495_p(pos));
            }
        }
        return v;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        if (world.field_72995_K) {
            this.clickBlockClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clickBlockClient() {
        this.getApi().registerBlockClick();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTE) {
            ((GenericTE)te).onActivate(player);
            return true;
        }
        return false;
    }

    public boolean onClick(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTE) {
            return ((GenericTE)te).onClick(player);
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        InventoryHelper.getInventory(world, pos).ifPresent(p -> InventoryHelper.emptyInventoryInWorld(world, pos, state.func_177230_c(), p));
        super.func_180663_b(world, pos, state);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        Vec3d p = new Vec3d((Vec3i)pos);
        start = this.worldToBlockSpace(worldIn, pos, start.func_178788_d(p));
        end = this.worldToBlockSpace(worldIn, pos, end.func_178788_d(p));
        double maxSqd = 1.0E9;
        RayTraceResult rc = null;
        for (HandleSelector selector : this.selectors.values()) {
            double sqd;
            RayTraceResult result = selector.getBox().func_72327_a(start, end);
            if (result == null || !((sqd = start.func_72436_e(result.field_72307_f)) < maxSqd)) continue;
            rc = new RayTraceResult(result.field_72307_f.func_178787_e(p), result.field_178784_b, pos);
            rc.hitInfo = selector;
            maxSqd = sqd;
        }
        if (rc != null) {
            return rc;
        }
        AxisAlignedBB boundingBox = blockState.func_185900_c((IBlockAccess)worldIn, pos);
        RayTraceResult raytraceresult = boundingBox.func_72327_a(start, end);
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.field_72307_f.func_178787_e(p), raytraceresult.field_178784_b, pos);
    }
}

