/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.api.handles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.immcraft.api.handles.IInterfaceHandle;
import mcjty.immcraft.api.helpers.InventoryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class HandleSupport {
    private final List<IInterfaceHandle> interfaceHandles = new ArrayList<IInterfaceHandle>();

    public List<IInterfaceHandle> getInterfaceHandles() {
        return this.interfaceHandles;
    }

    public void addInterfaceHandle(IInterfaceHandle handle) {
        this.interfaceHandles.add(handle);
    }

    @Nullable
    public IInterfaceHandle getHandleWithID(String id) {
        for (IInterfaceHandle handle : this.interfaceHandles) {
            if (!id.equals(handle.getSelectorID())) continue;
            return handle;
        }
        return null;
    }

    public boolean addItemAnywhere(TileEntity te, EntityPlayer player, ItemStack heldItem, int amount) {
        for (IInterfaceHandle handle : this.interfaceHandles) {
            if (!handle.acceptAsInput(heldItem) || !this.addItemToHandle(te, player, heldItem, handle, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean addItemToHandle(TileEntity te, EntityPlayer player, ItemStack heldItem, IInterfaceHandle handle, int amount) {
        if (!player.func_130014_f_().field_72995_K) {
            ItemStack itemStack;
            if (amount == -1) {
                itemStack = heldItem;
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            } else {
                itemStack = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, amount);
            }
            int remaining = handle.insertInput(te, itemStack);
            if (remaining != 0) {
                if (remaining <= 0) {
                    itemStack.func_190920_e(0);
                } else {
                    itemStack.func_190920_e(remaining);
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, itemStack);
                player.field_71070_bA.func_75142_b();
                return false;
            }
            player.field_71070_bA.func_75142_b();
            return true;
        }
        return false;
    }

    private boolean getItemFromHandle(TileEntity te, EntityPlayer player, IInterfaceHandle handle, int amount, boolean exactSlot) {
        if (!player.func_130014_f_().field_72995_K) {
            ItemStack itemStack = handle.extractOutput(te, player, amount);
            if (itemStack.func_190926_b()) {
                return false;
            }
            InventoryHelper.giveItemToPlayer(player, itemStack);
        }
        return true;
    }

    private boolean extractItemFromHandle(TileEntity te, EntityPlayer player, IInterfaceHandle handle) {
        if (!player.func_130014_f_().field_72995_K) {
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (!handle.isSuitableExtractionItem(heldItem)) {
                return false;
            }
            ItemStack itemStack = handle.extractOutput(te, player, 1);
            if (itemStack.func_190926_b()) {
                return false;
            }
            heldItem.func_190918_g(1);
            player.func_184611_a(EnumHand.MAIN_HAND, heldItem);
            InventoryHelper.giveItemToPlayer(player, itemStack);
        }
        return true;
    }

    public boolean handleClick(TileEntity te, EntityPlayer player, IInterfaceHandle handle) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return false;
        }
        int amount = -1;
        if (handle.acceptAsInput(heldItem)) {
            if (!this.addItemToHandle(te, player, heldItem, handle, amount)) {
                this.addItemAnywhere(te, player, heldItem, amount);
            }
            return true;
        }
        return this.addItemAnywhere(te, player, heldItem, amount);
    }

    public boolean handleActivate(TileEntity te, EntityPlayer player, IInterfaceHandle handle) {
        ItemStack currentStack;
        boolean rc;
        if (handle.getAction() != null && (rc = handle.getAction().test(player))) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        boolean sneaking = player.func_70093_af();
        if (handle.isOutputWithItem() && handle.isItemThatNeedsExtractionItem(currentStack = handle.getCurrentStack(te))) {
            if (handle.isSuitableExtractionItem(heldItem)) {
                int amount = handle.getExtractAmount(sneaking);
                while (amount == -1 || amount > 0) {
                    if (!this.extractItemFromHandle(te, player, handle)) {
                        return true;
                    }
                    if (amount <= 0) continue;
                    --amount;
                }
            } else if (!te.func_145831_w().field_72995_K) {
                TextComponentString component = new TextComponentString(handle.getExtractionMessage());
                if (player instanceof EntityPlayer) {
                    player.func_146105_b((ITextComponent)component, false);
                } else {
                    player.func_145747_a((ITextComponent)component);
                }
            }
            return true;
        }
        if (heldItem.func_190926_b()) {
            int amount = handle.getExtractAmount(sneaking);
            return this.getItemFromHandle(te, player, handle, amount, true);
        }
        if (handle.acceptAsInput(heldItem)) {
            int amount = handle.getInsertAmount(sneaking);
            if (!this.addItemToHandle(te, player, heldItem, handle, amount)) {
                this.getItemFromHandle(te, player, handle, amount, false);
            }
            return true;
        }
        int amount = handle.getExtractAmount(sneaking);
        return this.getItemFromHandle(te, player, handle, amount, false);
    }
}

