/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.api.helpers;

import java.util.Map;
import java.util.Optional;
import java.util.Random;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryHelper {
    private final TileEntity tileEntity;
    private ItemStackList stacks;
    private int count;
    private static final Random random = new Random();

    public InventoryHelper(TileEntity tileEntity, int count) {
        this.tileEntity = tileEntity;
        this.stacks = ItemStackList.create((int)count);
        this.count = count;
    }

    public static Optional<IInventory> getInventory(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            return Optional.of((IInventory)te);
        }
        return Optional.empty();
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack stack) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
            player.field_71070_bA.func_75142_b();
            return;
        }
        if (InventoryHelper.isItemStackConsideredEqual(heldItem, stack) && heldItem.func_190916_E() < heldItem.func_77976_d()) {
            int itemsToAdd = Math.min(stack.func_190916_E(), heldItem.func_77976_d() - heldItem.func_190916_E());
            heldItem.func_190917_f(itemsToAdd);
            stack.func_190918_g(itemsToAdd);
            if (stack.func_190926_b()) {
                player.field_71070_bA.func_75142_b();
                return;
            }
        }
        if (player.field_71071_by.func_70441_a(stack)) {
            player.field_71070_bA.func_75142_b();
            return;
        }
        InventoryHelper.spawnItemStack(player.func_130014_f_(), player.func_180425_c(), stack);
    }

    public static void emptyInventoryInWorld(World world, BlockPos pos, Block block, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            InventoryHelper.spawnItemStack(world, pos, itemstack);
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        world.func_175666_e(pos, block);
    }

    public static void spawnItemStack(World world, BlockPos c, ItemStack itemStack) {
        InventoryHelper.spawnItemStack(world, c.func_177958_n(), c.func_177956_o(), c.func_177952_p(), itemStack);
    }

    public static void spawnItemStack(World world, int x, int y, int z, ItemStack itemstack) {
        if (!itemstack.func_190926_b()) {
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (!itemstack.func_190926_b()) {
                int j = random.nextInt(21) + 10;
                if (j > itemstack.func_190916_E()) {
                    j = itemstack.func_190916_E();
                }
                ItemStack toSpawn = itemstack.func_77979_a(j);
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), toSpawn);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public void setNewCount(int newcount) {
        this.count = newcount;
        ItemStackList newstacks = ItemStackList.create((int)newcount);
        for (int i = 0; i < Math.min(this.stacks.size(), newstacks.size()); ++i) {
            newstacks.add(this.stacks.get(i));
        }
        this.stacks = newstacks;
    }

    public static int mergeItemStackSafe(IInventory inventory, EnumFacing side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        if (inventory instanceof ISidedInventory) {
            return InventoryHelper.mergeItemStackInternal(inventory, (ISidedInventory)inventory, side, result, start, stop, undo);
        }
        return InventoryHelper.mergeItemStackInternal(inventory, null, side, result, start, stop, undo);
    }

    public static int mergeItemStack(IInventory inventory, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        return InventoryHelper.mergeItemStackInternal(inventory, null, null, result, start, stop, undo);
    }

    private static int mergeItemStackInternal(IInventory inventory, ISidedInventory sidedInventory, EnumFacing side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        int k;
        ItemStack itemstack1 = ItemStack.field_190927_a;
        int itemsToPlace = result.func_190916_E();
        if (result.func_77985_e()) {
            for (k = start; itemsToPlace > 0 && k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (!InventoryHelper.isItemStackConsideredEqual(result, itemstack1) || sidedInventory != null && !sidedInventory.func_180462_a(k, result, side)) continue;
                int l = itemstack1.func_190916_E() + itemsToPlace;
                if (l <= result.func_77976_d()) {
                    if (undo != null && !undo.containsKey(k)) {
                        undo.put(k, itemstack1.func_77946_l());
                    }
                    itemsToPlace = 0;
                    if (l <= 0) {
                        itemstack1.func_190920_e(0);
                    } else {
                        itemstack1.func_190920_e(l);
                    }
                    inventory.func_70296_d();
                    continue;
                }
                if (itemstack1.func_190916_E() >= result.func_77976_d()) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, itemstack1.func_77946_l());
                }
                itemsToPlace -= result.func_77976_d() - itemstack1.func_190916_E();
                int amount = result.func_77976_d();
                if (amount <= 0) {
                    itemstack1.func_190920_e(0);
                } else {
                    itemstack1.func_190920_e(amount);
                }
                inventory.func_70296_d();
            }
        }
        if (itemsToPlace > 0) {
            for (k = start; k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() || sidedInventory != null && !sidedInventory.func_180462_a(k, result, side)) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, ItemStack.field_190927_a);
                }
                ItemStack copy = result.func_77946_l();
                if (itemsToPlace <= 0) {
                    copy.func_190920_e(0);
                } else {
                    copy.func_190920_e(itemsToPlace);
                }
                inventory.func_70299_a(k, copy);
                inventory.func_70296_d();
                itemsToPlace = 0;
                break;
            }
        }
        return itemsToPlace;
    }

    public static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return !itemstack1.func_190926_b() && itemstack1.func_77973_b() == result.func_77973_b() && (!result.func_77981_g() || result.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack1);
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasStack(int index) {
        if (index >= this.stacks.size()) {
            return false;
        }
        return !((ItemStack)this.stacks.get(index)).func_190926_b();
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        this.stacks.set(index, (Object)stack);
    }

    public boolean containsItem(int index) {
        if (index >= this.stacks.size()) {
            return false;
        }
        return !((ItemStack)this.stacks.get(index)).func_190926_b();
    }

    public boolean isGhostSlot(int index) {
        return false;
    }

    public boolean isGhostOutputSlot(int index) {
        return false;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        if (this.isGhostSlot(index) || this.isGhostOutputSlot(index)) {
            ItemStack old = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, (Object)ItemStack.field_190927_a);
            if (old.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            old.func_190920_e(0);
            return old;
        }
        if (!((ItemStack)this.stacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.stacks.get(index)).func_190916_E() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
                this.tileEntity.func_70296_d();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).func_77979_a(amount);
            if (((ItemStack)this.stacks.get(index)).func_190926_b()) {
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
            }
            this.tileEntity.func_70296_d();
            return its;
        }
        return ItemStack.field_190927_a;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        if (this.isGhostSlot(index)) {
            if (!stack.func_190926_b()) {
                this.stacks.set(index, (Object)stack.func_77946_l());
                if (index < 9) {
                    ItemStack stack1 = (ItemStack)this.stacks.get(index);
                    stack1.func_190920_e(1);
                }
            } else {
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
            }
        } else if (this.isGhostOutputSlot(index)) {
            if (!stack.func_190926_b()) {
                this.stacks.set(index, (Object)stack.func_77946_l());
            } else {
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
            }
        } else {
            this.stacks.set(index, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > stackLimit) {
                if (stackLimit <= 0) {
                    stack.func_190920_e(0);
                } else {
                    stack.func_190920_e(stackLimit);
                }
            }
            this.tileEntity.func_70296_d();
        }
    }

    public static void compactStacks(InventoryHelper helper, int start, int max) {
        InventoryHelper.compactStacks(helper.stacks, start, max);
    }

    public static void compactStacks(ItemStackList stacks, int start, int max) {
        ItemStack stack;
        int i;
        InventoryBasic inv = new InventoryBasic("temp", true, max);
        for (i = 0; i < max; ++i) {
            stack = (ItemStack)stacks.get(i + start);
            if (stack.func_190926_b()) continue;
            InventoryHelper.mergeItemStack((IInventory)inv, stack, 0, max, null);
        }
        for (i = 0; i < max; ++i) {
            stack = inv.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_190916_E() == 0) {
                stack = ItemStack.field_190927_a;
            }
            stacks.set(i + start, (Object)stack);
        }
    }
}

