/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.book;

import java.util.Collections;
import java.util.List;
import mcjty.immcraft.api.book.IBook;
import mcjty.immcraft.api.helpers.InventoryHelper;
import mcjty.immcraft.blocks.book.EnumStandState;
import mcjty.immcraft.blocks.generic.GenericImmcraftTE;
import mcjty.immcraft.books.BookPage;
import mcjty.immcraft.books.BookParser;
import mcjty.immcraft.books.RenderSection;
import mcjty.immcraft.config.GeneralConfiguration;
import mcjty.immcraft.network.ImmCraftPacketHandler;
import mcjty.immcraft.network.PacketPageFlip;
import mcjty.immcraft.sound.SoundController;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BookStandTE
extends GenericImmcraftTE {
    private ItemStack currentBook = ItemStack.field_190927_a;
    private List<BookPage> pages = null;
    private int pageNumber = 0;
    private String result = null;

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldBook = !this.currentBook.func_190926_b();
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K) {
            boolean newBook;
            boolean bl = newBook = !this.currentBook.func_190926_b();
            if (oldBook != newBook) {
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            }
        }
    }

    public List<BookPage> getPages() {
        if (this.pages == null) {
            if (this.currentBook.func_190926_b()) {
                this.pages = Collections.emptyList();
                return this.pages;
            }
            ResourceLocation json = ((IBook)this.currentBook.func_77973_b()).getJson();
            BookParser parser = new BookParser();
            this.pages = parser.parse(json, 768, 900);
            if (this.pageNumber >= this.pages.size()) {
                this.pageNumber = 0;
                this.markDirtyClient();
            }
        }
        return this.pages;
    }

    public boolean hasBook() {
        return !this.currentBook.func_190926_b();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    private boolean pageDec(EntityPlayer player) {
        ImmCraftPacketHandler.INSTANCE.sendTo((IMessage)new PacketPageFlip(this.func_174877_v(), -1), (EntityPlayerMP)player);
        return true;
    }

    private boolean pageInc(EntityPlayer player) {
        ImmCraftPacketHandler.INSTANCE.sendTo((IMessage)new PacketPageFlip(this.func_174877_v(), 1), (EntityPlayerMP)player);
        return true;
    }

    public void pageDecClient() {
        if (this.pageNumber > 0) {
            --this.pageNumber;
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            BookStandTE.playPageTurn(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void pageIncClient() {
        if (this.pages != null && this.pageNumber < this.pages.size() - 1) {
            ++this.pageNumber;
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            BookStandTE.playPageTurn(this.func_145831_w(), this.func_174877_v());
        }
    }

    public static int findPageForSection(List<BookPage> pages, String section) {
        for (int i = 0; i < pages.size(); ++i) {
            for (RenderSection s : pages.get(i).getSections()) {
                if (!section.equals(s.getName())) continue;
                return i;
            }
        }
        return -1;
    }

    private void gotoPageClient(String section) {
        if (this.pages != null) {
            if ("<".equals(section)) {
                this.pageDecClient();
            } else if (">".equals(section)) {
                this.pageIncClient();
            } else if ("^".equals(section)) {
                if (this.pageNumber != 0) {
                    this.pageNumber = 0;
                    this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
                    BookStandTE.playPageTurn(this.func_145831_w(), this.func_174877_v());
                }
            } else {
                int number = BookStandTE.findPageForSection(this.pages, section);
                if (number != -1 && number < this.pages.size() && this.pageNumber != number) {
                    this.pageNumber = number;
                    this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
                    BookStandTE.playPageTurn(this.func_145831_w(), this.func_174877_v());
                }
            }
        }
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public static void playPageTurn(World world, BlockPos pos) {
        if (GeneralConfiguration.basePageTurnVolume > 0.01f) {
            SoundController.playPageturn(world, pos, GeneralConfiguration.basePageTurnVolume);
        }
    }

    public EnumStandState getState() {
        if (this.currentBook.func_190926_b()) {
            return EnumStandState.EMPTY;
        }
        if (this.pageNumber == 0) {
            return EnumStandState.CLOSED;
        }
        return EnumStandState.OPEN;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("book")) {
            this.currentBook = new ItemStack(compound.func_74775_l("book"));
        } else {
            this.currentBook = ItemStack.field_190927_a;
            this.pages = null;
            this.pageNumber = 0;
            this.result = null;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (!this.currentBook.func_190926_b()) {
            NBTTagCompound compound = new NBTTagCompound();
            this.currentBook.func_77955_b(compound);
            tagCompound.func_74782_a("book", (NBTBase)compound);
        }
        return tagCompound;
    }

    @Override
    public boolean onActivate(EntityPlayer player) {
        boolean rc = super.onActivate(player);
        if (this.func_145831_w().field_72995_K) {
            if (this.pageNumber == 0 && !player.func_70093_af()) {
                this.pageIncClient();
                return true;
            }
            if (this.result != null && !player.func_70093_af()) {
                this.gotoPageClient(this.result);
                return true;
            }
            return false;
        }
        if (rc) {
            return rc;
        }
        if (!this.currentBook.func_190926_b()) {
            if (player.func_70093_af()) {
                InventoryHelper.giveItemToPlayer(player, this.currentBook);
                this.currentBook = ItemStack.field_190927_a;
                this.markDirtyClient();
            }
            return true;
        }
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() instanceof IBook) {
                this.currentBook = heldItem.func_77979_a(1);
                player.field_71070_bA.func_75142_b();
                this.markDirtyClient();
                return true;
            }
            TextComponentString component = new TextComponentString(TextFormatting.YELLOW + "This is not a supported book!");
            if (player instanceof EntityPlayer) {
                player.func_146105_b((ITextComponent)component, false);
            } else {
                player.func_145747_a((ITextComponent)component);
            }
            return false;
        }
        return rc;
    }
}

