/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.bundle;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.immcraft.blocks.bundle.BundleISBM;
import mcjty.immcraft.blocks.bundle.BundleTE;
import mcjty.immcraft.blocks.bundle.UnlistedCableProperty;
import mcjty.immcraft.blocks.generic.GenericBlockWithTE;
import mcjty.immcraft.cables.CableSection;
import mcjty.immcraft.multiblock.MultiBlockData;
import mcjty.immcraft.multiblock.MultiBlockNetwork;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.BaseBlock;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BundleBlock
extends GenericBlockWithTE<BundleTE> {
    public static final UnlistedCableProperty CABLES = new UnlistedCableProperty("cables");

    public BundleBlock() {
        super(Material.field_151580_n, "bundle", BundleTE.class, false);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public void initModel() {
        McJtyLib.proxy.initStateMapper((Block)this, BundleISBM.BAKED_MODEL);
    }

    @SideOnly(value=Side.CLIENT)
    public void initItemModel() {
        Item itemBlock = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("immcraft", "bundle"));
        ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation(this.getRegistryName(), "inventory");
        boolean DEFAULT_ITEM_SUBTYPE = false;
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(itemBlock, 0, itemModelResourceLocation);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof BundleTE) {
            BundleTE bundleTE = (BundleTE)te;
            for (CableSection section : bundleTE.getCableSections()) {
                int networkId = section.getId();
                if (networkId == -1) continue;
                String networkName = section.getType().getCableHandler().getNetworkName(section.getSubType());
                MultiBlockNetwork network = MultiBlockData.getNetwork(networkName);
                Object multiBlock = network.getOrCreateMultiBlock(networkId);
                network.refreshInfo(networkId);
                probeInfo.text(TextFormatting.GREEN + "Id: " + networkId + " (Size: " + multiBlock.getBlockCount() + ")");
                if (mode != ProbeMode.EXTENDED) continue;
                probeInfo.text(TextFormatting.YELLOW + section.getType().getReadableName() + ": " + section.getConnection(0) + " : " + bundleTE.func_174877_v() + " : " + section.getConnection(1));
            }
        }
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        BundleTE bundleTE = (BundleTE)accessor.getTileEntity();
        for (CableSection section : bundleTE.getCableSections()) {
            int networkId = section.getId();
            if (networkId == -1) continue;
            String networkName = section.getType().getCableHandler().getNetworkName(section.getSubType());
            MultiBlockNetwork network = MultiBlockData.getNetwork(networkName);
            Object multiBlock = network.getOrCreateMultiBlock(networkId);
            network.refreshInfo(networkId);
            currenttip.add(TextFormatting.GREEN + "Id: " + networkId + " (Size: " + multiBlock.getBlockCount() + ")");
            if (!accessor.getPlayer().func_70093_af()) continue;
            currenttip.add(TextFormatting.YELLOW + section.getType().getReadableName() + ": " + section.getConnection(0) + " : " + bundleTE.func_174877_v() + " : " + section.getConnection(1));
        }
        return currenttip;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BundleTE) {
            ((BundleTE)te).checkConnections();
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BundleTE) {
            ((BundleTE)te).removeAllCables();
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{CABLES};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BundleTE) {
            BundleTE bundleTE = (BundleTE)te;
            List cables = bundleTE.getCableSections().stream().map(cable -> cable.getRenderer(pos)).collect(Collectors.toList());
            return extendedBlockState.withProperty((IUnlistedProperty)CABLES, cables);
        }
        return extendedBlockState;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }
}

