/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.chest;

import javax.annotation.Nonnull;
import mcjty.immcraft.ImmersiveCraft;
import mcjty.immcraft.api.IImmersiveCraft;
import mcjty.immcraft.api.rendering.HandleTESR;
import mcjty.immcraft.blocks.ModBlocks;
import mcjty.immcraft.blocks.chest.ChestTE;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChestTESR
extends HandleTESR<ChestTE> {
    private IModel lidModel;
    private IBakedModel bakedLidModel;

    public ChestTESR() {
        super(ModBlocks.chestBlock);
        this.textOffset = new Vec3d(0.0, 0.0, -0.2);
    }

    @Override
    @Nonnull
    protected IImmersiveCraft getApi() {
        return ImmersiveCraft.api;
    }

    private IBakedModel getBakedLidModel() {
        if (this.bakedLidModel == null) {
            try {
                this.lidModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("immcraft", "block/chestlid.obj"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.bakedLidModel = this.lidModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        return this.bakedLidModel;
    }

    @Override
    protected void renderHandles(ChestTE tileEntity) {
        if (tileEntity.isOpen() || tileEntity.getOpening() < -2.0) {
            super.renderHandles(tileEntity);
        }
    }

    @Override
    protected void renderExtra(ChestTE tileEntity) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)0.9f, (float)-0.5f);
        GlStateManager.func_179114_b((float)((float)tileEntity.getOpening()), (float)1.0f, (float)0.0f, (float)0.0f);
        if (tileEntity.isOpen() && tileEntity.getOpening() > -60.0) {
            tileEntity.setOpening(tileEntity.getOpening() - 3.0);
            if (tileEntity.getOpening() < -60.0) {
                tileEntity.setOpening(-60.0);
            }
        } else if (!tileEntity.isOpen() && tileEntity.getOpening() < 0.0) {
            tileEntity.setOpening(tileEntity.getOpening() + 3.0);
            if (tileEntity.getOpening() > 0.0) {
                tileEntity.setOpening(0.0);
            }
        }
        GlStateManager.func_179109_b((float)(-tileEntity.func_174877_v().func_177958_n()), (float)(-tileEntity.func_174877_v().func_177956_o() - 1), (float)(-tileEntity.func_174877_v().func_177952_p()));
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = tileEntity.func_145831_w();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, this.getBakedLidModel(), world.func_180495_p(tileEntity.func_174877_v()), tileEntity.func_174877_v().func_177984_a(), Tessellator.func_178181_a().func_178180_c(), true);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    public static void register() {
        ClientRegistry.bindTileEntitySpecialRenderer(ChestTE.class, (TileEntitySpecialRenderer)new ChestTESR());
    }
}

