/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.foliage;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.immcraft.api.helpers.InventoryHelper;
import mcjty.immcraft.blocks.foliage.EnumAmount;
import mcjty.immcraft.blocks.foliage.PropertyAmount;
import mcjty.immcraft.blocks.foliage.SticksTE;
import mcjty.immcraft.blocks.generic.GenericBlockWithTE;
import mcjty.immcraft.varia.BlockTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SticksBlock
extends GenericBlockWithTE<SticksTE> {
    public static final PropertyAmount AMOUNT = PropertyAmount.create("amount", Arrays.stream(EnumAmount.values()).collect(Collectors.toList()));
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    public static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)0.4f, (double)0.9f);

    public SticksBlock() {
        super(Material.field_151594_q, "sticks", SticksTE.class, true);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof SticksTE) {
            SticksTE sticksTE = (SticksTE)te;
            probeInfo.text(TextFormatting.GREEN + "Sticks: " + sticksTE.getSticks());
        }
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        SticksTE sticksTE = (SticksTE)accessor.getTileEntity();
        currenttip.add(TextFormatting.GREEN + "Sticks: " + sticksTE.getSticks());
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        super.func_189540_a(state, worldIn, pos, blockIn, p_189540_5_);
        if (!this.canBlockStay(worldIn, pos.func_177977_b())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return BlockTools.isTopValidAndSolid(worldIn, pos.func_177977_b());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (te instanceof SticksTE) {
            SticksTE sticksTE = (SticksTE)te;
            Boolean burning = sticksTE.getBurnTime() > 0;
            state = state.func_177226_a((IProperty)BURNING, (Comparable)burning);
            int cnt = sticksTE.getSticks();
            if (cnt <= 3) {
                return state.func_177226_a((IProperty)AMOUNT, (Comparable)((Object)EnumAmount.SINGLE));
            }
            if (cnt <= 6) {
                return state.func_177226_a((IProperty)AMOUNT, (Comparable)((Object)EnumAmount.DOUBLE));
            }
            if (cnt <= 9) {
                return state.func_177226_a((IProperty)AMOUNT, (Comparable)((Object)EnumAmount.TRIPPLE));
            }
            return state.func_177226_a((IProperty)AMOUNT, (Comparable)((Object)EnumAmount.ALL));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, AMOUNT, BURNING});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SticksTE) {
            InventoryHelper.spawnItemStack(world, pos, new ItemStack(Items.field_151055_y, ((SticksTE)te).getSticks()));
        }
        super.func_180663_b(world, pos, state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.isBurning(world, pos)) {
            return 14;
        }
        return 0;
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SticksTE) {
            return ((SticksTE)te).getBurnTime() > 0;
        }
        return false;
    }

    public int func_149738_a(World world) {
        return 30;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!this.isBurning((IBlockAccess)world, pos)) {
            return;
        }
        if (world.func_82736_K().func_82766_b("doFireTick")) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + random.nextInt(10));
            boolean flag1 = world.func_180502_D(pos);
            int b0 = 0;
            if (flag1) {
                b0 = -50;
            }
        }
    }

    private int getChanceOfNeighborsEncouragingFire(World world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(world.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFlammability((IBlockAccess)world, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    private void tryCatchFire(World world, BlockPos pos, int chance, Random random, EnumFacing face) {
        int j1 = world.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)world, pos, face);
        if (random.nextInt(chance) < j1) {
            boolean flag;
            boolean bl = flag = world.func_180495_p(pos).func_177230_c() == Blocks.field_150335_W;
            if (random.nextInt(20) < 5 && !world.func_175727_C(pos)) {
                int k1 = 10 + random.nextInt(5) / 4;
                if (k1 > 15) {
                    k1 = 15;
                }
                world.func_180501_a(pos, Blocks.field_150480_ab.func_176203_a(k1), 3);
            } else {
                world.func_175698_g(pos);
            }
            if (flag) {
                Blocks.field_150335_W.func_176206_d(world, pos, world.func_180495_p(pos));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        block13: {
            block12: {
                float f2;
                float f1;
                float f;
                int l;
                if (!this.isBurning((IBlockAccess)world, pos)) {
                    return;
                }
                if (random.nextInt(24) == 0) {
                    world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
                }
                if (state.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) || Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) break block12;
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, pos.func_177976_e(), EnumFacing.EAST)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)pos.func_177958_n() + random.nextFloat() * 0.1f;
                        f1 = (float)pos.func_177956_o() + random.nextFloat();
                        f2 = (float)pos.func_177952_p() + random.nextFloat();
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, pos.func_177974_f(), EnumFacing.WEST)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)(pos.func_177958_n() + 1) - random.nextFloat() * 0.1f;
                        f1 = (float)pos.func_177956_o() + random.nextFloat();
                        f2 = (float)pos.func_177952_p() + random.nextFloat();
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, pos.func_177978_c(), EnumFacing.SOUTH)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)pos.func_177958_n() + random.nextFloat();
                        f1 = (float)pos.func_177956_o() + random.nextFloat();
                        f2 = (float)pos.func_177952_p() + random.nextFloat() * 0.1f;
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, pos.func_177968_d(), EnumFacing.NORTH)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)pos.func_177958_n() + random.nextFloat();
                        f1 = (float)pos.func_177956_o() + random.nextFloat();
                        f2 = (float)(pos.func_177952_p() + 1) - random.nextFloat() * 0.1f;
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (!Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN)) break block13;
                for (l = 0; l < 2; ++l) {
                    f = (float)pos.func_177958_n() + random.nextFloat();
                    f1 = (float)(pos.func_177956_o() + 1) - random.nextFloat() * 0.1f;
                    f2 = (float)pos.func_177952_p() + random.nextFloat();
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
                }
                break block13;
            }
            for (int l = 0; l < 3; ++l) {
                float f = (float)pos.func_177958_n() + random.nextFloat();
                float f1 = (float)pos.func_177956_o() + random.nextFloat() * 0.5f + 0.5f;
                float f2 = (float)pos.func_177952_p() + random.nextFloat();
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

