/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.furnace;

import mcjty.immcraft.api.handles.HandleSelector;
import mcjty.immcraft.blocks.furnace.FurnaceTE;
import mcjty.immcraft.blocks.furnace.FurnaceTESR;
import mcjty.immcraft.blocks.generic.GenericBlockWithTE;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FurnaceBlock
extends GenericBlockWithTE<FurnaceTE> {
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");

    public FurnaceBlock() {
        super(Material.field_151576_e, "furnace", FurnaceTE.class, true);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.addSelector(new HandleSelector("fuel", new AxisAlignedBB(0.0, 0.1, 0.3, 1.0, 0.48, 0.8)));
        this.addSelector(new HandleSelector("input", new AxisAlignedBB(0.0, 0.51, 0.3, 0.5, 0.99, 0.8)));
        this.addSelector(new HandleSelector("output", new AxisAlignedBB(0.51, 0.51, 0.3, 1.0, 0.99, 0.8)));
    }

    public void initModel() {
        super.initModel();
        FurnaceTESR.register();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FurnaceTE) {
            if (((FurnaceTE)te).getBurnTime() > 0) {
                return 13;
            }
            return 0;
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (te instanceof FurnaceTE) {
            FurnaceTE furnaceTE = (FurnaceTE)te;
            Boolean burning = furnaceTE.getBurnTime() > 0;
            return state.func_177226_a((IProperty)BURNING, (Comparable)burning);
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, BURNING});
    }
}

