/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.generic.handles;

import java.util.List;
import mcjty.immcraft.api.handles.DefaultInterfaceHandle;
import mcjty.immcraft.api.helpers.Broadcaster;
import mcjty.immcraft.api.input.KeyType;
import mcjty.immcraft.blocks.generic.handles.ICraftingContainer;
import mcjty.immcraft.schemas.Schema;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class CraftingInterfaceHandle
extends DefaultInterfaceHandle {
    public CraftingInterfaceHandle(String selectorID) {
        super(selectorID);
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public boolean isCrafting() {
        return true;
    }

    @Override
    public ItemStack getCurrentStack(TileEntity te) {
        ICraftingContainer craftingContainer = (ICraftingContainer)te;
        Schema schema = craftingContainer.getCurrentSchema();
        return schema.getResult();
    }

    @Override
    public ItemStack extractOutput(TileEntity te, EntityPlayer player, int amount) {
        if (te instanceof ICraftingContainer) {
            List<ItemStack> inventory;
            ICraftingContainer craftingContainer = (ICraftingContainer)te;
            Schema schema = craftingContainer.getCurrentSchema();
            if (schema.match(inventory = craftingContainer.getInventory(), player)) {
                ItemStack result = schema.craft(inventory, player);
                craftingContainer.updateInventory(inventory);
                player.field_71070_bA.func_75142_b();
                return result;
            }
            List<ItemStack> missing = schema.getMissing(inventory, player);
            for (ItemStack stack : missing) {
                Broadcaster.broadcast(te.func_145831_w(), te.func_174877_v(), "Missing block " + stack.func_82833_r(), 6.0f);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void onKeyPress(TileEntity genericTE, KeyType keyType, EntityPlayer player) {
        if (genericTE instanceof ICraftingContainer) {
            ICraftingContainer craftingContainer = (ICraftingContainer)genericTE;
            if (keyType.equals((Object)KeyType.KEY_PREVIOUSITEM)) {
                craftingContainer.previousSchema();
            } else if (keyType.equals((Object)KeyType.KEY_NEXTITEM)) {
                craftingContainer.nextSchema();
            }
        }
    }
}

