/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.shelf;

import java.util.Random;
import mcjty.immcraft.api.book.IBook;
import mcjty.immcraft.api.handles.InputInterfaceHandle;
import mcjty.immcraft.config.GeneralConfiguration;
import mcjty.immcraft.items.BookType;
import mcjty.immcraft.items.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class BookHandle
extends InputInterfaceHandle {
    private BookType bookType = null;
    private ItemStack cachedBookItem = null;
    private Random random = new Random();

    public BookHandle(String selectorID) {
        super(selectorID);
    }

    @Override
    public boolean acceptAsInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof IBook) {
                return true;
            }
            ResourceLocation registryName = item.getRegistryName();
            return GeneralConfiguration.validBooks.containsKey(registryName.toString());
        }
        return false;
    }

    public void clearCachedBook(TileEntity genericTE) {
        if (this.getCurrentStack(genericTE).func_190926_b()) {
            this.bookType = null;
            this.cachedBookItem = null;
        }
    }

    private BookType getBookType(ItemStack stack) {
        if (this.bookType == null) {
            this.bookType = BookType.BOOK_SMALL_RED;
            Item item = stack.func_77973_b();
            ResourceLocation registryName = item.getRegistryName();
            String type = GeneralConfiguration.validBooks.get(registryName.toString());
            this.bookType = type == null ? BookType.BOOK_YELLOW : ("*".equals(type) ? BookType.values()[this.random.nextInt(8)] : BookType.getTypeByName(type));
        }
        return this.bookType;
    }

    @Override
    public ItemStack getRenderStack(TileEntity inventoryTE, ItemStack stack) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (this.cachedBookItem == null) {
            this.cachedBookItem = new ItemStack((Item)ModItems.dummyBook, 1, this.getBookType(stack).ordinal());
        }
        return this.cachedBookItem;
    }
}

