/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.workbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcjty.immcraft.api.handles.InputInterfaceHandle;
import mcjty.immcraft.api.helpers.InventoryHelper;
import mcjty.immcraft.api.helpers.NBTHelper;
import mcjty.immcraft.blocks.ModBlocks;
import mcjty.immcraft.blocks.generic.GenericImmcraftTE;
import mcjty.immcraft.blocks.generic.GenericInventoryTE;
import mcjty.immcraft.blocks.generic.handles.CraftingInterfaceHandle;
import mcjty.immcraft.blocks.generic.handles.ICraftingContainer;
import mcjty.immcraft.items.ModItems;
import mcjty.immcraft.schemas.Schema;
import mcjty.immcraft.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class WorkbenchSecondaryTE
extends GenericInventoryTE
implements ICraftingContainer {
    public static final int SLOT_TOOL = 0;
    private Schema[] baseSchemas = new Schema[]{new Schema("saw", new ItemStack((Item)ModItems.saw), new ItemStack(Items.field_151055_y, 3), new ItemStack((Block)ModBlocks.rockBlock, 2)), new Schema("chisel", new ItemStack((Item)ModItems.chisel), new ItemStack(Items.field_151055_y, 1), new ItemStack((Block)ModBlocks.rockBlock, 2)), new Schema("flint & steel", new ItemStack(Items.field_151033_d), new ItemStack(Items.field_151145_ak, 1), new ItemStack((Block)ModBlocks.rockBlock, 1)), new Schema("pickaxe", new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151055_y, 2), new ItemStack((Block)ModBlocks.rockBlock, 3)), new Schema("axe", new ItemStack(Items.field_151049_t), new ItemStack(Items.field_151055_y, 2), new ItemStack((Block)ModBlocks.rockBlock, 3))};
    private Schema[] sawSchemas = new Schema[]{new Schema("planks", new ItemStack(Blocks.field_150344_f, 4), new ItemStack(Blocks.field_150364_r)), new Schema("sticks", new ItemStack(Items.field_151055_y, 4), new ItemStack(Blocks.field_150344_f, 2))};
    private Schema[] chiselSchemas = new Schema[]{new Schema("furnace", new ItemStack((Block)ModBlocks.furnaceBlock), new ItemStack(Blocks.field_150347_e, 8)), new Schema("chest", new ItemStack((Block)ModBlocks.chestBlock), new ItemStack(Blocks.field_150344_f, 8)), new Schema("cupboard", new ItemStack((Block)ModBlocks.cupboardBlock), new ItemStack(Blocks.field_150344_f, 8))};
    private int currentSchema = 0;

    public WorkbenchSecondaryTE() {
        super(1);
        this.addInterfaceHandle(((InputInterfaceHandle)new InputInterfaceHandle("tool").slot(0)).input(new ItemStack((Item)ModItems.chisel)).input(new ItemStack((Item)ModItems.saw)));
        this.addInterfaceHandle(new CraftingInterfaceHandle("craft"));
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.currentSchema = tagCompound.func_74762_e("schema");
    }

    @Override
    public void writeToNBT(NBTHelper helper) {
        super.writeToNBT(helper);
        helper.set("schema", this.currentSchema);
    }

    @Override
    public List<ItemStack> getInventory() {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        EnumFacing left = ModBlocks.workbenchSecondaryBlock.getLeftDirection(this.func_145831_w().func_180495_p(this.func_174877_v()));
        Optional<IInventory> inv = InventoryHelper.getInventory(this.func_145831_w(), this.func_174877_v().func_177972_a(left));
        if (inv.isPresent()) {
            inventory.add(inv.get().func_70301_a(0));
            inventory.add(inv.get().func_70301_a(1));
            inventory.add(inv.get().func_70301_a(2));
            inventory.add(inv.get().func_70301_a(3));
        }
        return inventory;
    }

    @Override
    public void updateInventory(List<ItemStack> inventory) {
        EnumFacing left = ModBlocks.workbenchSecondaryBlock.getLeftDirection(this.func_145831_w().func_180495_p(this.func_174877_v()));
        Optional te = BlockTools.getTE(null, (IBlockAccess)this.func_145831_w(), this.func_174877_v().func_177972_a(left));
        if (te.isPresent() && te.get() instanceof IInventory) {
            IInventory inv = (IInventory)te.get();
            for (int i = 0; i < 4; ++i) {
                ItemStack itemStack = inventory.get(i);
                if (itemStack.func_190926_b()) {
                    inv.func_70299_a(0 + i, ItemStack.field_190927_a);
                    continue;
                }
                inv.func_70299_a(0 + i, itemStack);
            }
            ((GenericImmcraftTE)((Object)te.get())).markDirtyClient();
        }
    }

    private Schema[] getActiveSchemas() {
        ItemStack tool = this.inventoryHelper.getStackInSlot(0);
        if (tool.func_190926_b()) {
            return this.baseSchemas;
        }
        if (tool.func_77973_b() == ModItems.chisel) {
            return this.chiselSchemas;
        }
        if (tool.func_77973_b() == ModItems.saw) {
            return this.sawSchemas;
        }
        return this.baseSchemas;
    }

    @Override
    public Schema getCurrentSchema() {
        Schema[] activeSchemas = this.getActiveSchemas();
        if (this.currentSchema >= activeSchemas.length) {
            this.currentSchema = 0;
        }
        return activeSchemas[this.currentSchema];
    }

    @Override
    public void nextSchema() {
        Schema[] activeSchemas = this.getActiveSchemas();
        ++this.currentSchema;
        if (this.currentSchema >= activeSchemas.length) {
            this.currentSchema = 0;
        }
        this.markDirtyClient();
    }

    @Override
    public void previousSchema() {
        Schema[] activeSchemas = this.getActiveSchemas();
        --this.currentSchema;
        if (this.currentSchema < 0) {
            this.currentSchema = activeSchemas.length - 1;
        }
        this.markDirtyClient();
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.currentSchema = 0;
    }
}

