/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.books;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.immcraft.books.RenderSection;
import mcjty.immcraft.books.elements.BookElement;

public class BookSection {
    private final String name;
    private final List<BookElement> elements = new ArrayList<BookElement>();

    public BookSection(@Nullable String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPagebreak() {
        return this.name == null;
    }

    public void addElement(BookElement element) {
        this.elements.add(element);
    }

    public List<BookElement> getElements() {
        return this.elements;
    }

    public int getWidth() {
        int maxwidth = 0;
        int curw = 0;
        for (BookElement element : this.elements) {
            if (element.getWidth(curw) == -1) {
                curw = 0;
                continue;
            }
            if ((curw += element.getWidth(curw)) <= maxwidth) continue;
            maxwidth = curw;
        }
        return maxwidth;
    }

    public int getHeight() {
        int maxheight = 0;
        int curh = 0;
        for (BookElement element : this.elements) {
            curh = Math.max(curh, element.getHeight());
            if (element.getWidth(0) == -1) {
                maxheight += curh;
                curh = 0;
                continue;
            }
            if (element.getWidth(0) == -2) {
                maxheight += curh;
                curh = 0;
                continue;
            }
            if (element.getWidth(0) != -3) continue;
            if (curh == 0) {
                curh = element.getHeight();
            }
            maxheight += curh;
            curh = 0;
        }
        return maxheight;
    }

    private void process(RenderSection renderSection, List<BookElement> lineRender, Cursor cursor) {
        int x = 0;
        for (BookElement element : lineRender) {
            int width = element.getWidth(x);
            renderSection.addElement(element.createRenderElement(x, cursor.getY(), width, cursor.getMaxh()));
            x += width;
        }
        lineRender.clear();
    }

    public RenderSection renderAtWidth(int maxwidth) {
        RenderSection renderSection = new RenderSection(this.name);
        ArrayList<BookElement> lineRender = new ArrayList<BookElement>();
        Cursor cursor = new Cursor(maxwidth);
        for (BookElement element : this.elements) {
            int w = element.getWidth(cursor.curx);
            int h = element.getHeight();
            if (w == -1) {
                this.process(renderSection, lineRender, cursor);
                cursor.newline();
                continue;
            }
            if (w == -3) {
                if (cursor.getMaxh() == 0) {
                    cursor.add(1, element.getHeight());
                }
                this.process(renderSection, lineRender, cursor);
                cursor.newline();
                continue;
            }
            if (w == -2) {
                lineRender.add(element);
                this.process(renderSection, lineRender, cursor);
                cursor.newline();
                continue;
            }
            if (cursor.fits(w)) {
                lineRender.add(element);
                cursor.add(w, h);
                continue;
            }
            this.process(renderSection, lineRender, cursor);
            cursor.newline();
            lineRender.add(element);
            cursor.add(element.getWidth(cursor.curx), h);
        }
        this.process(renderSection, lineRender, cursor);
        cursor.consolidate();
        renderSection.setWidth(cursor.getMaxw());
        renderSection.setHeight(cursor.getY());
        return renderSection;
    }

    public static class Cursor {
        private final int maxwidth;
        private int curx = 0;
        private int cury = 0;
        private int maxh = 0;
        private int maxw = 0;

        public Cursor(int maxwidth) {
            this.maxwidth = maxwidth;
        }

        public int getX() {
            return this.curx;
        }

        public int getY() {
            return this.cury;
        }

        public int getMaxh() {
            return this.maxh;
        }

        public int getMaxw() {
            return this.maxw;
        }

        public void newline() {
            this.cury += this.maxh;
            this.maxh = 0;
            this.curx = 0;
        }

        public void add(int w, int h) {
            this.curx += w;
            if (this.curx > this.maxw) {
                this.maxw = this.curx;
            }
            if (h > this.maxh) {
                this.maxh = h;
            }
        }

        public boolean fits(int w) {
            return this.curx + w <= this.maxwidth;
        }

        public int remaining() {
            return this.maxwidth - this.curx;
        }

        public int max() {
            return this.maxwidth;
        }

        public void consolidate() {
            if (this.curx > 0) {
                this.newline();
            }
        }
    }
}

