/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.books.renderers;

import mcjty.immcraft.books.TextElementFormat;
import mcjty.immcraft.books.renderers.RenderElement;
import mcjty.lib.font.TrueTypeFont;

public class RenderElementText
implements RenderElement {
    protected final String text;
    protected final int x;
    protected final int y;
    protected final int w;
    protected final int h;
    private final float r;
    private final float g;
    private final float b;
    protected TextElementFormat fmt;

    public RenderElementText(String text, int x, int y, int w, int h, TextElementFormat fmt) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.fmt = fmt;
        int value = fmt.getColor().func_193350_e();
        this.r = (float)(value >> 16 & 0xFF) / 255.0f;
        this.g = (float)(value >> 8 & 0xFF) / 255.0f;
        this.b = (float)(value & 0xFF) / 255.0f;
    }

    @Override
    public String render(int dy, float ix, float iy) {
        float red = this.r;
        float green = this.g;
        float blue = this.b;
        this.renderText(dy, red, green, blue);
        return null;
    }

    protected void renderText(int dy, float red, float green, float blue) {
        int w;
        int xx;
        int align = this.fmt.getAlign();
        int valign = this.fmt.getValign();
        float scale = this.fmt.getScale();
        TrueTypeFont font = this.fmt.getFont();
        if (align == -1) {
            xx = this.x;
        } else if (align == 1) {
            w = 768 - this.x;
            xx = (int)((float)(this.x + w) - font.getWidth(this.text) * scale);
        } else {
            w = 768 - this.x;
            xx = (int)((float)this.x + ((float)w - font.getWidth(this.text) * scale) / 2.0f);
        }
        int yy = valign == -1 ? this.y : (valign == 1 ? (int)((float)(this.y + this.h) - font.getHeight() * scale) : (int)((float)this.y + ((float)this.h - font.getHeight() * scale) / 2.0f));
        font.drawString((float)xx, (float)(512 - (yy + dy)), this.text, scale, scale, -512.0f / scale, new float[]{red, green, blue, 1.0f});
    }
}

