/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.events;

import java.util.Random;
import mcjty.immcraft.api.helpers.InventoryHelper;
import mcjty.immcraft.blocks.ModBlocks;
import mcjty.immcraft.blocks.foliage.SticksTE;
import mcjty.immcraft.blocks.inworldplacer.InWorldPlacerTE;
import mcjty.immcraft.blocks.inworldplacer.InWorldVerticalPlacerTE;
import mcjty.immcraft.config.GeneralConfiguration;
import mcjty.immcraft.varia.BlockTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.SoundTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ForgeEventHandlers {
    private Random random = new Random();

    @SubscribeEvent
    public void onPlayerRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        Item item = heldItem.func_77973_b();
        if (item == Items.field_151055_y) {
            this.placeSticksOrCreateFire((PlayerInteractEvent)event, player, block);
        } else if (item == Item.func_150898_a((Block)ModBlocks.rockBlock)) {
            this.spawnAxe((PlayerInteractEvent)event, player, block);
        } else if (item == Items.field_151049_t && (block == Blocks.field_150364_r || block == Blocks.field_150363_s)) {
            this.createWorkbench((PlayerInteractEvent)event);
        } else {
            if ((item == Items.field_151047_v || item == Items.field_151011_C || item == Items.field_151037_a || item == Items.field_151051_r || item == Items.field_151038_n) && block == Blocks.field_150349_c) {
                return;
            }
            if (GeneralConfiguration.allowRightClickPlacement && this.canBePlaced(item) && event.getWorld().func_175623_d(event.getPos().func_177984_a()) && BlockTools.isTopValidAndSolid(event.getWorld(), event.getPos()) && event.getFace() == EnumFacing.UP) {
                BlockTools.placeBlock(event.getWorld(), event.getPos().func_177984_a(), ModBlocks.inWorldPlacerBlock, player);
                BlockTools.getInventoryTE(event.getWorld(), event.getPos().func_177984_a()).ifPresent(p -> InWorldPlacerTE.addItems(p, player, heldItem));
                event.setCanceled(true);
            } else if (GeneralConfiguration.allowRightClickPlacement && this.canBePlaced(item) && event.getWorld().func_175623_d(event.getPos().func_177972_a(event.getFace())) && BlockTools.isSideValidAndSolid(event.getWorld(), event.getPos(), event.getFace(), block)) {
                BlockTools.placeBlock(event.getWorld(), event.getPos().func_177972_a(event.getFace()), ModBlocks.inWorldVerticalPlacerBlock, player);
                BlockTools.getInventoryTE(event.getWorld(), event.getPos().func_177972_a(event.getFace())).ifPresent(p -> InWorldVerticalPlacerTE.addItems(p, player, heldItem));
                event.setCanceled(true);
            }
        }
    }

    private void createWorkbench(PlayerInteractEvent event) {
        if (!GeneralConfiguration.createWorkbench) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir == EnumFacing.DOWN || dir == EnumFacing.UP) continue;
            BlockPos newpos = event.getPos().func_177972_a(dir);
            IBlockState state = event.getWorld().func_180495_p(newpos);
            Block block2 = state.func_177230_c();
            if (block2 != Blocks.field_150364_r && block2 != Blocks.field_150363_s) continue;
            event.getWorld().func_175698_g(newpos);
            int meta = OrientationTools.getHorizOrientationMeta((EnumFacing)dir.func_176746_e());
            event.getWorld().func_180501_a(event.getPos(), ModBlocks.workbenchBlock.func_176203_a(meta), 3);
            event.getWorld().func_180501_a(newpos, ModBlocks.workbenchSecondaryBlock.func_176203_a(meta), 3);
            event.setCanceled(true);
            return;
        }
    }

    private void spawnAxe(PlayerInteractEvent event, EntityPlayer player, Block block) {
        SticksTE sticksTE;
        TileEntity te;
        if (!GeneralConfiguration.allowMakingStoneAxe) {
            return;
        }
        if (block == ModBlocks.sticksBlock && (te = event.getWorld().func_175625_s(event.getPos())) instanceof SticksTE && (sticksTE = (SticksTE)te).getSticks() == 1) {
            sticksTE.setSticks(0);
            event.getWorld().func_175698_g(event.getPos());
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            player.field_71070_bA.func_75142_b();
            InventoryHelper.spawnItemStack(event.getWorld(), event.getPos(), new ItemStack(Items.field_151049_t));
            event.setCanceled(true);
        }
    }

    private void placeSticksOrCreateFire(PlayerInteractEvent event, EntityPlayer player, Block block) {
        if (block == ModBlocks.rockBlock) {
            SoundTools.playSound((World)event.getWorld(), (SoundEvent)SoundEvents.field_187649_bu, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (double)1.0, (double)(this.random.nextFloat() * 0.4f + 0.8f));
            if (this.random.nextFloat() < GeneralConfiguration.rockStickFireChance) {
                InventoryHelper.spawnItemStack(event.getWorld(), event.getPos(), new ItemStack((Block)ModBlocks.rockBlock));
                BlockTools.placeBlock(event.getWorld(), event.getPos(), ModBlocks.sticksBlock, player);
                TileEntity te = event.getWorld().func_175625_s(event.getPos());
                if (te instanceof SticksTE) {
                    SticksTE sticksTE = (SticksTE)te;
                    this.addSticks(player, sticksTE);
                    sticksTE.startBurn();
                }
            } else {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
        } else if (block == ModBlocks.sticksBlock) {
            TileEntity te = event.getWorld().func_175625_s(event.getPos());
            if (te instanceof SticksTE) {
                SticksTE sticksTE = (SticksTE)te;
                this.addSticks(player, sticksTE);
            }
        } else if (this.isValidPlacementSpot(event)) {
            BlockTools.placeBlock(event.getWorld(), event.getPos().func_177984_a(), ModBlocks.sticksBlock, player);
            TileEntity te = event.getWorld().func_175625_s(event.getPos().func_177984_a());
            if (te instanceof SticksTE) {
                SticksTE sticksTE = (SticksTE)te;
                this.addSticks(player, sticksTE);
            }
        }
    }

    private boolean isValidPlacementSpot(PlayerInteractEvent event) {
        return event.getWorld().func_175623_d(event.getPos().func_177984_a()) && BlockTools.isTopValidAndSolid(event.getWorld(), event.getPos());
    }

    private boolean canBePlaced(Item item) {
        return item instanceof ItemTool;
    }

    private void addSticks(EntityPlayer player, SticksTE sticksTE) {
        int amount = player.func_70093_af() ? Math.min(64 - sticksTE.getSticks(), player.func_184586_b(EnumHand.MAIN_HAND).func_190916_E()) : Math.min(64 - sticksTE.getSticks(), 1);
        if (amount > 0) {
            sticksTE.setSticks(sticksTE.getSticks() + amount);
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, amount);
            player.field_71070_bA.func_75142_b();
            sticksTE.markDirtyClient();
        }
    }

    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        Block block;
        if (!event.isSilkTouching() && ((block = event.getState().func_177230_c()) == Blocks.field_150362_t || block == Blocks.field_150361_u) && event.getHarvester() != null && this.random.nextFloat() < GeneralConfiguration.leavesDropSticksChance) {
            event.getDrops().add(new ItemStack(Items.field_151055_y));
        }
    }
}

