/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.multiblock;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import mcjty.immcraft.api.cable.ICableSection;
import mcjty.immcraft.api.cable.ICableSubType;
import mcjty.immcraft.api.cable.ICableType;
import mcjty.immcraft.api.multiblock.IMultiBlock;
import mcjty.immcraft.api.multiblock.IMultiBlockNetwork;
import mcjty.immcraft.blocks.bundle.BundleTE;
import mcjty.immcraft.cables.CableSection;
import mcjty.immcraft.multiblock.MultiBlockNetwork;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiBlockCableHelper {
    private static BundleTE getTile(World world, BlockPos pos, EnumFacing direction) {
        BlockPos newpos = direction == null ? pos : pos.func_177972_a(direction);
        TileEntity te = world.func_175625_s(newpos);
        if (te instanceof BundleTE) {
            return (BundleTE)te;
        }
        return null;
    }

    public static <T extends IMultiBlock> int addBlockToNetwork(IMultiBlockNetwork<T> network, ICableType type, ICableSubType subType, int networkId, World world, BlockPos thisCoord) {
        Set<Integer> excluded = MultiBlockCableHelper.getTile(world, thisCoord, null).getCableSections().stream().filter(s -> s.getType() == type && s.getSubType() == subType).map(CableSection::getId).collect(Collectors.toSet());
        IMultiBlock foundMb = null;
        for (EnumFacing direction : network.getDirections()) {
            IMultiBlock otherMb;
            CableSection connectableSection;
            BundleTE otherBlock = MultiBlockCableHelper.getTile(world, thisCoord, direction);
            if (otherBlock == null || (connectableSection = otherBlock.findConnectableSection(type, subType, excluded)) == null || !(otherMb = (IMultiBlock)((Object)connectableSection.getCable(world))).canConnect(null, thisCoord)) continue;
            foundMb = otherMb;
            networkId = connectableSection.getId();
            foundMb.addBlock(thisCoord);
            break;
        }
        MultiBlockNetwork n = (MultiBlockNetwork)network;
        if (foundMb == null) {
            networkId = n.newMultiBlock();
            n.getOrCreateMultiBlock(networkId).addBlock(thisCoord);
        } else {
            for (EnumFacing direction : network.getDirections()) {
                IMultiBlock otherMb;
                CableSection connectableSection;
                BundleTE otherBlock = MultiBlockCableHelper.getTile(world, thisCoord, direction);
                if (otherBlock == null || (connectableSection = otherBlock.findConnectableSection(type, subType, excluded)) == null || (otherMb = (IMultiBlock)((Object)connectableSection.getCable(world))) == foundMb || !foundMb.canConnect(otherMb, thisCoord)) continue;
                Integer otherId = connectableSection.getId();
                foundMb.merge(world, networkId, otherMb, connectableSection.getId());
                n.deleteMultiBlock(otherId);
                break;
            }
        }
        return networkId;
    }

    public static <T extends IMultiBlock> void removeBlockFromNetwork(IMultiBlockNetwork<T> network, ICableType type, ICableSubType subType, int networkId, World world, BlockPos thisCoord) {
        BundleTE thisTile = MultiBlockCableHelper.getTile(world, thisCoord, null);
        ICableSection isection = thisTile.findSection(type, subType, networkId);
        CableSection section = (CableSection)isection;
        IMultiBlock mb = (IMultiBlock)((Object)section.getCable(world));
        Collection<? extends IMultiBlock> multiBlocks = mb.remove(world, thisCoord);
        MultiBlockNetwork n = (MultiBlockNetwork)network;
        n.deleteMultiBlock(section.getId());
        for (IMultiBlock iMultiBlock : multiBlocks) {
            int id = n.createMultiBlock(iMultiBlock);
            for (BlockPos b : iMultiBlock.getBlocks()) {
                BundleTE te = MultiBlockCableHelper.getTile(world, b, null);
                if (te == null) continue;
                ICableSection otherSection = te.findSection(type, subType, networkId);
                ((CableSection)otherSection).setId(id);
                te.markDirtyClient();
            }
        }
    }
}

