/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.multiblock;

import java.util.HashMap;
import java.util.Map;
import mcjty.immcraft.api.multiblock.IMultiBlock;
import mcjty.immcraft.api.multiblock.IMultiBlockClientInfo;
import mcjty.immcraft.api.multiblock.IMultiBlockFactory;
import mcjty.immcraft.api.multiblock.IMultiBlockNetwork;
import mcjty.immcraft.api.multiblock.IMultiBlockTile;
import mcjty.immcraft.multiblock.MultiBlockData;
import mcjty.immcraft.multiblock.MultiblockInfoPacketServer;
import mcjty.immcraft.network.ImmCraftPacketHandler;
import mcjty.immcraft.network.PacketGetInfoFromServer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MultiBlockNetwork<T extends IMultiBlock>
implements IMultiBlockNetwork<T> {
    private int lastId = 0;
    private final String networkName;
    private final IMultiBlockFactory<T> factory;
    private final Map<Integer, T> multiblocks = new HashMap<Integer, T>();
    private final EnumFacing[] directions;
    private final Map<Integer, Long> lastUpdateTime = new HashMap<Integer, Long>();
    private final Map<Integer, IMultiBlockClientInfo> clientInfos = new HashMap<Integer, IMultiBlockClientInfo>();

    public MultiBlockNetwork(String networkName, IMultiBlockFactory<T> factory, EnumFacing[] directions) {
        this.networkName = networkName;
        this.factory = factory;
        MultiBlockData.networks.put(networkName, this);
        this.directions = directions;
    }

    @Override
    public String getNetworkName() {
        return this.networkName;
    }

    public IMultiBlockFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public void save(World world) {
        MultiBlockData.get(world).save();
    }

    public void registerClientInfo(int blockId, IMultiBlockClientInfo clientInfo) {
        this.clientInfos.put(blockId, clientInfo);
    }

    @Override
    public IMultiBlockClientInfo getClientInfo(int blockId) {
        return this.clientInfos.get(blockId);
    }

    @Override
    public void refreshInfo(int id) {
        long time = System.currentTimeMillis();
        if (!this.lastUpdateTime.containsKey(id) || time - this.lastUpdateTime.get(id) > 100L) {
            this.lastUpdateTime.put(id, time);
            ImmCraftPacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer(new MultiblockInfoPacketServer(this.networkName, id)));
        }
    }

    public void clear() {
        this.multiblocks.clear();
        this.lastId = 0;
    }

    @Override
    public boolean fromThisNetwork(IMultiBlockTile tile) {
        Object multiBlock = tile.getMultiBlock();
        return this.factory.isSameType((IMultiBlock)multiBlock);
    }

    @Override
    public int createMultiBlock(T mb) {
        int id = this.newMultiBlock();
        this.multiblocks.put(id, mb);
        return id;
    }

    @Override
    public T getOrCreateMultiBlock(int id) {
        IMultiBlock mb = (IMultiBlock)this.multiblocks.get(id);
        if (mb == null) {
            mb = this.factory.create();
            this.multiblocks.put(id, mb);
        }
        return (T)mb;
    }

    public T getMultiblock(int id) {
        return (T)((IMultiBlock)this.multiblocks.get(id));
    }

    @Override
    public void deleteMultiBlock(int id) {
        this.multiblocks.remove(id);
    }

    @Override
    public EnumFacing[] getDirections() {
        return this.directions;
    }

    @Override
    public int newMultiBlock() {
        ++this.lastId;
        return this.lastId;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.multiblocks.clear();
        NBTTagList lst = tagCompound.func_150295_c("multiblocks", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            T value = this.factory.create();
            value.readFromNBT(tc);
            this.multiblocks.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, T> entry : this.multiblocks.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("channel", entry.getKey().intValue());
            ((IMultiBlock)entry.getValue()).writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("multiblocks", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
    }
}

