/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.multiblock;

import io.netty.buffer.ByteBuf;
import mcjty.immcraft.api.multiblock.IMultiBlockClientInfo;
import mcjty.immcraft.multiblock.MultiBlockData;
import mcjty.immcraft.multiblock.MultiBlockNetwork;
import mcjty.immcraft.network.InfoPacketClient;
import mcjty.lib.network.NetworkTools;
import net.minecraft.client.entity.EntityPlayerSP;

public class MultiblockInfoPacketClient
implements InfoPacketClient {
    private String networkName;
    private int id;
    private IMultiBlockClientInfo clientInfo;

    public MultiblockInfoPacketClient() {
    }

    public MultiblockInfoPacketClient(String networkName, int id, IMultiBlockClientInfo clientInfo) {
        this.networkName = networkName;
        this.id = id;
        this.clientInfo = clientInfo;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.networkName = NetworkTools.readString((ByteBuf)buf);
        this.id = buf.readInt();
        MultiBlockNetwork network = MultiBlockData.getNetwork(this.networkName);
        this.clientInfo = network.getFactory().createClientInfo();
        this.clientInfo.readFromBuf(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.networkName);
        buf.writeInt(this.id);
        this.clientInfo.writeToBuf(buf);
    }

    @Override
    public void onMessageClient(EntityPlayerSP player) {
        MultiBlockData.getClientSide();
        MultiBlockData.getNetwork(this.networkName).registerClientInfo(this.id, this.clientInfo);
    }
}

