/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.immcraft.network.ImmCraftPacketHandler;
import mcjty.immcraft.network.InfoPacketClient;
import mcjty.immcraft.network.InfoPacketServer;
import mcjty.immcraft.network.PacketReturnInfoToClient;
import mcjty.lib.thirteen.Context;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetInfoFromServer
implements IMessage {
    private InfoPacketServer packet;

    public void fromBytes(ByteBuf buf) {
        int id = buf.readInt();
        Class<? extends InfoPacketServer> clazz = ImmCraftPacketHandler.getServerInfoPacket(id);
        try {
            this.packet = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.packet.fromBytes(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(ImmCraftPacketHandler.getServerInfoPacketId(this.packet.getClass()).intValue());
        this.packet.toBytes(buf);
    }

    public PacketGetInfoFromServer() {
    }

    public PacketGetInfoFromServer(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetInfoFromServer(InfoPacketServer packet) {
        this.packet = packet;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> this.packet.onMessageServer(ctx.getSender()).ifPresent(p -> this.sendReplyToClient((InfoPacketClient)p, ctx.getSender())));
        ctx.setPacketHandled(true);
    }

    private void sendReplyToClient(InfoPacketClient reply, EntityPlayerMP player) {
        ImmCraftPacketHandler.INSTANCE.sendTo((IMessage)new PacketReturnInfoToClient(reply), player);
    }
}

