/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.sound;

import com.google.common.collect.Maps;
import java.util.Map;
import mcjty.immcraft.sound.ImmersiveSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public final class SoundController {
    private static SoundEvent pageturn;
    private static final Map<Pair<Integer, BlockPos>, ImmersiveSound> sounds;

    public static void init(IForgeRegistry<SoundEvent> registry) {
        pageturn = SoundController.registerSound(registry, new ResourceLocation("immcraft", "pageturn"));
    }

    private static SoundEvent registerSound(IForgeRegistry<SoundEvent> registry, ResourceLocation rl) {
        SoundEvent ret = (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
        registry.register((IForgeRegistryEntry)ret);
        return ret;
    }

    public static void stopSound(World worldObj, BlockPos pos) {
        Pair<Integer, BlockPos> g = SoundController.fromPosition(worldObj, pos);
        if (sounds.containsKey(g)) {
            MovingSound movingSound = sounds.get(g);
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)movingSound);
            sounds.remove(g);
        }
    }

    private static void playSound(World worldObj, BlockPos pos, SoundEvent soundType, float volume, float baseVolume, boolean repeat) {
        ImmersiveSound sound = new ImmersiveSound(soundType, worldObj, pos, baseVolume, repeat);
        sound.setVolume(volume);
        SoundController.stopSound(worldObj, pos);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        Pair g = Pair.of((Object)worldObj.field_73011_w.getDimension(), (Object)pos);
        sounds.put((Pair<Integer, BlockPos>)g, sound);
    }

    public static void playPageturn(World worldObj, BlockPos pos, float volume) {
        worldObj.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), pageturn, SoundCategory.BLOCKS, volume, 1.0f, false);
    }

    public static void updateVolume(World worldObj, BlockPos pos, float volume) {
        ImmersiveSound sound = SoundController.getSoundAt(worldObj, pos);
        if (sound != null) {
            sound.setVolume(volume);
        }
    }

    public static boolean isPageturnPlaying(World worldObj, BlockPos pos) {
        return SoundController.isSoundTypePlayingAt(pageturn, worldObj, pos);
    }

    private static boolean isSoundTypePlayingAt(SoundEvent event, World world, BlockPos pos) {
        ImmersiveSound s = SoundController.getSoundAt(world, pos);
        return s != null && s.isSoundType(event);
    }

    private static ImmersiveSound getSoundAt(World world, BlockPos pos) {
        return sounds.get(SoundController.fromPosition(world, pos));
    }

    private static Pair<Integer, BlockPos> fromPosition(World world, BlockPos pos) {
        return Pair.of((Object)world.field_73011_w.getDimension(), (Object)pos);
    }

    static {
        sounds = Maps.newHashMap();
    }
}

