/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.worldgen;

import java.util.Random;
import mcjty.immcraft.blocks.ModBlocks;
import mcjty.immcraft.blocks.foliage.SticksTE;
import mcjty.immcraft.config.GeneralConfiguration;
import mcjty.immcraft.varia.BlockTools;
import mcjty.lib.blocks.BaseBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ImmCraftGenerator
implements IWorldGenerator {
    public static ImmCraftGenerator instance = new ImmCraftGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world) {
        this.spawnRubble(random, chunkX, chunkZ, world);
    }

    private void spawnRubble(Random random, int chunkX, int chunkZ, World world) {
        IBlockState state;
        BlockPos pos;
        int z;
        int x;
        int i;
        if (GeneralConfiguration.worldgenRockAttemptsPerChunk > 0) {
            for (i = 0; i < random.nextInt(GeneralConfiguration.worldgenRockAttemptsPerChunk); ++i) {
                x = chunkX * 16 + random.nextInt(16) + 8;
                pos = world.func_175672_r(new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16) + 8)).func_177977_b();
                state = world.func_180495_p(pos);
                if (!this.isRockSpawnable(state) || !world.func_175623_d(pos.func_177984_a())) continue;
                world.func_180501_a(pos.func_177984_a(), ModBlocks.rockBlock.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING_HORIZ, (Comparable)EnumFacing.func_176731_b((int)random.nextInt(4))), 3);
            }
        }
        if (GeneralConfiguration.worldgenStickAttemptsPerChunk > 0) {
            for (i = 0; i < random.nextInt(GeneralConfiguration.worldgenStickAttemptsPerChunk); ++i) {
                x = chunkX * 16 + random.nextInt(16) + 8;
                pos = world.func_175672_r(new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16) + 8)).func_177977_b();
                state = world.func_180495_p(pos);
                if (!this.isStickSpawnable(state)) continue;
                this.trySpawnSticks(world, pos, random);
            }
        }
        if (GeneralConfiguration.worldgenRockAttemptsPerChunk > 0) {
            for (i = 0; i < random.nextInt(GeneralConfiguration.worldgenRockAttemptsPerChunk); ++i) {
                x = chunkX * 16 + random.nextInt(16) + 8;
                z = chunkZ * 16 + random.nextInt(16) + 8;
                pos = world.func_175672_r(new BlockPos(x, 0, z)).func_177977_b();
                int y = this.findCaveSpot(world, pos);
                pos = new BlockPos(x, y, z);
                IBlockState state2 = world.func_180495_p(pos);
                if (y == -1 || !this.isRockSpawnable(state2) || !world.func_175623_d(pos.func_177984_a())) continue;
                world.func_180501_a(pos.func_177984_a(), ModBlocks.rockBlock.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING_HORIZ, (Comparable)EnumFacing.func_176731_b((int)random.nextInt(4))), 3);
            }
        }
    }

    private void trySpawnSticks(World world, BlockPos pos, Random random) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.func_175623_d(new BlockPos(x, ++y, z))) {
            return;
        }
        ++y;
        if (!BlockTools.isTopValidAndSolid(world, pos)) {
            return;
        }
        for (int i = 0; i < 15; ++i) {
            if (!world.func_175623_d(new BlockPos(x, y, z))) {
                IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
                if (this.isLeafBlock(state.func_177230_c(), state)) {
                    world.func_180501_a(pos.func_177984_a(), ModBlocks.sticksBlock.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING_HORIZ, (Comparable)EnumFacing.func_176731_b((int)random.nextInt(4))), 3);
                    TileEntity te = world.func_175625_s(pos.func_177984_a());
                    if (te instanceof SticksTE) {
                        SticksTE sticksTE = (SticksTE)te;
                        sticksTE.setSticks(random.nextInt(6) + 1);
                    }
                }
                return;
            }
            ++y;
        }
    }

    private int findCaveSpot(World world, BlockPos pos) {
        int y;
        boolean air = false;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (y = pos.func_177956_o(); y > 1 && !air; --y) {
            if (!world.func_175623_d(new BlockPos(x, y, z))) continue;
            air = true;
        }
        if (air) {
            while (y > 1 && air) {
                if (!world.func_175623_d(new BlockPos(x, y, z))) {
                    air = false;
                    continue;
                }
                --y;
            }
            if (!air) {
                return y;
            }
        }
        return -1;
    }

    private boolean isStickSpawnable(IBlockState state) {
        return GeneralConfiguration.getValidBlocksForSticks().contains(state);
    }

    private boolean isLeafBlock(Block block, IBlockState state) {
        return block.func_149688_o(state) == Material.field_151584_j;
    }

    private boolean isRockSpawnable(IBlockState state) {
        return GeneralConfiguration.getValidBlocksForRocks().contains(state);
    }
}

