/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.melee.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.network.EntityMovementChangePacket;

public class BattleSign
extends TinkerToolCore {
    public BattleSign() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.signHead));
        this.addCategory(Category.WEAPON);
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public double attackSpeed() {
        return 1.2;
    }

    @Override
    public float damagePotential() {
        return 0.86f;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!ToolHelper.isBroken(itemStackIn)) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void reducedDamageBlocked(LivingHurtEvent event) {
        if (event.getSource().func_76363_c() || event.getSource().func_82725_o() || event.getSource().func_94541_c() || event.getSource().func_76352_a() || event.isCanceled()) {
            return;
        }
        if (!this.shouldBlockDamage((Entity)event.getEntityLiving())) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ItemStack battlesign = player.func_184607_cu();
        int damage = event.getAmount() < 2.0f ? 1 : Math.round(event.getAmount() / 2.0f);
        event.setAmount(event.getAmount() * 0.7f);
        if (event.getSource().func_76346_g() != null) {
            event.getSource().func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)player), event.getAmount() / 2.0f);
            damage = damage * 3 / 2;
        }
        ToolHelper.damageTool(battlesign, damage, (EntityLivingBase)player);
    }

    @SubscribeEvent
    public void reflectProjectiles(LivingAttackEvent event) {
        if (event.getSource().func_76363_c() || !event.getSource().func_76352_a() || event.getSource().func_76364_f() == null) {
            return;
        }
        if (!this.shouldBlockDamage((Entity)event.getEntityLiving())) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ItemStack battlesign = player.func_184607_cu();
        Entity projectile = event.getSource().func_76364_f();
        Vec3d motion = new Vec3d(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y);
        Vec3d look = player.func_70040_Z();
        double strength = -look.func_72430_b(motion.func_72432_b());
        if (strength < 0.1) {
            return;
        }
        event.setCanceled(true);
        double speed = projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y;
        speed = Math.sqrt(speed);
        projectile.field_70159_w = look.field_72450_a * (speed += (double)0.2f);
        projectile.field_70181_x = look.field_72448_b * speed;
        projectile.field_70179_y = look.field_72449_c * speed;
        projectile.field_70177_z = (float)(Math.atan2(projectile.field_70159_w, projectile.field_70179_y) * 180.0 / Math.PI);
        projectile.field_70125_A = (float)(Math.atan2(projectile.field_70181_x, speed) * 180.0 / Math.PI);
        TinkerNetwork.sendToAll((AbstractPacket)new EntityMovementChangePacket(projectile));
        if (projectile instanceof EntityArrow) {
            ((EntityArrow)projectile).field_70250_c = player;
            projectile.field_70159_w /= (double)-0.1f;
            projectile.field_70181_x /= (double)-0.1f;
            projectile.field_70179_y /= (double)-0.1f;
        }
        ToolHelper.damageTool(battlesign, (int)event.getAmount(), (EntityLivingBase)player);
    }

    protected boolean shouldBlockDamage(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!player.func_184585_cz() || player.func_184607_cu().func_77973_b() != this) {
            return false;
        }
        return !ToolHelper.isBroken(player.func_184607_cu());
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        return this.buildDefaultTag(materials);
    }
}

