/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiUtils;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.IWidgetListener;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPneumaticContainerBase<Tile extends TileEntityBase>
extends GuiContainer
implements IWidgetListener {
    public final Tile te;
    private final ResourceLocation guiTexture;
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private IGuiAnimatedStat lastLeftStat;
    private IGuiAnimatedStat lastRightStat;
    private GuiAnimatedStat pressureStat;
    private GuiAnimatedStat redstoneTab;
    GuiAnimatedStat problemTab;
    GuiButtonSpecial redstoneButton;
    private boolean hasInit;
    protected boolean firstUpdate = true;

    public GuiPneumaticContainerBase(Container par1Container, Tile te, String guiTexture) {
        super(par1Container);
        this.te = te;
        this.guiTexture = guiTexture != null ? new ResourceLocation(guiTexture) : null;
    }

    private GuiAnimatedStat addAnimatedStat(String title, GuiAnimatedStat.StatIcon icon, int color, boolean leftSided) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GuiAnimatedStat stat = new GuiAnimatedStat((GuiScreen)this, title, icon, xStart + (leftSided ? 0 : this.field_146999_f + 1), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : yStart + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        stat.setBeveled(true);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, @Nonnull ItemStack icon, int color, boolean leftSided) {
        return this.addAnimatedStat(title, GuiAnimatedStat.StatIcon.of(icon), color, leftSided);
    }

    protected GuiAnimatedStat addAnimatedStat(String title, ResourceLocation icon, int color, boolean leftSided) {
        return this.addAnimatedStat(title, GuiAnimatedStat.StatIcon.of(icon), color, leftSided);
    }

    protected GuiAnimatedStat addAnimatedStat(String title, int color, boolean leftSided) {
        return this.addAnimatedStat(title, GuiAnimatedStat.StatIcon.NONE, color, leftSided);
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    protected void addWidgets(Iterable<IGuiWidget> widgets) {
        for (IGuiWidget widget : widgets) {
            this.addWidget(widget);
        }
    }

    protected void addLabel(String text, int x, int y) {
        this.addWidget(new WidgetLabel(x, y, text));
    }

    protected void addLabel(String text, int x, int y, int color) {
        this.addWidget(new WidgetLabel(x, y, text, color));
    }

    protected void removeWidget(IGuiWidget widget) {
        this.widgets.remove(widget);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.lastRightStat = null;
        this.lastLeftStat = null;
        if (this.shouldAddPressureTab() && this.te instanceof TileEntityPneumaticBase) {
            this.pressureStat = this.addAnimatedStat("gui.tab.pressure", new ItemStack(Blockss.PRESSURE_TUBE), -16733696, false);
        }
        if (this.shouldAddProblemTab()) {
            this.problemTab = this.addAnimatedStat("gui.tab.problems", -6250336, false);
        }
        if (this.te != null) {
            if (this.shouldAddInfoTab()) {
                this.addInfoTab("gui.tab.info." + ((TileEntityBase)this.te).getName());
            }
            if (this.shouldAddRedstoneTab() && this.te instanceof IRedstoneControl) {
                this.addRedstoneTab();
            }
            if (this.te instanceof IHeatExchanger) {
                this.addAnimatedStat("gui.tab.info.heat.title", new ItemStack(Items.field_151065_br), -43776, false).setText("gui.tab.info.heat");
            }
            if (this.shouldAddUpgradeTab()) {
                this.addUpgradeTab();
            }
            if (this.shouldAddSideConfigTabs()) {
                this.addSideConfiguratorTabs();
            }
        }
        this.hasInit = true;
    }

    private void addRedstoneTab() {
        this.redstoneTab = this.addAnimatedStat("gui.tab.redstoneBehaviour", new ItemStack(Items.field_151137_ax), -3407872, true);
        ArrayList<String> curInfo = new ArrayList<String>();
        curInfo.add(I18n.func_135052_a((String)((TileEntityBase)this.te).getRedstoneTabTitle(), (Object[])new Object[0]));
        int width = this.getWidestRedstoneLabel();
        this.redstoneTab.addPadding(curInfo, 4, width / this.field_146289_q.func_78256_a(" "));
        Rectangle buttonRect = this.redstoneTab.getButtonScaledRectangle(-width - 12, 24, width + 10, 20);
        this.redstoneButton = new GuiButtonSpecial(0, buttonRect.x, buttonRect.y, buttonRect.width, buttonRect.height, "-");
        this.redstoneTab.addWidget(this.redstoneButton);
    }

    private void addUpgradeTab() {
        String upgrades = "gui.tab.upgrades." + ((TileEntityBase)this.te).getName();
        String translatedUpgrades = I18n.func_135052_a((String)upgrades, (Object[])new Object[0]);
        ArrayList<String> upgradeText = new ArrayList<String>();
        if (this.te instanceof TileEntityPneumaticBase) {
            upgradeText.add("gui.tab.upgrades.volume");
            upgradeText.add("gui.tab.upgrades.security");
        }
        if (this.te instanceof IHeatExchanger) {
            upgradeText.add("gui.tab.upgrades.volumeCapacity");
        }
        if (!translatedUpgrades.equals(upgrades)) {
            upgradeText.add(upgrades);
        }
        this.addExtraUpgradeText(upgradeText);
        if (upgradeText.size() > 0) {
            this.addAnimatedStat("gui.tab.upgrades", Textures.GUI_UPGRADES_LOCATION, -10460929, true).setText(upgradeText);
        }
    }

    protected void addExtraUpgradeText(List<String> upgradeText) {
    }

    private int getWidestRedstoneLabel() {
        int max = 0;
        for (int i = 0; i < ((TileEntityBase)this.te).getRedstoneModeCount(); ++i) {
            max = Math.max(max, this.field_146289_q.func_78256_a(I18n.func_135052_a((String)((TileEntityBase)this.te).getRedstoneButtonText(i), (Object[])new Object[0])));
        }
        return max;
    }

    private void addSideConfiguratorTabs() {
        for (SideConfigurator sc : ((ISideConfigurable)this.te).getSideConfigurators()) {
            GuiAnimatedStat stat = this.addAnimatedStat(sc.getTranslationKey(), new ItemStack(Blockss.OMNIDIRECTIONAL_HOPPER), -7290656, false);
            stat.addPadding(7, 16);
            int yTop = 15;
            int xLeft = 25;
            stat.addWidget(this.makeSideConfButton(sc, SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
            stat.addWidget(this.makeSideConfButton(sc, SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
            stat.addWidget(this.makeSideConfButton(sc, SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
            stat.addWidget(this.makeSideConfButton(sc, SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
            stat.addWidget(this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
            stat.addWidget(this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
        }
    }

    private GuiButtonSpecial makeSideConfButton(SideConfigurator sc, SideConfigurator.RelativeFace relativeFace, int x, int y) {
        GuiButtonSpecial button = new GuiButtonSpecial(sc.getButtonId(relativeFace), x, y, 20, 20, "");
        sc.setupButton(button);
        return button;
    }

    protected void addInfoTab(String info) {
        GuiAnimatedStat stat = this.addAnimatedStat("gui.tab.info", Textures.GUI_INFO_LOCATION, -7829249, true);
        stat.setText(info);
        if (!ThirdPartyManager.instance().docsProvider.docsProviderInstalled()) {
            stat.appendText(Arrays.asList("", "gui.tab.info.assistIGW"));
        }
    }

    protected boolean shouldAddRedstoneTab() {
        return true;
    }

    protected boolean shouldAddPressureTab() {
        return true;
    }

    protected boolean shouldAddUpgradeTab() {
        return true;
    }

    protected boolean shouldAddInfoTab() {
        return true;
    }

    protected boolean shouldAddProblemTab() {
        return true;
    }

    protected boolean shouldAddSideConfigTabs() {
        return this.te instanceof ISideConfigurable;
    }

    protected int getBackgroundTint() {
        return 0xFFFFFF;
    }

    protected void func_146976_a(float partialTicks, int i, int j) {
        Point gaugeLocation;
        if (this.shouldDrawBackground()) {
            this.func_146276_q_();
            RenderUtils.glColorHex(0xFF000000 | this.getBackgroundTint());
            this.bindGuiTexture();
            int xStart = (this.field_146294_l - this.field_146999_f) / 2;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        this.widgets.forEach(widget -> widget.render(i, j, partialTicks));
        this.widgets.forEach(widget -> widget.postRender(i, j, partialTicks));
        if (this.pressureStat != null && (gaugeLocation = this.getGaugeLocation()) != null) {
            TileEntityPneumaticBase pneu = (TileEntityPneumaticBase)this.te;
            GuiUtils.drawPressureGauge(this.field_146289_q, -1.0f, pneu.criticalPressure, pneu.dangerPressure, this.te instanceof IMinWorkingPressure ? ((IMinWorkingPressure)this.te).getMinWorkingPressure() : -3.4028235E38f, pneu.getPressure(), gaugeLocation.x, gaugeLocation.y, this.field_73735_i);
        }
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    protected void bindGuiTexture() {
        if (this.guiTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiTexture);
            GlStateManager.func_179098_w();
        }
    }

    protected Point getGaugeLocation() {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        return new Point(xStart + this.field_146999_f * 3 / 4, yStart + this.field_147000_g / 4 + 4);
    }

    protected void func_146979_b(int x, int y) {
        if (this.te != null && this.getInvNameOffset() != null) {
            String containerName = I18n.func_135052_a((String)(((TileEntityBase)this.te).getName() + ".name"), (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(containerName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(containerName) / 2 + this.getInvNameOffset().x, 6 + this.getInvNameOffset().y, this.getTitleColor());
        }
        if (this.getInvTextOffset() != null) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8 + this.getInvTextOffset().x, this.field_147000_g - 94 + this.getInvTextOffset().y, 0x404040);
        }
    }

    protected int getTitleColor() {
        return 0x404040;
    }

    protected Point getInvNameOffset() {
        return new Point(0, 0);
    }

    protected Point getInvTextOffset() {
        return new Point(0, 0);
    }

    public void func_73863_a(int x, int y, float partialTick) {
        if (!this.hasInit) {
            return;
        }
        super.func_73863_a(x, y, partialTick);
        ArrayList<String> tooltip = new ArrayList<String>();
        for (Object obj : this.field_146292_n) {
            if (!(obj instanceof GuiButtonSpecial)) continue;
            GuiButtonSpecial button = (GuiButtonSpecial)obj;
            if (!button.field_146125_m || button.field_146128_h >= x || button.field_146128_h + button.getWidth() <= x || button.field_146129_i >= y || button.field_146129_i + button.getHeight() <= y) continue;
            button.getTooltip(tooltip);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltip, PneumaticCraftRepressurized.proxy.isSneakingInGui());
        }
        if (tooltip.size() > 0) {
            this.drawHoveringString(tooltip, x, y, this.field_146289_q);
            tooltip.clear();
        }
        this.func_191948_b(x, y);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
        if (this.pressureStat != null) {
            ArrayList<String> pressureText = new ArrayList<String>();
            this.addPressureStatInfo(pressureText);
            this.pressureStat.setText(pressureText);
        }
        if (this.problemTab != null && ((Minecraft.func_71410_x().field_71441_e.func_82737_E() & 7L) == 0L || this.firstUpdate)) {
            this.handleProblemsTab();
        }
        if (this.redstoneTab != null) {
            this.redstoneButton.field_146126_j = I18n.func_135052_a((String)((TileEntityBase)this.te).getRedstoneButtonText(((IRedstoneControl)this.te).getRedstoneMode()), (Object[])new Object[0]);
        }
        this.firstUpdate = false;
    }

    private void handleProblemsTab() {
        ArrayList<String> problemText = new ArrayList<String>();
        this.addProblems(problemText);
        int nProbs = problemText.size();
        this.addWarnings(problemText);
        int nWarnings = problemText.size() - nProbs;
        this.addInformation(problemText);
        int nInfo = problemText.size() - nWarnings;
        if (nProbs > 0) {
            this.problemTab.setTexture(Textures.GUI_PROBLEMS_TEXTURE);
            this.problemTab.setTitle("gui.tab.problems");
            this.problemTab.setBackGroundColor(-65536);
        } else if (nWarnings > 0) {
            this.problemTab.setTexture(Textures.GUI_WARNING_TEXTURE);
            this.problemTab.setTitle("gui.tab.problems.warning");
            this.problemTab.setBackGroundColor(-4145152);
        } else {
            this.problemTab.setTexture(Textures.GUI_NO_PROBLEMS_TEXTURE);
            this.problemTab.setTitle("gui.tab.problems.noProblems");
            this.problemTab.setBackGroundColor(-6226016);
        }
        if (problemText.isEmpty()) {
            problemText.add("");
        }
        this.problemTab.setText(problemText);
    }

    protected void func_146284_a(GuiButton button) {
        this.sendPacketToServer(button.field_146127_k);
    }

    protected void addPressureStatInfo(List<String> pressureStatText) {
        TileEntityPneumaticBase pneumaticTile = (TileEntityPneumaticBase)this.te;
        IAirHandler airHandler = pneumaticTile.getAirHandler(null);
        pressureStatText.add("\u00a77Current Pressure:");
        pressureStatText.add("\u00a70" + PneumaticCraftUtils.roundNumberTo(pneumaticTile.getPressure(), 1) + " bar.");
        pressureStatText.add("\u00a77Current Air:");
        pressureStatText.add("\u00a70" + (airHandler.getAir() + airHandler.getVolume()) + " mL.");
        pressureStatText.add("\u00a77Volume:");
        pressureStatText.add("\u00a70" + pneumaticTile.getDefaultVolume() + " mL.");
        int volumeLeft = airHandler.getVolume() - pneumaticTile.getDefaultVolume();
        if (volumeLeft > 0) {
            pressureStatText.add("\u00a70" + volumeLeft + " mL. (Volume Upgrades)");
            pressureStatText.add("\u00a70--------+");
            pressureStatText.add("\u00a70" + airHandler.getVolume() + " mL.");
        }
    }

    protected void addProblems(List<String> curInfo) {
        if (this.te instanceof IMinWorkingPressure) {
            IMinWorkingPressure minWork = (IMinWorkingPressure)this.te;
            if (((TileEntityPneumaticBase)this.te).getPressure() < minWork.getMinWorkingPressure()) {
                curInfo.add("gui.tab.problems.notEnoughPressure");
                curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.applyPressure", (Object[])new Object[]{Float.valueOf(minWork.getMinWorkingPressure())}));
            }
        }
    }

    protected void addInformation(List<String> curInfo) {
    }

    protected void addWarnings(List<String> curInfo) {
        if (this.te instanceof IRedstoneControlled && !((TileEntityBase)this.te).redstoneAllows()) {
            IRedstoneControlled redstoneControlled = (IRedstoneControlled)this.te;
            curInfo.add("gui.tab.problems.redstoneDisallows");
            if (redstoneControlled.getRedstoneMode() == 1) {
                curInfo.add("gui.tab.problems.provideRedstone");
            } else {
                curInfo.add("gui.tab.problems.removeRedstone");
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (IGuiWidget widget : this.widgets) {
            if (widget.getBounds().contains(mouseX, mouseY)) {
                widget.onMouseClicked(mouseX, mouseY, mouseButton);
                continue;
            }
            widget.onMouseClickedOutsideBounds(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget instanceof IGuiAnimatedStat) {
            boolean leftSided = ((IGuiAnimatedStat)((Object)widget)).isLeftSided();
            this.widgets.stream().filter(w -> w instanceof IGuiAnimatedStat).map(w -> (IGuiAnimatedStat)((Object)w)).filter(stat -> widget != stat && stat.isLeftSided() == leftSided).forEach(IGuiAnimatedStat::closeWindow);
        } else if (this.te instanceof ISideConfigurable && widget instanceof GuiButtonSpecial) {
            ((ISideConfigurable)this.te).getSideConfigurators().stream().filter(sc -> sc.handleButtonPress(widget.getID())).findFirst().ifPresent(sc -> sc.setupButton((GuiButtonSpecial)widget));
        }
        this.sendPacketToServer(widget.getID());
    }

    protected void sendPacketToServer(int id) {
        NetworkHandler.sendToServer(new PacketGuiButton(id));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.widgets.forEach(IGuiWidget::handleMouseInput);
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.onKey(key, keyCode)) continue;
            return;
        }
        super.func_73869_a(key, keyCode);
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.widgets.clear();
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    public void drawHoveringString(List<String> text, int x, int y, FontRenderer fontRenderer) {
        this.drawHoveringText(text, x, y, fontRenderer);
    }

    public static void drawTexture(ResourceLocation texture, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)x, (double)(y + 16), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b((double)(x + 16), (double)(y + 16), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b((double)(x + 16), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public GuiButtonSpecial getButtonFromRectangle(int buttonID, Rectangle buttonSize, String buttonText) {
        return new GuiButtonSpecial(buttonID, buttonSize.x, buttonSize.y, buttonSize.width, buttonSize.height, buttonText);
    }

    public GuiButtonSpecial getInvisibleButtonFromRectangle(int buttonID, Rectangle buttonSize) {
        return new GuiButtonSpecial(buttonID, buttonSize.x, buttonSize.y, buttonSize.width, buttonSize.height, "");
    }

    public WidgetTextField getTextFieldFromRectangle(Rectangle textFieldSize) {
        return new WidgetTextField(this.field_146289_q, textFieldSize.x, textFieldSize.y, textFieldSize.width, textFieldSize.height);
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public List<Rectangle> getTabRectangles() {
        return this.widgets.stream().filter(w -> w instanceof IGuiAnimatedStat).map(IGuiWidget::getBounds).collect(Collectors.toList());
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
    }

    protected void refreshScreen() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        this.func_146280_a(Minecraft.func_71410_x(), i, j);
        this.widgets.stream().filter(widget -> widget instanceof GuiAnimatedStat).forEach(IGuiWidget::update);
    }
}

