/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityKeroseneLamp;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockKeroseneLamp
extends BlockPneumaticCraftModeled {
    private static final PropertyEnum<EnumFacing> CONNECTED = PropertyEnum.func_177709_a((String)"connected", EnumFacing.class);
    private static final AxisAlignedBB BLOCK_BOUNDS_NS = new AxisAlignedBB(0.1875, 0.0, 0.3125, 0.8125, 0.625, 0.6875);
    private static final AxisAlignedBB BLOCK_BOUNDS_EW = new AxisAlignedBB(0.3125, 0.0, 0.1875, 0.6875, 0.625, 0.8125);

    BlockKeroseneLamp() {
        super(Material.field_151573_f, "kerosene_lamp");
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!source.func_180495_p(pos).func_177227_a().contains(ROTATION)) {
            return BLOCK_BOUNDS_EW;
        }
        EnumFacing facing = this.getRotation(source, pos);
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            return BLOCK_BOUNDS_NS;
        }
        return BLOCK_BOUNDS_EW;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, CONNECTED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = PneumaticCraftUtils.getTileEntitySafely(worldIn, pos);
        if (te instanceof TileEntityKeroseneLamp) {
            state = state.func_177226_a(CONNECTED, (Comparable)((TileEntityKeroseneLamp)te).getSideConnected());
        }
        return state;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.KEROSENE_LAMP;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityKeroseneLamp.class;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityKeroseneLamp) {
            return ((TileEntityKeroseneLamp)te).isOn() ? 15 : 0;
        }
        return 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

