/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.semiblock.ItemSemiBlockBase;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemLogisticsFrame
extends ItemSemiBlockBase {
    public ItemLogisticsFrame(String registryName) {
        super(registryName);
        this.func_77637_a(PneumaticCraftRepressurized.tabPneumaticCraft);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!world.field_72995_K) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, this.getSemiBlock(world, null, stack).getGuiID().ordinal(), world, 0, 0, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> curInfo, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, worldIn, curInfo, extraInfo);
        ItemLogisticsFrame.addTooltip(stack, worldIn, curInfo, PneumaticCraftRepressurized.proxy.isSneakingInGui());
    }

    public static void addTooltip(ItemStack stack, World world, List<String> curInfo, boolean sneaking) {
        if (stack.func_77978_p() != null && stack.func_77973_b() instanceof ItemSemiBlockBase) {
            SemiBlockLogistics logistics = ContainerLogistics.getLogistics(world, stack);
            if (logistics == null) {
                return;
            }
            if (logistics.isInvisible()) {
                curInfo.add("- " + PneumaticCraftUtils.xlate("gui.logistic_frame.invisible"));
            }
            String key = SemiBlockManager.getKeyForSemiBlock(SemiBlockManager.getSemiBlockForItem((ItemSemiBlockBase)stack.func_77973_b()));
            if (sneaking) {
                if (logistics.isFuzzyMeta()) {
                    curInfo.add("- " + PneumaticCraftUtils.xlate("gui.logistic_frame.fuzzyMeta"));
                }
                if (logistics.isFuzzyNBT()) {
                    curInfo.add("- " + PneumaticCraftUtils.xlate("gui.logistic_frame.fuzzyNBT"));
                }
                ItemStack[] stacks = new ItemStack[logistics.getFilters().getSlots()];
                for (int i = 0; i < logistics.getFilters().getSlots(); ++i) {
                    stacks[i] = logistics.getFilters().getStackInSlot(i);
                }
                curInfo.add(TextFormatting.WHITE + PneumaticCraftUtils.xlate("gui.logistic_frame." + (logistics.isWhitelist() ? "whitelist" : "blacklist")) + ":");
                int l = curInfo.size();
                PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, stacks);
                if (curInfo.size() == l) {
                    curInfo.add(PneumaticCraftUtils.xlate("gui.logistic_frame.no_items"));
                }
                l = curInfo.size();
                for (int i = 0; i < 9; ++i) {
                    FluidStack fluid = logistics.getTankFilter(i).getFluid();
                    if (fluid == null) continue;
                    curInfo.add("\u2022 " + fluid.amount + "mB " + fluid.getLocalizedName());
                }
                if (curInfo.size() == l) {
                    curInfo.add(PneumaticCraftUtils.xlate("gui.logistic_frame.no_fluids"));
                }
            } else {
                curInfo.add(PneumaticCraftUtils.xlate(String.format("gui.%s.hasFilters", key)));
            }
        }
    }
}

