/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.AirConUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.ChargingUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JumpBoostUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MagnetUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MainHelmetHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.NightVisionUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.RunSpeedUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.ScubaUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.StepAssistUpgradeHandler;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.item.ItemMachineUpgrade;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.WorldAndCoord;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommonArmorHandler {
    private static final CommonArmorHandler clientHandler = new CommonArmorHandler(null);
    private static final CommonArmorHandler serverHandler = new CommonArmorHandler(null);
    private static Potion nightVisionPotion;
    private final HashMap<String, CommonArmorHandler> playerHudHandlers = new HashMap();
    private final EntityPlayer player;
    private int magnetRadius;
    private int magnetRadiusSq;
    private final boolean[][] upgradeRenderersInserted = new boolean[4][];
    private final boolean[][] upgradeRenderersEnabled = new boolean[4][];
    private final int[] ticksSinceEquip = new int[4];
    public final float[] armorPressure = new float[4];
    private final int[][] upgradeMatrix = new int[4][];
    private final int[] startupTimes = new int[4];
    private boolean isValid;
    private int hackTime;
    private WorldAndCoord hackedBlock;
    private Entity hackedEntity;
    private boolean armorEnabled;
    private boolean magnetEnabled;
    private boolean chargingEnabled;
    private boolean stepAssistEnabled;
    private boolean runSpeedEnabled;
    private boolean jumpBoostEnabled;
    private boolean entityTrackerEnabled;
    private boolean nightVisionEnabled;
    private boolean scubaEnabled;
    private boolean airConEnabled;
    private boolean jetBootsEnabled;
    private boolean jetBootsActive;
    private float flightAccel = 1.0f;
    private int prevJetBootsAirUsage;
    private int jetBootsActiveTicks;
    private boolean wasNightVisionEnabled;
    private float speedBoostMult;
    private boolean jetBootsBuilderMode;
    private static final Map<String, Vec3d> moveMap;

    public CommonArmorHandler(EntityPlayer player) {
        this.player = player;
        for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
            this.upgradeRenderersInserted[slot.func_188454_b()] = new boolean[renderHandlers.size()];
            this.upgradeRenderersEnabled[slot.func_188454_b()] = new boolean[renderHandlers.size()];
            this.upgradeMatrix[slot.func_188454_b()] = new int[IItemRegistry.EnumUpgrade.values().length];
        }
        Arrays.fill(this.startupTimes, 200);
        this.isValid = true;
    }

    private static CommonArmorHandler getManagerInstance(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? clientHandler : serverHandler;
    }

    public static CommonArmorHandler getHandlerForPlayer(EntityPlayer player) {
        return CommonArmorHandler.getManagerInstance((EntityPlayer)player).playerHudHandlers.computeIfAbsent(player.func_70005_c_(), v -> new CommonArmorHandler(player));
    }

    @SideOnly(value=Side.CLIENT)
    public static CommonArmorHandler getHandlerForPlayer() {
        return CommonArmorHandler.getHandlerForPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CommonArmorHandler.getHandlerForPlayer(event.player).tick();
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        CommonArmorHandler.clearHUDHandlerForPlayer(event.player);
    }

    @SubscribeEvent
    public static void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        EntityPlayer player = PneumaticCraftRepressurized.proxy.getClientPlayer();
        if (player != null) {
            CommonArmorHandler.clearHUDHandlerForPlayer(player);
        }
    }

    private static void clearHUDHandlerForPlayer(EntityPlayer player) {
        CommonArmorHandler h = CommonArmorHandler.getManagerInstance(player);
        h.playerHudHandlers.computeIfPresent(player.func_70005_c_(), (name, val) -> {
            val.invalidate();
            return null;
        });
    }

    private static Potion getNightVisionPotion() {
        if (nightVisionPotion == null) {
            nightVisionPotion = Potion.func_180142_b((String)"night_vision");
        }
        return nightVisionPotion;
    }

    private void tick() {
        for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            this.tickArmorPiece(slot);
        }
        if (!this.player.field_70170_p.field_72995_K) {
            this.handleHacking();
        }
    }

    private void tickArmorPiece(EntityEquipmentSlot slot) {
        ItemStack armorStack = this.player.func_184582_a(slot);
        boolean armorActive = false;
        if (armorStack.func_77973_b() instanceof ItemPneumaticArmor) {
            this.armorPressure[slot.func_188454_b()] = ((IPressurizable)armorStack.func_77973_b()).getPressure(armorStack);
            if (this.ticksSinceEquip[slot.func_188454_b()] == 0) {
                this.initArmorInventory(slot);
            }
            int n = slot.func_188454_b();
            this.ticksSinceEquip[n] = this.ticksSinceEquip[n] + 1;
            if (this.armorEnabled && this.armorPressure[slot.func_188454_b()] > 0.0f) {
                float oldPressure;
                float airUsage;
                armorActive = true;
                if (!this.player.field_70170_p.field_72995_K && this.isArmorReady(slot) && !this.player.field_71075_bZ.field_75098_d && (airUsage = UpgradeRenderHandlerList.instance().getAirUsage(this.player, slot, false)) != 0.0f && (oldPressure = this.addAir(slot, (int)(-airUsage))) > 0.0f && this.armorPressure[slot.func_188454_b()] == 0.0f) {
                    NetworkHandler.sendTo(new PacketPlaySound(Sounds.MINIGUN_STOP, SoundCategory.PLAYERS, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, 1.0f, 2.0f, false), (EntityPlayerMP)this.player);
                }
                this.doArmorActions(slot);
            }
        }
        if (!armorActive) {
            if (this.ticksSinceEquip[slot.func_188454_b()] > 0) {
                this.onArmorRemoved(slot);
            }
            this.ticksSinceEquip[slot.func_188454_b()] = 0;
        }
    }

    private void onArmorRemoved(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                if (!this.nightVisionEnabled) break;
                this.player.func_184596_c(CommonArmorHandler.getNightVisionPotion());
                break;
            }
            case FEET: {
                this.player.field_70138_W = 0.6f;
            }
        }
    }

    public float addAir(EntityEquipmentSlot slot, int air) {
        ItemStack armorStack = this.player.func_184582_a(slot);
        float oldPressure = this.armorPressure[slot.func_188454_b()];
        if (armorStack.func_77973_b() instanceof IPressurizable) {
            ((IPressurizable)armorStack.func_77973_b()).addAir(armorStack, air);
            this.armorPressure[slot.func_188454_b()] = ((IPressurizable)armorStack.func_77973_b()).getPressure(armorStack);
        }
        return oldPressure;
    }

    private void doArmorActions(EntityEquipmentSlot slot) {
        if (!this.isArmorReady(slot)) {
            return;
        }
        switch (slot) {
            case HEAD: {
                this.handleNightVision();
                this.handleScuba();
                break;
            }
            case CHEST: {
                this.handleChestplateMagnet();
                this.handleChestplateCharging();
                break;
            }
            case LEGS: {
                this.handleLeggingsSpeedBoost();
                break;
            }
            case FEET: {
                this.player.field_70138_W = this.getArmorPressure(EntityEquipmentSlot.FEET) > 0.0f && this.isStepAssistEnabled() ? (this.player.func_70093_af() ? 0.6001f : 1.25f) : 0.6f;
                this.handleJetBoots();
            }
        }
        if (!this.player.field_70170_p.field_72995_K && this.getUpgradeCount(slot, IItemRegistry.EnumUpgrade.ITEM_LIFE) > 0) {
            this.handleItemRepair(slot);
        }
    }

    private void handleNightVision() {
        if (!this.player.field_70170_p.field_72995_K && (this.getTicksSinceEquipped(EntityEquipmentSlot.HEAD) & 7) == 0) {
            boolean shouldEnable;
            boolean bl = shouldEnable = this.getArmorPressure(EntityEquipmentSlot.HEAD) > 0.0f && this.getUpgradeCount(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.NIGHT_VISION) > 0 && this.nightVisionEnabled;
            if (shouldEnable) {
                ItemStack helmetStack = this.player.func_184582_a(EntityEquipmentSlot.HEAD);
                this.player.func_70690_d(new PotionEffect(CommonArmorHandler.getNightVisionPotion(), 500, 0, false, false));
                this.addAir(EntityEquipmentSlot.HEAD, -8);
            } else if (!shouldEnable && this.wasNightVisionEnabled) {
                this.player.func_184589_d(CommonArmorHandler.getNightVisionPotion());
            }
            this.wasNightVisionEnabled = shouldEnable;
        }
    }

    private void handleScuba() {
        if (!this.player.field_70170_p.field_72995_K && this.scubaEnabled && this.getUpgradeCount(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.SCUBA) > 0 && this.getArmorPressure(EntityEquipmentSlot.HEAD) > 0.1f && this.player.func_70086_ai() < 200) {
            ItemStack helmetStack = this.player.func_184582_a(EntityEquipmentSlot.HEAD);
            int vol = ((ItemPneumaticArmor)helmetStack.func_77973_b()).getBaseVolume() + 5000 * this.getUpgradeCount(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.VOLUME);
            float airInHelmet = this.getArmorPressure(EntityEquipmentSlot.HEAD) * (float)vol;
            int playerAir = (int)Math.min((float)(300 - this.player.func_70086_ai()), airInHelmet / 8.0f);
            this.player.func_70050_g(this.player.func_70086_ai() + playerAir);
            int airUsed = playerAir * 8;
            this.addAir(EntityEquipmentSlot.HEAD, -airUsed);
            NetworkHandler.sendTo(new PacketPlaySound(Sounds.SCUBA, SoundCategory.PLAYERS, this.player.func_180425_c(), 1.5f, 1.0f, false), (EntityPlayerMP)this.player);
            Vec3d eyes = this.player.func_174824_e(1.0f).func_178787_e(this.player.func_70040_Z().func_186678_a(0.5));
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.WATER_BUBBLE, eyes.field_72450_a - 0.5, eyes.field_72448_b, eyes.field_72449_c - 0.5, 0.0, 0.2, 0.0, 10, 1.0, 1.0, 1.0), this.player.field_70170_p);
        }
    }

    private void handleLeggingsSpeedBoost() {
        double speedBoost = this.getSpeedBoostFromLegs();
        if (this.player.field_70170_p.field_72995_K && this.player.field_191988_bg > 0.0f) {
            if (!this.player.field_70122_E && this.isJetBootsEnabled() && this.jetBootsBuilderMode) {
                this.player.func_191958_b(0.0f, 0.0f, 1.0f, (float)this.getUpgradeCount(EntityEquipmentSlot.FEET, IItemRegistry.EnumUpgrade.JET_BOOTS) / 400.0f);
            }
            if (this.player.field_70122_E && !this.player.func_70055_a(Material.field_151586_h)) {
                this.player.func_191958_b(0.0f, 0.0f, 1.0f, (float)speedBoost);
            }
        }
        if (!this.player.field_70170_p.field_72995_K && speedBoost > 0.0) {
            boolean moved;
            Vec3d prev = moveMap.get(this.player.func_70005_c_());
            boolean bl = moved = prev != null && (Math.abs(this.player.field_70165_t - prev.field_72450_a) > 1.0E-4 || Math.abs(this.player.field_70161_v - prev.field_72449_c) > 1.0E-4);
            if (moved && this.player.field_70122_E && !this.player.func_70055_a(Material.field_151586_h)) {
                int airUsage = (int)Math.ceil(1.0 * speedBoost * 4.0);
                ItemStack legsStack = this.player.func_184582_a(EntityEquipmentSlot.LEGS);
                this.addAir(EntityEquipmentSlot.LEGS, -airUsage);
            }
            moveMap.put(this.player.func_70005_c_(), new Vec3d(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v));
        }
    }

    public double getSpeedBoostFromLegs() {
        int speedUpgrades = this.getUpgradeCount(EntityEquipmentSlot.LEGS, IItemRegistry.EnumUpgrade.SPEED, 4);
        if (this.isArmorReady(EntityEquipmentSlot.LEGS) && speedUpgrades > 0 && this.isRunSpeedEnabled() && this.getArmorPressure(EntityEquipmentSlot.LEGS) > 0.0f) {
            return 0.035f * (float)speedUpgrades * this.speedBoostMult;
        }
        return 0.0;
    }

    private void handleJetBoots() {
        int jetbootsCount = this.getUpgradeCount(EntityEquipmentSlot.FEET, IItemRegistry.EnumUpgrade.JET_BOOTS, 10);
        if (jetbootsCount == 0) {
            return;
        }
        int jetbootsAirUsage = 0;
        if (this.getArmorPressure(EntityEquipmentSlot.FEET) > 0.0f) {
            if (this.isJetBootsActive()) {
                if (this.jetBootsBuilderMode && jetbootsCount >= 8) {
                    this.player.field_70181_x = this.player.func_70093_af() ? 0.0 : 0.15 + 0.15 * (double)(jetbootsCount - 8);
                    jetbootsAirUsage = (int)((float)(ConfigHandler.pneumaticArmor.jetbootsAirUsage * jetbootsCount) / 5.0f);
                } else {
                    Vec3d lookVec = this.player.func_70040_Z().func_186678_a(0.15 * (double)jetbootsCount);
                    this.flightAccel = (float)((double)this.flightAccel + lookVec.field_72448_b / -20.0);
                    this.flightAccel = MathHelper.func_76131_a((float)this.flightAccel, (float)0.8f, (float)4.0f);
                    lookVec = lookVec.func_186678_a((double)this.flightAccel);
                    if (this.jetBootsActiveTicks < 10) {
                        lookVec = lookVec.func_186678_a((double)this.jetBootsActiveTicks * 0.1);
                    }
                    this.player.field_70159_w = lookVec.field_72450_a;
                    this.player.field_70181_x = this.player.field_70122_E ? 0.0 : lookVec.field_72448_b;
                    this.player.field_70179_y = lookVec.field_72449_c;
                    jetbootsAirUsage = ConfigHandler.pneumaticArmor.jetbootsAirUsage * jetbootsCount;
                }
                ++this.jetBootsActiveTicks;
            } else if (this.isJetBootsEnabled() && !this.player.field_70122_E) {
                this.player.field_70181_x = jetbootsCount > 6 && !this.player.func_70093_af() ? 0.0 : (this.player.func_70093_af() ? -0.45 : -0.15 + 0.015 * (double)jetbootsCount);
                this.player.field_70143_R = 0.0f;
                jetbootsAirUsage = (int)((float)ConfigHandler.pneumaticArmor.jetbootsAirUsage * (this.player.func_70093_af() ? 0.25f : 0.5f));
                this.flightAccel = 1.0f;
            } else {
                this.flightAccel = 1.0f;
            }
        }
        if (jetbootsAirUsage != 0 && !this.player.field_70170_p.field_72995_K) {
            if (this.prevJetBootsAirUsage == 0) {
                NetworkHandler.sendToDimension(new PacketPlayMovingSound(MovingSounds.Sound.JET_BOOTS, this.player), this.player.field_70170_p.field_73011_w.getDimension());
                AdvancementTriggers.FLIGHT.trigger((EntityPlayerMP)this.player);
            }
            if (this.player.field_70123_F) {
                double vel = Math.sqrt(this.player.field_70179_y * this.player.field_70179_y + this.player.field_70159_w * this.player.field_70159_w);
                if (this.player.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    vel *= 2.0;
                } else if (this.player.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    vel *= 1.5;
                }
                if (vel > 2.0) {
                    this.player.func_184185_a(vel > 2.5 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE, 1.0f, 1.0f);
                    this.player.func_70097_a(DamageSource.field_188406_j, (float)vel);
                    AdvancementTriggers.FLY_INTO_WALL.trigger((EntityPlayerMP)this.player);
                }
            }
            this.addAir(EntityEquipmentSlot.FEET, -jetbootsAirUsage);
        }
        this.prevJetBootsAirUsage = jetbootsAirUsage;
    }

    private void handleChestplateCharging() {
        if (this.player.field_70170_p.field_72995_K || !this.chargingEnabled || this.getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.CHARGING) == 0 || this.getTicksSinceEquipped(EntityEquipmentSlot.CHEST) % 20 != 5) {
            return;
        }
        int upgrades = this.getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.CHARGING, 6);
        int airAmount = upgrades * 100 + 100;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot == EntityEquipmentSlot.CHEST) continue;
            if (this.armorPressure[EntityEquipmentSlot.CHEST.func_188454_b()] < 0.1f) {
                return;
            }
            ItemStack stack = this.player.func_184582_a(slot);
            this.tryPressurize(airAmount, stack);
        }
        for (ItemStack stack : this.player.field_71071_by.field_70462_a) {
            if (this.armorPressure[EntityEquipmentSlot.CHEST.func_188454_b()] < 0.1f) {
                return;
            }
            this.tryPressurize(airAmount, stack);
        }
    }

    private void tryPressurize(int airAmount, ItemStack destStack) {
        IPressurizable p;
        float pressure;
        if (destStack.func_77973_b() instanceof IPressurizable && (pressure = (p = (IPressurizable)destStack.func_77973_b()).getPressure(destStack)) < p.maxPressure(destStack) && pressure < this.armorPressure[EntityEquipmentSlot.CHEST.func_188454_b()]) {
            float currentAir = pressure * (float)p.getVolume(destStack);
            float targetAir = this.armorPressure[EntityEquipmentSlot.CHEST.func_188454_b()] * (float)p.getVolume(destStack);
            int amountToMove = Math.min((int)(targetAir - currentAir), airAmount);
            p.addAir(destStack, amountToMove);
            this.addAir(EntityEquipmentSlot.CHEST, -amountToMove);
        }
    }

    private void handleItemRepair(EntityEquipmentSlot slot) {
        int upgrades = this.getUpgradeCount(slot, IItemRegistry.EnumUpgrade.ITEM_LIFE, 5);
        int interval = 120 - 20 * upgrades;
        int airUsage = 100 * upgrades;
        ItemStack armorStack = this.player.func_184582_a(slot);
        if (armorStack.func_77952_i() > 0 && this.armorPressure[slot.func_188454_b()] > 0.1f && this.ticksSinceEquip[slot.func_188454_b()] % interval == 0) {
            this.addAir(slot, -airUsage);
            armorStack.func_77964_b(armorStack.func_77952_i() - 1);
        }
    }

    private void handleChestplateMagnet() {
        if (this.player.field_70170_p.field_72995_K || !this.magnetEnabled || (this.getTicksSinceEquipped(EntityEquipmentSlot.CHEST) & 3) != 0 || this.getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.MAGNET) == 0) {
            return;
        }
        AxisAlignedBB box = new AxisAlignedBB(this.player.func_180425_c()).func_186662_g((double)this.magnetRadius);
        List itemList = this.player.func_130014_f_().func_175647_a(Entity.class, box, e -> (e instanceof EntityXPOrb || e instanceof EntityItem) && e.func_70089_S());
        Vec3d playerVec = this.player.func_174791_d();
        for (Entity item : itemList) {
            if (item instanceof EntityItem && ((EntityItem)item).func_174874_s() || !(item.func_174791_d().func_72436_e(playerVec) <= (double)this.magnetRadiusSq) || ItemRegistry.getInstance().shouldSuppressMagnet(item) || item.getEntityData().func_74767_n("PreventRemoteMovement")) continue;
            if (this.armorPressure[EntityEquipmentSlot.CHEST.func_188454_b()] < 0.1f) break;
            item.func_70107_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
            if (item instanceof EntityItem) {
                ((EntityItem)item).func_174867_a(0);
            }
            this.addAir(EntityEquipmentSlot.CHEST, -20);
        }
    }

    private void handleHacking() {
        if (this.hackedBlock != null) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForCoord(this.hackedBlock, this.player);
            if (hackableBlock != null) {
                if (++this.hackTime >= hackableBlock.getHackTime(this.hackedBlock.world, this.hackedBlock.pos, this.player)) {
                    hackableBlock.onHackFinished(this.player.field_70170_p, this.hackedBlock.pos, this.player);
                    PneumaticCraftRepressurized.proxy.getHackTickHandler().trackBlock(this.hackedBlock, hackableBlock);
                    NetworkHandler.sendToAllAround(new PacketHackingBlockFinish(this.hackedBlock), this.player.field_70170_p);
                    this.setHackedBlock(null);
                    AdvancementTriggers.BLOCK_HACK.trigger((EntityPlayerMP)this.player);
                }
            } else {
                this.setHackedBlock(null);
            }
        } else if (this.hackedEntity != null) {
            IHackableEntity hackableEntity = HackableHandler.getHackableForEntity(this.hackedEntity, this.player);
            if (hackableEntity != null) {
                if (++this.hackTime >= hackableEntity.getHackTime(this.hackedEntity, this.player)) {
                    hackableEntity.onHackFinished(this.hackedEntity, this.player);
                    PneumaticCraftRepressurized.proxy.getHackTickHandler().trackEntity(this.hackedEntity, hackableEntity);
                    NetworkHandler.sendToAllAround(new PacketHackingEntityFinish(this.hackedEntity), new NetworkRegistry.TargetPoint(this.hackedEntity.field_70170_p.field_73011_w.getDimension(), this.hackedEntity.field_70165_t, this.hackedEntity.field_70163_u, this.hackedEntity.field_70161_v, 64.0));
                    this.setHackedEntity(null);
                    AdvancementTriggers.ENTITY_HACK.trigger((EntityPlayerMP)this.player);
                }
            } else {
                this.setHackedEntity(null);
            }
        }
    }

    public void initArmorInventory(EntityEquipmentSlot slot) {
        ItemStack armorStack = this.player.func_184582_a(slot);
        ItemStack[] upgradeStacks = UpgradableItemUtils.getUpgradeStacks(armorStack);
        Arrays.fill(this.upgradeRenderersInserted[slot.func_188454_b()], false);
        for (int i = 0; i < this.upgradeRenderersInserted[slot.func_188454_b()].length; ++i) {
            this.upgradeRenderersInserted[slot.func_188454_b()][i] = this.isModuleEnabled(upgradeStacks, UpgradeRenderHandlerList.instance().getHandlersForSlot(slot).get(i));
        }
        Arrays.fill(this.upgradeMatrix[slot.func_188454_b()], 0);
        for (ItemStack stack : upgradeStacks) {
            if (!(stack.func_77973_b() instanceof ItemMachineUpgrade)) continue;
            int[] nArray = this.upgradeMatrix[slot.func_188454_b()];
            int n = ((ItemMachineUpgrade)stack.func_77973_b()).getUpgradeType().ordinal();
            nArray[n] = nArray[n] + stack.func_190916_E();
        }
        this.startupTimes[slot.func_188454_b()] = (int)((double)ConfigHandler.pneumaticArmor.armorStartupTime * Math.pow(0.8, this.getSpeedFromUpgrades(slot) - 1));
        switch (slot) {
            case CHEST: {
                this.magnetRadius = 4 + Math.min(this.getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.MAGNET), 6);
                this.magnetRadiusSq = this.magnetRadius * this.magnetRadius;
                break;
            }
            case LEGS: {
                this.speedBoostMult = (float)ItemPneumaticArmor.getIntData(armorStack, "speedBoost", 100) / 100.0f;
                break;
            }
            case FEET: {
                this.jetBootsBuilderMode = ItemPneumaticArmor.getBooleanData(armorStack, "JetBootsBuilderMode", false);
                JetBootsStateTracker.getTracker(this.player).setJetBootsState(this.player, this.isJetBootsEnabled(), this.isJetBootsActive(), this.jetBootsBuilderMode);
            }
        }
    }

    public int getUpgradeCount(EntityEquipmentSlot slot, IItemRegistry.EnumUpgrade upgrade) {
        return this.upgradeMatrix[slot.func_188454_b()][upgrade.ordinal()];
    }

    public int getUpgradeCount(EntityEquipmentSlot slot, IItemRegistry.EnumUpgrade upgrade, int max) {
        return Math.min(max, this.upgradeMatrix[slot.func_188454_b()][upgrade.ordinal()]);
    }

    public boolean isUpgradeRendererInserted(EntityEquipmentSlot slot, int i) {
        return this.upgradeRenderersInserted[slot.func_188454_b()][i];
    }

    public boolean isUpgradeRendererEnabled(EntityEquipmentSlot slot, int i) {
        return this.upgradeRenderersEnabled[slot.func_188454_b()][i];
    }

    public void setUpgradeRenderEnabled(EntityEquipmentSlot slot, byte featureIndex, boolean state) {
        this.upgradeRenderersEnabled[slot.func_188454_b()][featureIndex] = state;
        IUpgradeRenderHandler handler = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot).get(featureIndex);
        if (handler instanceof MagnetUpgradeHandler) {
            this.magnetEnabled = state;
        } else if (handler instanceof ChargingUpgradeHandler) {
            this.chargingEnabled = state;
        } else if (handler instanceof StepAssistUpgradeHandler) {
            this.stepAssistEnabled = state;
        } else if (handler instanceof RunSpeedUpgradeHandler) {
            this.runSpeedEnabled = state;
        } else if (handler instanceof JumpBoostUpgradeHandler) {
            this.jumpBoostEnabled = state;
        } else if (handler instanceof JetBootsUpgradeHandler) {
            this.jetBootsEnabled = state;
            JetBootsStateTracker.getTracker(this.player).setJetBootsState(this.player, this.jetBootsEnabled, this.isJetBootsActive(), this.isJetBootsBuilderMode());
        } else if (handler instanceof MainHelmetHandler) {
            this.armorEnabled = state;
        } else if (handler instanceof EntityTrackUpgradeHandler) {
            this.entityTrackerEnabled = state;
        } else if (handler instanceof NightVisionUpgradeHandler) {
            this.nightVisionEnabled = state;
        } else if (handler instanceof ScubaUpgradeHandler) {
            this.scubaEnabled = state;
        } else if (handler instanceof AirConUpgradeHandler) {
            this.airConEnabled = state;
        }
    }

    public int getTicksSinceEquipped(EntityEquipmentSlot slot) {
        return this.ticksSinceEquip[slot.func_188454_b()];
    }

    private boolean isModuleEnabled(ItemStack[] helmetStacks, IUpgradeRenderHandler handler) {
        for (Item requiredUpgrade : handler.getRequiredUpgrades()) {
            boolean found = false;
            for (ItemStack stack : helmetStacks) {
                if (stack.func_77973_b() != requiredUpgrade) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int getSpeedFromUpgrades(EntityEquipmentSlot slot) {
        return 1 + this.getUpgradeCount(slot, IItemRegistry.EnumUpgrade.SPEED);
    }

    public int getStartupTime(EntityEquipmentSlot slot) {
        return this.startupTimes[slot.func_188454_b()];
    }

    public void setHackedBlock(WorldAndCoord blockPos) {
        this.hackedBlock = blockPos;
        this.hackedEntity = null;
        this.hackTime = 0;
    }

    public void setHackedEntity(Entity entity) {
        this.hackedEntity = entity;
        this.hackedBlock = null;
        this.hackTime = 0;
    }

    public boolean isArmorReady(EntityEquipmentSlot slot) {
        return this.getTicksSinceEquipped(slot) > this.getStartupTime(slot);
    }

    public boolean isStepAssistEnabled() {
        return this.stepAssistEnabled;
    }

    public boolean isRunSpeedEnabled() {
        return this.runSpeedEnabled;
    }

    public boolean isJumpBoostEnabled() {
        return this.jumpBoostEnabled;
    }

    public boolean isAirConEnabled() {
        return this.airConEnabled;
    }

    public float getArmorPressure(EntityEquipmentSlot slot) {
        return this.armorPressure[slot.func_188454_b()];
    }

    public void setJetBootsActive(boolean jetBootsActive) {
        if (!jetBootsActive) {
            this.jetBootsActiveTicks = 0;
        }
        this.jetBootsActive = jetBootsActive;
        JetBootsStateTracker.getTracker(this.player).setJetBootsState(this.player, this.isJetBootsEnabled(), jetBootsActive, this.isJetBootsBuilderMode());
    }

    public boolean isJetBootsActive() {
        return this.jetBootsActive;
    }

    public boolean isJetBootsEnabled() {
        return this.jetBootsEnabled;
    }

    public boolean isArmorEnabled() {
        return this.armorEnabled;
    }

    public boolean isEntityTrackerEnabled() {
        return this.entityTrackerEnabled;
    }

    public boolean isScubaEnabled() {
        return this.scubaEnabled;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isJetBootsBuilderMode() {
        return this.jetBootsBuilderMode;
    }

    public void onDataFieldUpdated(EntityEquipmentSlot slot, String key, NBTBase dataTag) {
        switch (key) {
            case "speedBoost": {
                this.speedBoostMult = MathHelper.func_76131_a((float)((float)((NBTTagInt)dataTag).func_150287_d() / 100.0f), (float)0.0f, (float)1.0f);
                break;
            }
            case "JetBootsBuilderMode": {
                this.jetBootsBuilderMode = ((NBTTagByte)dataTag).func_150290_f() == 1;
                JetBootsStateTracker.getTracker(this.player).getJetBootsState(this.player).setBuilderMode(this.jetBootsBuilderMode);
            }
        }
    }

    static {
        moveMap = new HashMap<String, Vec3d>();
    }
}

