/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import me.desht.pneumaticcraft.common.thirdparty.waila.WailaCallback;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class WailaPneumaticHandler
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        WailaPneumaticHandler.addTipToMachine(currenttip, accessor);
        return currenttip;
    }

    private static void addTipToMachine(List<String> currenttip, IWailaDataAccessor accessor) {
        NBTTagCompound tag = accessor.getNBTData();
        TileEntity te = accessor.getTileEntity();
        if (te instanceof IInfoForwarder) {
            BlockPos infoPos = new BlockPos(tag.func_74762_e("infoX"), tag.func_74762_e("infoY"), tag.func_74762_e("infoZ"));
            te = accessor.getWorld().func_175625_s(infoPos);
        }
        if (te instanceof IPneumaticMachine) {
            WailaPneumaticHandler.addTipToMachine(currenttip, (IPneumaticMachine)te, tag.func_74760_g("pressure"));
        }
    }

    private static void addTipToMachine(List<String> currenttip, IPneumaticMachine machine, float pressure) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("Pressure", PneumaticCraftUtils.roundNumberTo(pressure, 1) + " bar");
        IAirHandler base = machine.getAirHandler(null);
        values.put("Max Pressure", PneumaticCraftUtils.roundNumberTo(base.getDangerPressure(), 1) + " bar");
        for (Map.Entry entry : values.entrySet()) {
            currenttip.add(WailaCallback.COLOR + (String)entry.getKey() + ": " + TextFormatting.WHITE + (String)entry.getValue());
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        TileEntity teInfo;
        if (te instanceof IInfoForwarder) {
            teInfo = ((IInfoForwarder)te).getInfoTileEntity();
            if (teInfo != null) {
                tag.func_74768_a("infoX", teInfo.func_174877_v().func_177958_n());
                tag.func_74768_a("infoY", teInfo.func_174877_v().func_177956_o());
                tag.func_74768_a("infoZ", teInfo.func_174877_v().func_177952_p());
            }
        } else {
            teInfo = te;
        }
        if (teInfo instanceof IPneumaticMachine) {
            tag.func_74776_a("pressure", ((IPneumaticMachine)teInfo).getAirHandler(null).getPressure());
        }
        return tag;
    }
}

