/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.chisel.items;

import java.util.List;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.plugin.chisel.ChiselPlugin;
import knightminer.tcomplement.plugin.toolleveling.ToolLevelingPlugin;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import team.chisel.api.IChiselGuiType;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.api.carving.IChiselMode;

@Optional.Interface(iface="team.chisel.api.IChiselItem", modid="chisel")
public class ItemChisel
extends AoeToolCore
implements IChiselItem {
    public static final float DURABILITY_MODIFIER = 2.25f;

    public ItemChisel() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toolRod), PartMaterialType.head((IToolPart)ChiselPlugin.chiselHead)});
        this.func_77637_a((CreativeTabs)TCompRegistry.tabTools);
        this.addCategory(new Category[]{Category.WEAPON, ChiselPlugin.CHISEL});
    }

    public float damagePotential() {
        return 0.5f;
    }

    public double attackSpeed() {
        return 1.15f;
    }

    public float getRepairModifierForPart(int index) {
        return 2.25f;
    }

    public ToolNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        ToolNBT data = new ToolNBT();
        data.head(new HeadMaterialStats[]{head});
        data.handle(new HandleMaterialStats[]{handle});
        data.harvestLevel = head.harvestLevel;
        data.durability = (int)((float)data.durability * 2.25f);
        return data;
    }

    @Optional.Method(modid="chisel")
    public boolean canOpenGui(World world, EntityPlayer player, EnumHand hand) {
        return !ToolHelper.isBroken((ItemStack)player.func_184586_b(hand));
    }

    @Optional.Method(modid="chisel")
    public IChiselGuiType getGuiType(World world, EntityPlayer player, EnumHand hand) {
        NBTTagCompound tags = TagUtil.getTagSafe((ItemStack)player.func_184586_b(hand));
        return TinkerUtil.hasModifier((NBTTagCompound)tags, (String)ChiselPlugin.modHitech.getIdentifier()) ? IChiselGuiType.ChiselGuiType.HITECH : IChiselGuiType.ChiselGuiType.NORMAL;
    }

    @Optional.Method(modid="chisel")
    public boolean supportsMode(EntityPlayer player, ItemStack stack, IChiselMode mode) {
        String name = mode.name();
        if (name.equals("SINGLE")) {
            return true;
        }
        NBTTagCompound tags = TagUtil.getTagSafe((ItemStack)stack);
        boolean hasWidth = TinkerUtil.hasModifier((NBTTagCompound)tags, (String)TinkerModifiers.modHarvestWidth.getIdentifier());
        boolean hasHeight = TinkerUtil.hasModifier((NBTTagCompound)tags, (String)TinkerModifiers.modHarvestHeight.getIdentifier());
        boolean hasHitech = TinkerUtil.hasModifier((NBTTagCompound)tags, (String)ChiselPlugin.modHitech.getIdentifier());
        switch (name) {
            case "COLUMN": {
                return hasHeight;
            }
            case "ROW": {
                return hasWidth;
            }
            case "PANEL": {
                return hasWidth && hasHeight;
            }
            case "CONTIGUOUS": {
                return hasWidth && hasHeight && hasHitech;
            }
            case "CONTIGUOUS_2D": {
                return (hasWidth || hasHeight) && hasHitech;
            }
        }
        return false;
    }

    @Optional.Method(modid="chisel")
    public boolean onChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return true;
    }

    @Optional.Method(modid="chisel")
    public boolean canChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return !ToolHelper.isBroken((ItemStack)chisel);
    }

    @Optional.Method(modid="chisel")
    public boolean canChiselBlock(World world, EntityPlayer player, EnumHand hand, BlockPos pos, IBlockState state) {
        ItemStack chisel = player.func_184586_b(hand);
        if (ToolHelper.isBroken((ItemStack)chisel)) {
            return false;
        }
        return ToolHelper.getHarvestLevelStat((ItemStack)chisel) >= state.func_177230_c().getHarvestLevel(state);
    }

    @Optional.Method(modid="chisel")
    public ItemStack craftItem(ItemStack chisel, ItemStack source, ItemStack target, EntityPlayer player) {
        int toCraft = Math.min(source.func_190916_E(), target.func_77976_d());
        int damageLeft = chisel.func_77958_k() - chisel.func_77952_i();
        toCraft = Math.min(toCraft, damageLeft);
        ToolHelper.damageTool((ItemStack)chisel, (int)toCraft, (EntityLivingBase)player);
        ToolLevelingPlugin.xpAdder.addXp(chisel, toCraft, player);
        ItemStack res = target.func_77946_l();
        source.func_190918_g(toCraft);
        res.func_190920_e(toCraft);
        return res;
    }
}

