/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.block.BlockRoots;
import vazkii.quark.world.block.BlockRootsFlower;
import vazkii.quark.world.item.ItemRoot;
import vazkii.quark.world.item.ItemRootDye;
import vazkii.quark.world.item.ItemRootFlower;
import vazkii.quark.world.world.CaveRootGenerator;

public class CaveRoots
extends Feature {
    public static int chunkAttempts;
    public static int minY;
    public static int maxY;
    public static boolean enableFlowers;
    public static float flowerChance;
    public static float rootDropChance;
    public static float rootFlowerDropChance;
    public static DimensionConfig dimensions;
    public static Block roots;
    public static Block roots_blue_flower;
    public static Block roots_black_flower;
    public static Block roots_white_flower;
    public static Item root;
    public static Item root_flower;
    public static Item root_dye;

    @Override
    public void setupConfig() {
        chunkAttempts = this.loadPropInt("Attempts per Chunk", "How many times the world generator will try to place roots per chunk", 300);
        minY = this.loadPropInt("Min Y", "", 16);
        maxY = this.loadPropInt("Max Y", "", 52);
        enableFlowers = this.loadPropBool("Enable Flowers", "", true);
        flowerChance = (float)this.loadPropDouble("Flower Chance", "The chance for a root to sprout a flower when it grows. 0 is 0%, 1 is 100%", 0.2);
        rootDropChance = (float)this.loadPropDouble("Root Drop Chance", "The chance for a root to drop the root item when broken. 0 is 0%, 1 is 100%", 0.1);
        rootFlowerDropChance = (float)this.loadPropDouble("Root Flower Drop Chance", "The chance for a flower root to drop the sprout item when broken. 0 is 0%, 1 is 100%", 1.0);
        dimensions = new DimensionConfig(this.configCategory);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        roots = new BlockRoots();
        root = new ItemRoot();
        if (enableFlowers) {
            roots_blue_flower = new BlockRootsFlower("roots_blue_flower", 0);
            roots_black_flower = new BlockRootsFlower("roots_black_flower", 1);
            roots_white_flower = new BlockRootsFlower("roots_white_flower", 2);
            root_flower = new ItemRootFlower();
            root_dye = new ItemRootDye();
            for (int i = 0; i < 3; ++i) {
                RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)root_dye, (int)1, (int)i), (Object[])new Object[]{ProxyRegistry.newStack((Item)root_flower, (int)1, (int)i)});
            }
            CaveRoots.addOreDict("dyeBlue", ProxyRegistry.newStack((Item)root_dye, (int)1, (int)0));
            CaveRoots.addOreDict("dyeBlack", ProxyRegistry.newStack((Item)root_dye, (int)1, (int)1));
            CaveRoots.addOreDict("dyeWhite", ProxyRegistry.newStack((Item)root_dye, (int)1, (int)2));
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new CaveRootGenerator(), (int)2000);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

