/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.feature.DungeonTweaksCompat;

public class VariedDungeons
extends Feature {
    public static ResourceLocation lootTable;
    public static int tries;

    @Override
    public void setupConfig() {
        String lootTableStr = this.loadPropString("Custom Loot Table", "Set this to anything other than an empty line to load a custom loot table for the dungeons.", "");
        lootTable = lootTableStr.isEmpty() ? null : new ResourceLocation(lootTableStr);
        tries = this.loadPropInt("Tries Per Chunk", "How many times per chunk will the generator try to place a dungeon. The higher, the more dungeons you'll get", 7);
    }

    @SubscribeEvent
    public void onDungeonSpawn(PopulateChunkEvent.Populate event) {
        if (event.getType() != PopulateChunkEvent.Populate.EventType.DUNGEON) {
            return;
        }
        int i = event.getChunkX() * 16;
        int j = event.getChunkZ() * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        World world = event.getWorld();
        Random rand = event.getRand();
        if (world instanceof WorldServer) {
            for (int k = 0; k < tries; ++k) {
                int z;
                int y;
                int x = rand.nextInt(16) + 8;
                BlockPos generatePos = blockpos.func_177982_a(x, y = rand.nextInt(256), z = rand.nextInt(16) + 8);
                if (!this.couldDungeonGenerate(world, rand, generatePos)) continue;
                this.placeDungeonAt((WorldServer)world, rand, generatePos);
                break;
            }
        }
    }

    public boolean couldDungeonGenerate(World worldIn, Random rand, BlockPos position) {
        int i = 3;
        int j = rand.nextInt(2) + 2;
        int k = -j - 1;
        int l = j + 1;
        int i1 = -1;
        int j1 = 4;
        int k1 = rand.nextInt(2) + 2;
        int l1 = -k1 - 1;
        int i2 = k1 + 1;
        int j2 = 0;
        for (int k2 = k; k2 <= l; ++k2) {
            for (int l2 = -1; l2 <= 4; ++l2) {
                for (int i3 = l1; i3 <= i2; ++i3) {
                    BlockPos blockpos = position.func_177982_a(k2, l2, i3);
                    Material material = worldIn.func_180495_p(blockpos).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (l2 == -1 && !flag) {
                        return false;
                    }
                    if (l2 == 4 && !flag) {
                        return false;
                    }
                    if (k2 != k && k2 != l && i3 != l1 && i3 != i2 || l2 != 0 || !worldIn.func_175623_d(blockpos) || !worldIn.func_175623_d(blockpos.func_177984_a())) continue;
                    ++j2;
                }
            }
        }
        return j2 >= 1 && j2 <= 5;
    }

    public void placeDungeonAt(WorldServer world, Random rand, BlockPos position) {
        int dungeonType = rand.nextInt(10);
        MinecraftServer server = world.func_73046_m();
        Template template = world.func_184163_y().func_186237_a(server, new ResourceLocation("quark", "dungeon_" + dungeonType));
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(Rotation.values()[rand.nextInt(Rotation.values().length)]);
        BlockPos size = template.func_186259_a();
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    BlockPos checkPos = position.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(x, y, z)));
                    IBlockState iBlockState = world.func_180495_p(checkPos);
                    if (iBlockState.func_185887_b((World)world, checkPos) != -1.0f && !world.func_175710_j(checkPos)) continue;
                    return;
                }
            }
        }
        template.func_186253_b((World)world, position, settings);
        int spawners = 0;
        ArrayList<BlockPos> chests = new ArrayList<BlockPos>();
        Map dataBlocks = template.func_186258_a(position, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            String data = (String)entry.getValue();
            if (data.equals("spawner")) {
                ++spawners;
                world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tile = world.func_175625_s(pos);
                if (!(tile instanceof TileEntityMobSpawner)) continue;
                if (DungeonTweaksCompat.isLoaded) {
                    DungeonTweaksCompat.fireDungeonSpawn(tile, (World)world, rand);
                    continue;
                }
                ((TileEntityMobSpawner)tile).func_145881_a().func_190894_a(DungeonHooks.getRandomDungeonMob((Random)rand));
                continue;
            }
            if (!data.equals("chest")) continue;
            chests.add(pos);
        }
        int maxChests = spawners * 2 + rand.nextInt(spawners + 2);
        while (chests.size() > maxChests) {
            int n = rand.nextInt(chests.size());
            BlockPos chestPos = (BlockPos)chests.get(n);
            chests.remove(n);
            world.func_175698_g(chestPos);
        }
        for (BlockPos pos : chests) {
            world.func_180501_a(pos, Blocks.field_150486_ae.func_176458_f((World)world, pos, Blocks.field_150486_ae.func_176223_P()), 2);
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileEntityChest)) continue;
            if (lootTable == null) {
                ((TileEntityChest)tile).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
                continue;
            }
            ((TileEntityChest)tile).func_189404_a(lootTable, rand.nextLong());
        }
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }
}

