/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.feature.UndergroundBiomes;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomeIcy
extends BasicUndergroundBiome {
    public static int stalagmiteChance;
    public static boolean usePackedIce;

    public UndergroundBiomeIcy() {
        super(Blocks.field_150432_aD.func_176223_P(), null, null, true);
    }

    @Override
    public void fillCeiling(World world, BlockPos pos, IBlockState state) {
        if (UndergroundBiomes.icystoneEnabled) {
            world.func_180501_a(pos, UndergroundBiomes.icystoneState, 2);
        }
    }

    @Override
    public void fillWall(World world, BlockPos pos, IBlockState state) {
        this.fillCeiling(world, pos, state);
    }

    @Override
    public void fillFloor(World world, BlockPos pos, IBlockState state) {
        IBlockState placeState = this.floorState;
        if (usePackedIce) {
            placeState = Blocks.field_150403_cj.func_176223_P();
        }
        BlockPos placePos = pos;
        world.func_180501_a(pos, placeState, 2);
        if (stalagmiteChance > 0 && world.field_73012_v.nextInt(stalagmiteChance) == 0) {
            int height = 3 + world.field_73012_v.nextInt(3);
            for (int i = 0; i < height; ++i) {
                placePos = placePos.func_177984_a();
                IBlockState stateAt = world.func_180495_p(placePos);
                if (!world.func_180495_p(placePos).func_177230_c().isAir(stateAt, (IBlockAccess)world, placePos)) break;
                world.func_180501_a(placePos, placeState, 2);
            }
        }
    }

    @Override
    public void setupConfig(String category) {
        stalagmiteChance = ModuleLoader.config.getInt("Stalagmite Chance", category, 60, 0, Integer.MAX_VALUE, "The higher, the less stalagmites will spawn");
        usePackedIce = ModuleLoader.config.getBoolean("Use Packed Ice", category, true, "");
    }
}

