/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.core.BCCoreConfig;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.tile.TileMiner;
import buildcraft.lib.inventory.AutomaticProvidingTransactor;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.world.WorldEventListenerAdapter;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;

public class TileMiningWell
extends TileMiner {
    private boolean shouldCheck = true;
    private final SafeTimeTracker tracker = new SafeTimeTracker(256L);
    private final IWorldEventListener worldEventListener = new WorldEventListenerAdapter(){

        public void func_184376_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, int flags) {
            if (pos.func_177958_n() == TileMiningWell.this.field_174879_c.func_177958_n() && pos.func_177956_o() <= TileMiningWell.this.field_174879_c.func_177956_o() && pos.func_177952_p() == TileMiningWell.this.field_174879_c.func_177952_p()) {
                TileMiningWell.this.shouldCheck = true;
            }
        }
    };

    public TileMiningWell() {
        this.caps.addCapabilityInstance(CapUtil.CAP_ITEM_TRANSACTOR, (Object)AutomaticProvidingTransactor.INSTANCE, EnumPipePart.VALUES);
    }

    @Override
    protected void mine() {
        if (this.currentPos != null && this.canBreak()) {
            this.shouldCheck = true;
            long target = BlockUtil.computeBlockBreakPower((World)this.field_145850_b, (BlockPos)this.currentPos);
            this.progress = (int)((long)this.progress + this.battery.extractPower(0L, target - (long)this.progress));
            if ((long)this.progress >= target) {
                this.progress = 0;
                this.field_145850_b.func_175715_c(this.currentPos.hashCode(), this.currentPos, -1);
                BlockUtil.breakBlockAndGetDrops((WorldServer)((WorldServer)this.field_145850_b), (BlockPos)this.currentPos, (ItemStack)new ItemStack(Items.field_151046_w), (GameProfile)this.getOwner()).ifPresent(stacks -> stacks.forEach(stack -> InventoryUtil.addToBestAcceptor((World)this.field_145850_b, (BlockPos)this.field_174879_c, null, (ItemStack)stack)));
                this.nextPos();
            } else if (!this.field_145850_b.func_175623_d(this.currentPos)) {
                this.field_145850_b.func_175715_c(this.currentPos.hashCode(), this.currentPos, (int)((long)(this.progress * 9) / target));
            }
        } else if (this.shouldCheck || this.tracker.markTimeIfDelay(this.field_145850_b)) {
            this.nextPos();
            if (this.currentPos == null) {
                this.shouldCheck = false;
            }
        }
    }

    private boolean canBreak() {
        if (this.field_145850_b.func_175623_d(this.currentPos) || BlockUtil.isUnbreakableBlock((World)this.field_145850_b, (BlockPos)this.currentPos, (GameProfile)this.getOwner())) {
            return false;
        }
        Fluid fluid = BlockUtil.getFluidWithFlowing((World)this.field_145850_b, (BlockPos)this.currentPos);
        return fluid == null || fluid.getViscosity() <= 1000;
    }

    private void nextPos() {
        this.currentPos = this.field_174879_c;
        do {
            this.currentPos = this.currentPos.func_177977_b();
            if (this.field_145850_b.func_189509_E(this.currentPos) || this.field_174879_c.func_177956_o() - this.currentPos.func_177956_o() > BCCoreConfig.miningMaxDepth) break;
            if (!this.canBreak()) continue;
            this.updateLength();
            return;
        } while (this.field_145850_b.func_175623_d(this.currentPos) || this.field_145850_b.func_180495_p(this.currentPos).func_177230_c() == BCFactoryBlocks.tube);
        this.currentPos = null;
        this.updateLength();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72954_a(this.worldEventListener);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72848_b(this.worldEventListener);
            if (this.currentPos != null) {
                this.field_145850_b.func_175715_c(this.currentPos.hashCode(), this.currentPos, -1);
            }
        }
    }

    @Override
    protected IMjReceiver createMjReceiver() {
        return new MjBatteryReceiver(this.battery);
    }
}

