/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.Configs;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.block.BlockDryingBasin;
import org.cyclops.integrateddynamics.block.BlockDryingBasinConfig;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasin;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasinConfig;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezer;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezerConfig;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import org.cyclops.integrateddynamics.block.BlockSqueezerConfig;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.infobook.pageelement.AspectAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.DryingBasinRecipeAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.MechanicalDryingBasinRecipeAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.MechanicalSqueezerRecipeAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.OperatorAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.SqueezerRecipeAppendix;
import org.cyclops.integrateddynamics.part.aspect.Aspects;
import org.w3c.dom.Element;

public class OnTheDynamicsOfIntegrationBook
extends InfoBook {
    private static OnTheDynamicsOfIntegrationBook _instance = null;

    private OnTheDynamicsOfIntegrationBook() {
        super((ModBase)IntegratedDynamics._instance, 2);
    }

    public static OnTheDynamicsOfIntegrationBook getInstance() {
        if (_instance == null) {
            _instance = new OnTheDynamicsOfIntegrationBook();
        }
        return _instance;
    }

    static {
        if (Configs.isEnabled(BlockSqueezerConfig.class)) {
            InfoBookParser.registerFactory((String)"integrateddynamics:squeezer_recipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    NonNullList ingredients = InfoBookParser.createOptionalIngredientsFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    FluidStack fluidStack = InfoBookParser.createOptionalFluidStackFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    List recipes = BlockSqueezer.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new IngredientsAndFluidStackRecipeComponent(ingredients, fluidStack));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        StringBuilder unlocalizedItems = new StringBuilder();
                        for (Ingredient ingredient : ingredients) {
                            unlocalizedItems.append(ingredient.func_193365_a()[0].func_77977_a());
                        }
                        throw new InfoBookParser.InvalidAppendixException("Could not find Squeezer recipe for " + unlocalizedItems + " and " + (fluidStack != null ? fluidStack.getFluid().getName() : "null") + " with index " + index);
                    }
                    return new SqueezerRecipeAppendix(infoBook, (IRecipe)recipes.get(index));
                }
            });
            InfoBookParser.registerFactory((String)"integrateddynamics:squeezer_recipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new SqueezerRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"integrateddynamics:squeezer_recipe");
        }
        if (Configs.isEnabled(BlockDryingBasinConfig.class)) {
            InfoBookParser.registerFactory((String)"integrateddynamics:drying_basin_recipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    ItemStack itemStack = InfoBookParser.createOptionalStackFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    FluidStack fluidStack = InfoBookParser.createOptionalFluidStackFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    List recipes = BlockDryingBasin.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new IngredientAndFluidStackRecipeComponent(itemStack, fluidStack));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        throw new InfoBookParser.InvalidAppendixException("Could not find Drying Basin recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new DryingBasinRecipeAppendix(infoBook, (IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>)((IRecipe)recipes.get(index)));
                }
            });
            InfoBookParser.registerFactory((String)"integrateddynamics:drying_basin_recipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new DryingBasinRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"integrateddynamics:drying_basin_recipe");
        }
        if (Configs.isEnabled(BlockMechanicalSqueezerConfig.class)) {
            InfoBookParser.registerFactory((String)"integrateddynamics:mechanical_squeezer_recipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    NonNullList ingredients = InfoBookParser.createOptionalIngredientsFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    FluidStack fluidStack = InfoBookParser.createOptionalFluidStackFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    List recipes = BlockMechanicalSqueezer.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new IngredientsAndFluidStackRecipeComponent(ingredients, fluidStack));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        StringBuilder unlocalizedItems = new StringBuilder();
                        for (Ingredient ingredient : ingredients) {
                            unlocalizedItems.append(ingredient.func_193365_a()[0].func_77977_a());
                        }
                        throw new InfoBookParser.InvalidAppendixException("Could not find MechanicalSqueezer recipe for " + unlocalizedItems + " and " + (fluidStack != null ? fluidStack.getFluid().getName() : "null") + " with index " + index);
                    }
                    return new MechanicalSqueezerRecipeAppendix(infoBook, (IRecipe)recipes.get(index));
                }
            });
            InfoBookParser.registerFactory((String)"integrateddynamics:mechanical_squeezer_recipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new MechanicalSqueezerRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"integrateddynamics:mechanical_squeezer_recipe");
        }
        if (Configs.isEnabled(BlockMechanicalDryingBasinConfig.class)) {
            InfoBookParser.registerFactory((String)"integrateddynamics:mechanical_drying_basin_recipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    ItemStack itemStack = InfoBookParser.createOptionalStackFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    FluidStack fluidStack = InfoBookParser.createOptionalFluidStackFromIngredient((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    List recipes = BlockMechanicalDryingBasin.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new IngredientAndFluidStackRecipeComponent(itemStack, fluidStack));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        throw new InfoBookParser.InvalidAppendixException("Could not find Drying Basin recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new MechanicalDryingBasinRecipeAppendix(infoBook, (IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>)((IRecipe)recipes.get(index)));
                }
            });
            InfoBookParser.registerFactory((String)"integrateddynamics:mechanical_drying_basin_recipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new MechanicalDryingBasinRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"integrateddynamics:mechanical_drying_basin_recipe");
        }
        InfoBookParser.registerFactory((String)"integrateddynamics:aspect", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

            public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String aspectName = node.getTextContent();
                IAspect aspect = Aspects.REGISTRY.getAspect(aspectName);
                if (aspect == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find an aspect by name %s.", aspectName));
                }
                return new AspectAppendix(infoBook, aspect);
            }
        });
        InfoBookParser.registerFactory((String)"integrateddynamics:part_aspects", (InfoBookParser.IAppendixListFactory)new InfoBookParser.IAppendixListFactory(){

            public List<SectionAppendix> create(final IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String partName = node.getTextContent();
                IPartType partType = PartTypes.REGISTRY.getPartType(partName);
                if (partType == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find a part type by name '%s'.", partName));
                }
                ArrayList aspects = Lists.newArrayList(Aspects.REGISTRY.getAspects(partType));
                return Lists.transform((List)aspects, (Function)new Function<IAspect, SectionAppendix>(){

                    @Nullable
                    public SectionAppendix apply(IAspect input) {
                        return new AspectAppendix(infoBook, input);
                    }
                });
            }
        });
        InfoBookParser.registerFactory((String)"integrateddynamics:operator", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

            public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String operatorName = node.getTextContent();
                IOperator operator = Operators.REGISTRY.getOperator(operatorName);
                if (operator == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find an operator by name %s.", operator));
                }
                return new OperatorAppendix(infoBook, operator);
            }
        });
        InfoBookParser.registerFactory((String)"integrateddynamics:operators_output", (InfoBookParser.IAppendixListFactory)new InfoBookParser.IAppendixListFactory(){

            public List<SectionAppendix> create(final IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String categoryName = node.getTextContent();
                ArrayList operators = Lists.newArrayList("*".equals(categoryName) ? Operators.REGISTRY.getOperators() : Operators.REGISTRY.getOperatorsInCategory(categoryName));
                return Lists.transform((List)operators, (Function)new Function<IOperator, SectionAppendix>(){

                    @Nullable
                    public SectionAppendix apply(IOperator input) {
                        return new OperatorAppendix(infoBook, input);
                    }
                });
            }
        });
    }
}

