/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSlider
extends GuiButton {
    private float sliderValue;
    public boolean dragging;
    private final float minValue;
    private final float maxValue;
    private final String baseDisplay;
    private final float valueStep;

    public GuiSlider(int buttonId, String display, int x, int y, float minValueIn, float maxValue, float currentValue, float valueStep) {
        super(buttonId, x, y, 150, 20, "");
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        this.sliderValue = this.normalizeValue(currentValue);
        this.baseDisplay = display;
        this.field_146126_j = this.baseDisplay + ": " + this.denormalizeValue(this.sliderValue);
        this.valueStep = valueStep;
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            float displayValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                displayValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
                float f = this.denormalizeValue(displayValue);
                this.sliderValue = this.normalizeValue(f);
                this.field_146126_j = this.baseDisplay + ": " + f;
            }
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(displayValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(displayValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            this.sliderValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
            this.field_146126_j = this.baseDisplay + ": " + this.sliderValue;
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
    }

    public float normalizeValue(float value) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(value) - this.minValue) / (this.maxValue - this.minValue)), (float)0.0f, (float)1.0f);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp(this.minValue + (this.maxValue - this.minValue) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return MathHelper.func_76131_a((float)value, (float)this.minValue, (float)this.maxValue);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public float getValue() {
        return this.sliderValue;
    }

    public int getValueAdjusted(float adjust) {
        return (int)(this.sliderValue * adjust);
    }

    public void setValue(float value) {
        this.sliderValue = value;
        this.field_146126_j = this.baseDisplay + ": " + this.sliderValue;
    }
}

