/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore.entity;

import com.theprogrammingturkey.gobblecore.GobbleCore;
import com.theprogrammingturkey.gobblecore.IModCore;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityLoader {
    private IModCore subMod = GobbleCore.instance;
    private int id = 0;

    public EntityLoader(IModCore mod) {
        this.subMod = mod;
    }

    public void registerEntity(String name, Class<? extends Entity> entityClass, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(this.subMod.getModID(), name), entityClass, (String)name, (int)this.id++, (Object)this.subMod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public void registerEntityWithEgg(String name, Class<? extends Entity> entityClass, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(this.subMod.getModID(), name), entityClass, (String)name, (int)this.id++, (Object)this.subMod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
    }

    public <T extends Entity> void registerEntityRendering(Class<T> entityClass, final Class<? extends Render<T>> renderer) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (IRenderFactory)new IRenderFactory<T>(){

            public Render<? super T> createRenderFor(RenderManager manager) {
                try {
                    return (Render)renderer.getConstructor(RenderManager.class).newInstance(manager);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }
}

