/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore.items;

import com.theprogrammingturkey.gobblecore.IModCore;
import com.theprogrammingturkey.gobblecore.items.BaseItem;
import com.theprogrammingturkey.gobblecore.items.BaseItemBlock;
import com.theprogrammingturkey.gobblecore.items.BaseItemFood;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemLoader {
    private IModCore subMod;
    private CreativeTabs tab;
    private IForgeRegistry<Item> registry;

    public ItemLoader(IModCore subMod) {
        this.subMod = subMod;
    }

    public void setItemRegistry(IForgeRegistry<Item> registry) {
        this.registry = registry;
    }

    public void registerItem(BaseItem item) {
        this.registerItem(item, item.getItemName());
    }

    public void registerItem(BaseItemFood item) {
        this.registerItem((Item)item, item.getItemName());
    }

    public void registerItem(Item item, String name) {
        item.setRegistryName(this.subMod.getModID(), name);
        item.func_77637_a(this.tab);
        this.registry.register((IForgeRegistryEntry)item);
    }

    public void registerBlockItem(Block block) {
        Item item = (Item)new BaseItemBlock(block).setRegistryName(block.getRegistryName());
        item.func_77637_a(this.tab);
        this.registry.register((IForgeRegistryEntry)item);
    }

    public void registerItemModel(ItemModelMesher mesher, BaseItem item, int meta) {
        this.registerItemModel(mesher, item, meta, item.getItemName());
    }

    public void registerItemModel(ItemModelMesher mesher, BaseItemFood item, int meta) {
        this.registerItemModel(mesher, (Item)item, meta, item.getItemName());
    }

    public void registerItemModel(ItemModelMesher mesher, Item item, int meta, String name) {
        mesher.func_178086_a(item, meta, new ModelResourceLocation(this.subMod.getModID() + ":" + name, "inventory"));
    }

    public void setCreativeTab(CreativeTabs tab) {
        this.tab = tab;
    }
}

