/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.gobblecore.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.theprogrammingturkey.gobblecore.GobbleCore;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class HTTPUtil {
    private static JsonParser json = new JsonParser();

    public static JsonElement getWebFile(String link, RequestType type, Map<String, String> header, Map<String, String> extras) throws Exception {
        int chars_read;
        HttpURLConnection con = (HttpURLConnection)new URL(link).openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setReadTimeout(5000);
        con.setRequestProperty("Connection", "keep-alive");
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:16.0) Gecko/20100101 Firefox/16.0");
        if (header != null) {
            for (String string : header.keySet()) {
                con.setRequestProperty(string, header.get(string));
            }
        }
        con.setRequestMethod(type.name());
        con.setConnectTimeout(5000);
        StringBuilder builder = new StringBuilder();
        if (extras != null) {
            for (String property : extras.keySet()) {
                builder.append(property);
                builder.append("=");
                builder.append(extras.get(property));
                builder.append("&");
            }
            if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
            DataOutputStream dataOutputStream = new DataOutputStream(con.getOutputStream());
            dataOutputStream.writeBytes(builder.toString());
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(con.getInputStream());
        int responseCode = con.getResponseCode();
        if (responseCode != 200 && responseCode != 301) {
            GobbleCore.logger.log(Level.WARN, "Update request returned response code: " + responseCode + " " + con.getResponseMessage());
        } else if (responseCode == 301) {
            throw new Exception();
        }
        StringBuilder buffer = new StringBuilder();
        while ((chars_read = bufferedInputStream.read()) != -1) {
            buffer.append((char)chars_read);
        }
        return json.parse(buffer.toString());
    }

    public static enum RequestType {
        GET,
        POST,
        PUT,
        DELETE,
        UPDATE;

    }
}

