/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.SchematicBlockContext;
import buildcraft.builders.snapshot.JsonRule;
import buildcraft.builders.snapshot.RequiredExtractorItemFromBlock;
import buildcraft.builders.snapshot.RulesLoader;
import buildcraft.builders.snapshot.SchematicBlockManager;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.NBTUtilBC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class SchematicBlockDefault
implements ISchematicBlock {
    protected final Set<BlockPos> requiredBlockOffsets = new HashSet<BlockPos>();
    protected IBlockState blockState;
    protected final List<IProperty<?>> ignoredProperties = new ArrayList();
    protected NBTTagCompound tileNbt;
    protected Rotation tileRotation = Rotation.NONE;
    protected Block placeBlock;
    protected final Set<BlockPos> updateBlockOffsets = new HashSet<BlockPos>();
    protected final Set<Block> canBeReplacedWithBlocks = new HashSet<Block>();

    public static boolean predicate(SchematicBlockContext context) {
        if (context.blockState.func_177230_c().isAir(context.blockState, null, null)) {
            return false;
        }
        ResourceLocation registryName = context.block.getRegistryName();
        return registryName != null && RulesLoader.READ_DOMAINS.contains(registryName.func_110624_b()) && RulesLoader.getRules(context.blockState, context.block.hasTileEntity(context.blockState) && context.world.func_175625_s(context.pos) != null ? context.world.func_175625_s(context.pos).serializeNBT() : null).stream().noneMatch(rule -> rule.ignore);
    }

    protected void setRequiredBlockOffsets(SchematicBlockContext context, Set<JsonRule> rules) {
        this.requiredBlockOffsets.clear();
        rules.stream().map(rule -> rule.requiredBlockOffsets).filter(Objects::nonNull).flatMap(Collection::stream).forEach(this.requiredBlockOffsets::add);
        if (context.block instanceof BlockFalling) {
            this.requiredBlockOffsets.add(new BlockPos(0, -1, 0));
        }
    }

    protected void setBlockState(SchematicBlockContext context, Set<JsonRule> rules) {
        this.blockState = context.blockState;
    }

    protected void setIgnoredProperties(SchematicBlockContext context, Set<JsonRule> rules) {
        this.ignoredProperties.clear();
        rules.stream().map(rule -> rule.ignoredProperties).filter(Objects::nonNull).flatMap(Collection::stream).flatMap(propertyName -> context.blockState.func_177228_b().keySet().stream().filter(property -> property.func_177701_a().equals(propertyName))).forEach(this.ignoredProperties::add);
    }

    protected void setTileNbt(SchematicBlockContext context, Set<JsonRule> rules) {
        TileEntity tileEntity;
        this.tileNbt = null;
        if (context.block.hasTileEntity(context.blockState) && (tileEntity = context.world.func_175625_s(context.pos)) != null) {
            this.tileNbt = tileEntity.serializeNBT();
        }
    }

    protected void setPlaceBlock(SchematicBlockContext context, Set<JsonRule> rules) {
        this.placeBlock = rules.stream().map(rule -> rule.placeBlock).filter(Objects::nonNull).findFirst().map(Block::func_149684_b).orElse(context.block);
    }

    protected void setUpdateBlockOffsets(SchematicBlockContext context, Set<JsonRule> rules) {
        this.updateBlockOffsets.clear();
        if (rules.stream().map(rule -> rule.updateBlockOffsets).anyMatch(Objects::nonNull)) {
            rules.stream().map(rule -> rule.updateBlockOffsets).filter(Objects::nonNull).flatMap(Collection::stream).forEach(this.updateBlockOffsets::add);
        } else {
            Stream.of(EnumFacing.field_82609_l).map(EnumFacing::func_176730_m).map(BlockPos::new).forEach(this.updateBlockOffsets::add);
            this.updateBlockOffsets.add(BlockPos.field_177992_a);
        }
    }

    protected void setCanBeReplacedWithBlocks(SchematicBlockContext context, Set<JsonRule> rules) {
        this.canBeReplacedWithBlocks.clear();
        rules.stream().map(rule -> rule.canBeReplacedWithBlocks).filter(Objects::nonNull).flatMap(Collection::stream).map(Block::func_149684_b).forEach(this.canBeReplacedWithBlocks::add);
        this.canBeReplacedWithBlocks.add(context.block);
        this.canBeReplacedWithBlocks.add(this.placeBlock);
    }

    public void init(SchematicBlockContext context) {
        Set<JsonRule> rules = RulesLoader.getRules(context.blockState, context.block.hasTileEntity(context.blockState) && context.world.func_175625_s(context.pos) != null ? context.world.func_175625_s(context.pos).serializeNBT() : null);
        this.setRequiredBlockOffsets(context, rules);
        this.setBlockState(context, rules);
        this.setIgnoredProperties(context, rules);
        this.setTileNbt(context, rules);
        this.setPlaceBlock(context, rules);
        this.setUpdateBlockOffsets(context, rules);
        this.setCanBeReplacedWithBlocks(context, rules);
    }

    @Nonnull
    public Set<BlockPos> getRequiredBlockOffsets() {
        return this.requiredBlockOffsets;
    }

    @Nonnull
    public List<ItemStack> computeRequiredItems() {
        Set<JsonRule> rules = RulesLoader.getRules(this.blockState, this.tileNbt);
        List collect = rules.stream().map(rule -> rule.requiredExtractors).filter(Objects::nonNull).collect(Collectors.toList());
        return (collect.isEmpty() ? Stream.of(new RequiredExtractorItemFromBlock()) : collect.stream().flatMap(Collection::stream)).flatMap(requiredExtractor -> requiredExtractor.extractItemsFromBlock(this.blockState, this.tileNbt).stream()).filter(((Predicate<ItemStack>)ItemStack::func_190926_b).negate()).collect(Collectors.toList());
    }

    @Nonnull
    public List<FluidStack> computeRequiredFluids() {
        Set<JsonRule> rules = RulesLoader.getRules(this.blockState, this.tileNbt);
        return rules.stream().map(rule -> rule.requiredExtractors).filter(Objects::nonNull).flatMap(Collection::stream).flatMap(requiredExtractor -> requiredExtractor.extractFluidsFromBlock(this.blockState, this.tileNbt).stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public SchematicBlockDefault getRotated(Rotation rotation) {
        SchematicBlockDefault schematicBlock = SchematicBlockManager.createCleanCopy(this);
        this.requiredBlockOffsets.stream().map(blockPos -> blockPos.func_190942_a(rotation)).forEach(schematicBlock.requiredBlockOffsets::add);
        schematicBlock.blockState = this.blockState.func_185907_a(rotation);
        schematicBlock.ignoredProperties.addAll(this.ignoredProperties);
        schematicBlock.tileNbt = this.tileNbt;
        schematicBlock.tileRotation = this.tileRotation.func_185830_a(rotation);
        schematicBlock.placeBlock = this.placeBlock;
        this.updateBlockOffsets.stream().map(blockPos -> blockPos.func_190942_a(rotation)).forEach(schematicBlock.updateBlockOffsets::add);
        schematicBlock.canBeReplacedWithBlocks.addAll(this.canBeReplacedWithBlocks);
        return schematicBlock;
    }

    public boolean canBuild(World world, BlockPos blockPos) {
        return world.func_175623_d(blockPos);
    }

    public boolean build(World world, BlockPos blockPos) {
        if (this.placeBlock == Blocks.field_150350_a) {
            return true;
        }
        world.field_72984_F.func_76320_a("prepare block");
        IBlockState newBlockState = this.blockState;
        if (this.placeBlock != this.blockState.func_177230_c()) {
            newBlockState = this.placeBlock.func_176223_P();
            for (IProperty iProperty : this.blockState.func_177227_a()) {
                if (!newBlockState.func_177227_a().contains(iProperty)) continue;
                newBlockState = BlockUtil.copyProperty((IProperty)iProperty, (IBlockState)newBlockState, (IBlockState)this.blockState);
            }
        }
        for (IProperty<?> iProperty : this.ignoredProperties) {
            newBlockState = BlockUtil.copyProperty(iProperty, (IBlockState)newBlockState, (IBlockState)this.placeBlock.func_176223_P());
        }
        world.field_72984_F.func_76319_b();
        world.field_72984_F.func_76320_a("place block");
        boolean b = world.func_180501_a(blockPos, newBlockState, 11);
        world.field_72984_F.func_76319_b();
        if (b) {
            world.field_72984_F.func_76320_a("notify");
            this.updateBlockOffsets.stream().map(arg_0 -> ((BlockPos)blockPos).func_177971_a(arg_0)).forEach(updatePos -> world.func_175685_c(updatePos, this.placeBlock, false));
            world.field_72984_F.func_76319_b();
            if (this.tileNbt != null && this.blockState.func_177230_c().hasTileEntity(this.blockState)) {
                world.field_72984_F.func_76320_a("prepare tile");
                Set<JsonRule> set = RulesLoader.getRules(this.blockState, this.tileNbt);
                NBTTagCompound replaceNbt = set.stream().map(rule -> rule.replaceNbt).filter(Objects::nonNull).map(NBTBase.class::cast).reduce(NBTUtilBC::merge).map(NBTTagCompound.class::cast).orElse(null);
                NBTTagCompound newTileNbt = new NBTTagCompound();
                this.tileNbt.func_150296_c().stream().map(key -> Pair.of((Object)key, (Object)this.tileNbt.func_74781_a(key))).forEach(kv -> newTileNbt.func_74782_a((String)kv.getKey(), (NBTBase)kv.getValue()));
                newTileNbt.func_74768_a("x", blockPos.func_177958_n());
                newTileNbt.func_74768_a("y", blockPos.func_177956_o());
                newTileNbt.func_74768_a("z", blockPos.func_177952_p());
                world.field_72984_F.func_76319_b();
                world.field_72984_F.func_76320_a("place tile");
                TileEntity tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)(replaceNbt != null ? (NBTTagCompound)NBTUtilBC.merge((NBTBase)newTileNbt, (NBTBase)replaceNbt) : newTileNbt));
                if (tileEntity != null) {
                    tileEntity.func_145834_a(world);
                    world.func_175690_a(blockPos, tileEntity);
                    if (this.tileRotation != Rotation.NONE) {
                        tileEntity.func_189667_a(this.tileRotation);
                    }
                }
                world.field_72984_F.func_76319_b();
            }
            return true;
        }
        return false;
    }

    public boolean buildWithoutChecks(World world, BlockPos blockPos) {
        if (world.func_180501_a(blockPos, this.blockState, 0) && this.tileNbt != null && this.blockState.func_177230_c().hasTileEntity(this.blockState)) {
            NBTTagCompound newTileNbt = new NBTTagCompound();
            this.tileNbt.func_150296_c().stream().map(key -> Pair.of((Object)key, (Object)this.tileNbt.func_74781_a(key))).forEach(kv -> newTileNbt.func_74782_a((String)kv.getKey(), (NBTBase)kv.getValue()));
            newTileNbt.func_74768_a("x", blockPos.func_177958_n());
            newTileNbt.func_74768_a("y", blockPos.func_177956_o());
            newTileNbt.func_74768_a("z", blockPos.func_177952_p());
            TileEntity tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)newTileNbt);
            if (tileEntity != null) {
                tileEntity.func_145834_a(world);
                world.func_175690_a(blockPos, tileEntity);
                if (this.tileRotation != Rotation.NONE) {
                    tileEntity.func_189667_a(this.tileRotation);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isBuilt(World world, BlockPos blockPos) {
        return this.blockState != null && this.canBeReplacedWithBlocks.contains(world.func_180495_p(blockPos).func_177230_c()) && BlockUtil.blockStatesWithoutBlockEqual((IBlockState)this.blockState, (IBlockState)world.func_180495_p(blockPos), this.ignoredProperties);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("requiredBlockOffsets", (NBTBase)NBTUtilBC.writeCompoundList(this.requiredBlockOffsets.stream().map(NBTUtil::func_186859_a)));
        nbt.func_74782_a("blockState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.blockState));
        nbt.func_74782_a("ignoredProperties", (NBTBase)NBTUtilBC.writeStringList(this.ignoredProperties.stream().map(IProperty::func_177701_a)));
        if (this.tileNbt != null) {
            nbt.func_74782_a("tileNbt", (NBTBase)this.tileNbt);
        }
        nbt.func_74782_a("tileRotation", NBTUtilBC.writeEnum((Enum)this.tileRotation));
        nbt.func_74778_a("placeBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.placeBlock)).toString());
        nbt.func_74782_a("updateBlockOffsets", (NBTBase)NBTUtilBC.writeCompoundList(this.updateBlockOffsets.stream().map(NBTUtil::func_186859_a)));
        nbt.func_74782_a("canBeReplacedWithBlocks", (NBTBase)NBTUtilBC.writeStringList(this.canBeReplacedWithBlocks.stream().map(arg_0 -> ((RegistryNamespacedDefaultedByKey)Block.field_149771_c).func_177774_c(arg_0)).map(Object::toString)));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        NBTUtilBC.readCompoundList((NBTBase)nbt.func_74781_a("requiredBlockOffsets")).map(NBTUtil::func_186861_c).forEach(this.requiredBlockOffsets::add);
        this.blockState = NBTUtil.func_190008_d((NBTTagCompound)nbt.func_74775_l("blockState"));
        NBTUtilBC.readStringList((NBTBase)nbt.func_74781_a("ignoredProperties")).map(propertyName -> this.blockState.func_177227_a().stream().filter(property -> property.func_177701_a().equals(propertyName)).findFirst().orElse(null)).forEach(this.ignoredProperties::add);
        if (nbt.func_74764_b("tileNbt")) {
            this.tileNbt = nbt.func_74775_l("tileNbt");
        }
        this.tileRotation = (Rotation)NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("tileRotation"), Rotation.class);
        this.placeBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("placeBlock")));
        NBTUtilBC.readCompoundList((NBTBase)nbt.func_74781_a("updateBlockOffsets")).map(NBTUtil::func_186861_c).forEach(this.updateBlockOffsets::add);
        NBTUtilBC.readStringList((NBTBase)nbt.func_74781_a("canBeReplacedWithBlocks")).map(ResourceLocation::new).map(arg_0 -> ((RegistryNamespacedDefaultedByKey)Block.field_149771_c).func_82594_a(arg_0)).forEach(this.canBeReplacedWithBlocks::add);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchematicBlockDefault that = (SchematicBlockDefault)o;
        return this.requiredBlockOffsets.equals(that.requiredBlockOffsets) && this.blockState.equals(that.blockState) && this.ignoredProperties.equals(that.ignoredProperties) && (this.tileNbt != null ? this.tileNbt.equals((Object)that.tileNbt) : that.tileNbt == null) && this.tileRotation == that.tileRotation && this.placeBlock.equals(that.placeBlock) && this.updateBlockOffsets.equals(that.updateBlockOffsets) && this.canBeReplacedWithBlocks.equals(that.canBeReplacedWithBlocks);
    }

    public int hashCode() {
        int result = this.requiredBlockOffsets.hashCode();
        result = 31 * result + this.blockState.hashCode();
        result = 31 * result + this.ignoredProperties.hashCode();
        result = 31 * result + (this.tileNbt != null ? this.tileNbt.hashCode() : 0);
        result = 31 * result + this.tileRotation.hashCode();
        result = 31 * result + this.placeBlock.hashCode();
        result = 31 * result + this.updateBlockOffsets.hashCode();
        result = 31 * result + this.canBeReplacedWithBlocks.hashCode();
        return result;
    }
}

