/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern.parameter;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum PatternParameterCenter implements IStatementParameter
{
    NORTH_WEST(-1, -1),
    NORTH(0, -1),
    NORTH_EAST(1, -1),
    WEST(-1, 0),
    CENTER(0, 0),
    EAST(1, 0),
    SOUTH_WEST(-1, 1),
    SOUTH(0, 1),
    SOUTH_EAST(1, 1);

    public static final PatternParameterCenter[] POSSIBLE_ORDER;
    public final int offsetX;
    public final int offsetZ;

    private PatternParameterCenter(int x, int z) {
        this.offsetX = x;
        this.offsetZ = z;
    }

    public static PatternParameterCenter readFromNbt(NBTTagCompound nbt) {
        byte ord = nbt.func_74771_c("dir");
        if (ord < 0 || ord >= PatternParameterCenter.values().length) {
            return CENTER;
        }
        return PatternParameterCenter.values()[ord];
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74774_a("dir", (byte)this.ordinal());
    }

    public String getUniqueTag() {
        return "buildcraft:fillerParameterCenter";
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        return (ISprite)BCBuildersSprites.PARAM_CENTER.get((Object)this);
    }

    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    public String getDescription() {
        return LocaleUtil.localize((String)("direction.center." + this.ordinal()));
    }

    public PatternParameterCenter onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    public IStatementParameter rotateLeft() {
        return this;
    }

    public IStatementParameter[] getPossible(IStatementContainer source) {
        return POSSIBLE_ORDER;
    }

    public boolean isPossibleOrdered() {
        return true;
    }

    static {
        POSSIBLE_ORDER = new PatternParameterCenter[]{CENTER, NORTH_WEST, NORTH, NORTH_EAST, EAST, SOUTH_EAST, SOUTH, SOUTH_WEST, WEST};
    }
}

