/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.builders.BCBuildersItems;
import buildcraft.builders.item.ItemSnapshot;
import buildcraft.builders.snapshot.GlobalSavedDataSnapshots;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.delta.DeltaInt;
import buildcraft.lib.delta.DeltaManager;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.nbt.NbtSquisher;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.lib.tile.item.StackInsertionFunction;
import com.google.common.primitives.Bytes;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class TileElectronicLibrary
extends TileBC_Neptune
implements ITickable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("library");
    public static final int NET_DOWN = IDS.allocId("DOWN");
    public static final int NET_UP = IDS.allocId("UP");
    public final ItemHandlerSimple invDownIn;
    public final ItemHandlerSimple invDownOut;
    public final ItemHandlerSimple invUpIn;
    public final ItemHandlerSimple invUpOut;
    public Snapshot.Key selected;
    private int progressDown;
    private int progressUp;
    public final DeltaInt deltaProgressDown;
    public final DeltaInt deltaProgressUp;
    private final Map<Pair<UUID, Snapshot.Key>, List<byte[]>> upSnapshotsParts;

    public TileElectronicLibrary() {
        this.invDownIn = this.itemManager.addInvHandler("downIn", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemSnapshot && ItemSnapshot.EnumItemSnapshotType.getFromStack((ItemStack)stack).used, StackInsertionFunction.getInsertionFunction((int)1), ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.invDownOut = this.itemManager.addInvHandler("downOut", 1, StackInsertionFunction.getInsertionFunction((int)1), ItemHandlerManager.EnumAccess.EXTRACT, EnumPipePart.VALUES);
        this.invUpIn = this.itemManager.addInvHandler("upIn", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemSnapshot, StackInsertionFunction.getInsertionFunction((int)1), ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.invUpOut = this.itemManager.addInvHandler("upOut", 1, StackInsertionFunction.getInsertionFunction((int)1), ItemHandlerManager.EnumAccess.EXTRACT, EnumPipePart.VALUES);
        this.selected = null;
        this.progressDown = -1;
        this.progressUp = -1;
        this.deltaProgressDown = this.deltaManager.addDelta("progressDown", DeltaManager.EnumNetworkVisibility.GUI_ONLY);
        this.deltaProgressUp = this.deltaManager.addDelta("progressUp", DeltaManager.EnumNetworkVisibility.GUI_ONLY);
        this.upSnapshotsParts = new HashMap<Pair<UUID, Snapshot.Key>, List<byte[]>>();
    }

    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        super.onSlotChange(handler, slot, before, after);
        if (handler == this.invDownIn && this.progressDown > 0) {
            this.progressDown = -1;
            this.deltaProgressDown.setValue(0);
        }
        if (handler == this.invUpIn && this.progressUp > 0) {
            this.progressUp = -1;
            this.deltaProgressUp.setValue(0);
        }
    }

    public void func_73660_a() {
        this.deltaManager.tick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.invDownIn.getStackInSlot(0).func_190926_b() && this.invDownOut.getStackInSlot(0).func_190926_b()) {
            if (this.progressDown == -1) {
                this.progressDown = 0;
                this.deltaProgressDown.addDelta(0L, 50L, 1);
                this.deltaProgressDown.addDelta(50L, 55L, -1);
            }
            if (this.progressDown >= 50) {
                this.sendNetworkGuiUpdate(NET_DOWN);
                this.invDownOut.setStackInSlot(0, this.invDownIn.getStackInSlot(0));
                this.invDownIn.setStackInSlot(0, StackUtil.EMPTY);
                this.progressDown = -1;
            } else {
                ++this.progressDown;
            }
        } else if (this.progressDown != -1) {
            this.progressDown = -1;
            this.deltaProgressDown.setValue(0);
        }
        if (this.selected != null && !this.invUpIn.getStackInSlot(0).func_190926_b() && this.invUpOut.getStackInSlot(0).func_190926_b()) {
            if (this.progressUp == -1) {
                this.progressUp = 0;
                this.deltaProgressUp.addDelta(0L, 50L, 1);
                this.deltaProgressUp.addDelta(50L, 55L, -1);
            }
            if (this.progressUp >= 50) {
                this.sendNetworkGuiUpdate(NET_UP);
                this.progressUp = -1;
            } else {
                ++this.progressUp;
            }
        } else if (this.progressUp != -1) {
            this.progressUp = -1;
            this.deltaProgressUp.setValue(0);
        }
    }

    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                buffer.writeBoolean(this.selected != null);
                if (this.selected != null) {
                    this.selected.writeToByteBuf(buffer);
                }
            }
            if (id == NET_DOWN) {
                Snapshot.Header header = BCBuildersItems.snapshot.getHeader(this.invDownIn.getStackInSlot(0));
                if (header != null) {
                    Snapshot snapshot = GlobalSavedDataSnapshots.get(this.field_145850_b).getSnapshot(header.key);
                    if (snapshot != null) {
                        snapshot = snapshot.copy();
                        snapshot.key = new Snapshot.Key(snapshot.key, header);
                        buffer.writeBoolean(true);
                        NbtSquisher.squish((NBTTagCompound)Snapshot.writeToNBT(snapshot), (int)3, (ByteBuf)buffer);
                    } else {
                        buffer.writeBoolean(false);
                    }
                } else {
                    buffer.writeBoolean(false);
                }
            }
            if (id == NET_UP) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPayload(int id, PacketBufferBC buffer, Side side, final MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            Snapshot snapshot;
            if (id == NET_RENDER_DATA) {
                this.selected = buffer.readBoolean() ? new Snapshot.Key(buffer) : null;
            }
            if (id == NET_DOWN && buffer.readBoolean()) {
                snapshot = Snapshot.readFromNBT(NbtSquisher.expand((ByteBuf)buffer));
                snapshot.computeKey();
                GlobalSavedDataSnapshots.get(this.field_145850_b).addSnapshot(snapshot);
            }
            if (id == NET_UP && this.selected != null && (snapshot = GlobalSavedDataSnapshots.get(this.field_145850_b).getSnapshot(this.selected)) != null) {
                try (OutputStream outputStream = new OutputStream(){
                    private byte[] buf = new byte[4096];
                    private int pos = 0;
                    private boolean closed = false;

                    private void write(boolean last) throws IOException {
                        MessageManager.sendToServer((IMessage)TileElectronicLibrary.this.createMessage(NET_UP, localBuffer -> {
                            localBuffer.func_179252_a(ctx.getClientHandler().func_175105_e().getId());
                            TileElectronicLibrary.this.selected.writeToByteBuf(localBuffer);
                            localBuffer.writeBoolean(last);
                            localBuffer.func_179250_a(this.buf);
                        }));
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.buf[this.pos++] = (byte)b;
                        if (this.pos >= this.buf.length) {
                            this.write(false);
                            this.buf = new byte[this.buf.length];
                            this.pos = 0;
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.closed = true;
                        this.buf = Arrays.copyOf(this.buf, this.pos);
                        this.pos = 0;
                        this.write(true);
                    }
                };){
                    NbtSquisher.squish((NBTTagCompound)Snapshot.writeToNBT(snapshot), (int)3, (OutputStream)outputStream);
                }
            }
        }
        if (side == Side.SERVER && id == NET_UP) {
            UUID playerId = buffer.func_179253_g();
            Snapshot.Key key = new Snapshot.Key(buffer);
            Pair pair = Pair.of((Object)playerId, (Object)key);
            boolean last = buffer.readBoolean();
            this.upSnapshotsParts.computeIfAbsent((Pair<UUID, Snapshot.Key>)pair, localPair -> new ArrayList()).add(buffer.func_179251_a());
            if (last && this.upSnapshotsParts.containsKey(pair)) {
                try {
                    Snapshot snapshot = Snapshot.readFromNBT(NbtSquisher.expand((byte[])Bytes.concat((byte[][])((byte[][])this.upSnapshotsParts.get(pair).toArray((T[])new byte[0][])))));
                    Snapshot.Header header = snapshot.key.header;
                    snapshot = snapshot.copy();
                    snapshot.key = new Snapshot.Key(snapshot.key, (Snapshot.Header)null);
                    snapshot.computeKey();
                    GlobalSavedDataSnapshots.get(this.field_145850_b).addSnapshot(snapshot);
                    this.invUpOut.setStackInSlot(0, BCBuildersItems.snapshot.getUsed(snapshot.getType(), header));
                    this.invUpIn.setStackInSlot(0, StackUtil.EMPTY);
                }
                finally {
                    this.upSnapshotsParts.remove(pair);
                }
            }
        }
    }
}

