/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.master;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.capability.IConnectable;
import mrriegel.storagenetwork.api.capability.IConnectableItemAutoIO;
import mrriegel.storagenetwork.api.capability.IConnectableLink;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.api.data.EnumStorageDirection;
import mrriegel.storagenetwork.api.data.IItemStackMatcher;
import mrriegel.storagenetwork.api.network.INetworkMaster;
import mrriegel.storagenetwork.block.cable.processing.ProcessRequestModel;
import mrriegel.storagenetwork.block.cable.processing.TileCableProcess;
import mrriegel.storagenetwork.block.control.ProcessWrapper;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.util.UtilInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMaster
extends TileEntity
implements ITickable,
INetworkMaster {
    private Set<DimPos> connectables;
    private Map<String, DimPos> importCache = new HashMap<String, DimPos>();
    public static String[] blacklist;
    private boolean shouldRefresh = true;

    public DimPos getDimPos() {
        return new DimPos(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public List<ItemStack> getStacks() {
        ArrayList stacks = Lists.newArrayList();
        if (this.getConnectablePositions() == null) {
            this.refreshNetwork();
        }
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            for (ItemStack stack : storage.getStoredStacks()) {
                if (stack.func_190926_b()) continue;
                this.addOrMergeIntoList(stacks, stack.func_77946_l());
            }
        }
        return stacks;
    }

    private void addOrMergeIntoList(List<ItemStack> list, ItemStack stackToAdd) {
        boolean added = false;
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackToAdd, (ItemStack)stack)) continue;
            stack.func_190920_e(stack.func_190916_E() + stackToAdd.func_190916_E());
            added = true;
            break;
        }
        if (!added) {
            list.add(stackToAdd);
        }
    }

    public int emptySlots() {
        int countEmpty = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            countEmpty += storage.getEmptySlots();
        }
        return countEmpty;
    }

    public int getAmount(ItemStackMatcher fil) {
        if (fil == null) {
            return 0;
        }
        int totalCount = 0;
        for (ItemStack stack : this.getStacks()) {
            if (!fil.match(stack)) continue;
            totalCount += stack.func_190916_E();
        }
        return totalCount;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private Set<DimPos> getConnectables(DimPos sourcePos) {
        HashSet<DimPos> result = new HashSet<DimPos>();
        this.addConnectables(sourcePos, result);
        return result;
    }

    private void addConnectables(DimPos sourcePos, Set<DimPos> set) {
        if (sourcePos == null || sourcePos.getWorld() == null || !sourcePos.isLoaded()) {
            return;
        }
        for (EnumFacing direction : EnumFacing.values()) {
            boolean isConnectable;
            Chunk chunk;
            DimPos lookPos = sourcePos.offset(direction);
            if (!lookPos.isLoaded() || (chunk = lookPos.getChunk()) == null || !chunk.func_177410_o()) continue;
            TileMaster maybeMasterTile = lookPos.getTileEntity(TileMaster.class);
            if (maybeMasterTile != null && !lookPos.equals(this.field_145850_b, this.field_174879_c)) {
                this.nukeAndDrop(lookPos);
                continue;
            }
            TileEntity tileHere = lookPos.getTileEntity(TileEntity.class);
            if (tileHere == null || !(isConnectable = tileHere.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, direction.func_176734_d()))) continue;
            IConnectable capabilityConnectable = (IConnectable)tileHere.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, direction.func_176734_d());
            capabilityConnectable.setMasterPos(this.getDimPos());
            DimPos realConnectablePos = capabilityConnectable.getPos();
            boolean beenHereBefore = set.contains(realConnectablePos);
            if (beenHereBefore) continue;
            set.add(realConnectablePos);
            this.addConnectables(realConnectablePos, set);
            tileHere.func_70296_d();
            chunk.func_177427_f(true);
        }
    }

    private void nukeAndDrop(DimPos lookPos) {
        lookPos.getBlockState().func_177230_c().func_176226_b(lookPos.getWorld(), lookPos.getBlockPos(), lookPos.getBlockState(), 0);
        lookPos.getWorld().func_175698_g(lookPos.getBlockPos());
        lookPos.getWorld().func_175713_t(lookPos.getBlockPos());
    }

    public static boolean isTargetAllowed(IBlockState iBlockState) {
        String blockId = iBlockState.func_177230_c().getRegistryName().toString();
        for (String s : blacklist) {
            if (!blockId.equals(s)) continue;
            StorageNetwork.info(iBlockState + " Connection blocked by config ");
            return false;
        }
        return true;
    }

    public void refreshNetwork() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.shouldRefresh = true;
    }

    private boolean hasCachedSlot(ItemStack stack) {
        return this.importCache.containsKey(this.getStackKey(stack));
    }

    private DimPos getCachedSlot(ItemStack stack) {
        return this.importCache.get(this.getStackKey(stack));
    }

    @Override
    public int insertStack(ItemStack rawStack, boolean simulate) {
        if (rawStack.func_190926_b()) {
            return 0;
        }
        ItemStack stack = rawStack.func_77946_l();
        String key = this.getStackKey(stack);
        if (this.hasCachedSlot(stack)) {
            DimPos cachedStoragePos = this.getCachedSlot(stack);
            IConnectableLink storage = cachedStoragePos.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null);
            if (storage == null) {
                this.importCache.remove(key);
            } else {
                boolean canStillImport = storage.getSupportedTransferDirection().match(EnumStorageDirection.IN);
                if (canStillImport && storage.insertStack(stack, true).func_190916_E() < stack.func_190916_E()) {
                    stack = storage.insertStack(stack, simulate);
                } else {
                    this.importCache.remove(key);
                }
            }
        }
        if (stack.func_190926_b()) {
            return 0;
        }
        List<IConnectableLink> storages = this.getSortedConnectableStorage();
        for (IConnectableLink storage : storages) {
            if (!storage.getSupportedTransferDirection().match(EnumStorageDirection.IN) || storage.insertStack(stack, true).func_190916_E() >= stack.func_190916_E()) continue;
            stack = storage.insertStack(stack, simulate);
        }
        return stack.func_190916_E();
    }

    private String getStackKey(ItemStack stackInCopy) {
        return stackInCopy.func_77973_b().getRegistryName().toString() + "/" + stackInCopy.func_77952_i();
    }

    private void updateImports() {
        for (IConnectableItemAutoIO storage : this.getConnectablesIO()) {
            ItemStack stack;
            if (storage == null || storage.ioDirection() != EnumStorageDirection.IN || !storage.runNow(storage.getPos(), this) || (stack = storage.extractNextStack(storage.getTransferRate(), true)).func_190926_b()) continue;
            int countUnmoved = this.insertStack(stack.func_77946_l(), true);
            int countMoved = stack.func_190916_E() - countUnmoved;
            if (countMoved <= 0) continue;
            ItemStack actuallyExtracted = storage.extractNextStack(countMoved, false);
            storage.getPos().getChunk().func_76630_e();
            this.insertStack(actuallyExtracted.func_77946_l(), false);
        }
    }

    private void updateProcess() {
        for (IConnectable connectable : this.getConnectables()) {
            TileCableProcess cableProcess = connectable.getPos().getTileEntity(TileCableProcess.class);
            if (cableProcess == null) continue;
            cableProcess.run();
        }
    }

    private void updateExports() {
        block2: for (IConnectableItemAutoIO storage : this.getConnectablesIO()) {
            if (storage == null || storage.ioDirection() != EnumStorageDirection.OUT || !storage.runNow(storage.getPos(), this)) continue;
            for (IItemStackMatcher matcher : storage.getAutoExportList()) {
                ItemStack realExtractedStack;
                ItemStack requestedStack;
                boolean stockMode = storage.isStockMode();
                int amtToRequest = storage.getTransferRate();
                if (stockMode) {
                    try {
                        TileEntity tileEntity = this.field_145850_b.func_175625_s(storage.getPos().getBlockPos().func_177972_a(storage.facingInventory()));
                        IItemHandler targetInventory = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                        int stillNeeds = UtilInventory.containsAtLeastHowManyNeeded(targetInventory, matcher.getStack(), matcher.getStack().func_190916_E());
                        if (stillNeeds == 0) continue;
                        amtToRequest = Math.min(stillNeeds, amtToRequest);
                    }
                    catch (Throwable e) {
                        StorageNetwork.log("error thrown " + e.getMessage());
                    }
                }
                if ((requestedStack = this.request(matcher, amtToRequest, true)).func_190926_b()) continue;
                ItemStack insertedSim = storage.insertStack(requestedStack.func_77946_l(), true);
                ItemStack targetStack = requestedStack.func_77946_l();
                if (!insertedSim.func_190926_b()) {
                    int movedItems = requestedStack.func_190916_E() - insertedSim.func_190916_E();
                    if (movedItems <= 0) continue;
                    targetStack.func_190920_e(movedItems);
                }
                if ((realExtractedStack = this.request(new ItemStackMatcher(requestedStack, true, false, true), targetStack.func_190916_E(), false)).func_190926_b()) continue;
                storage.insertStack(realExtractedStack.func_77946_l(), false);
                continue block2;
            }
        }
    }

    @Override
    public ItemStack request(IItemStackMatcher matcher, int size, boolean simulate) {
        if (size == 0 || matcher == null) {
            return ItemStack.field_190927_a;
        }
        IItemStackMatcher usedMatcher = matcher;
        int alreadyTransferred = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            int req;
            ItemStack simExtract = storage.extractStack(usedMatcher, req = size - alreadyTransferred, simulate);
            if (simExtract.func_190926_b()) continue;
            usedMatcher = new ItemStackMatcher(simExtract, true, false, true);
            if ((alreadyTransferred += simExtract.func_190916_E()) < size) continue;
            break;
        }
        if (alreadyTransferred <= 0) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)usedMatcher.getStack(), (int)alreadyTransferred);
    }

    private Set<IConnectable> getConnectables() {
        Set<DimPos> positions = this.getConnectablePositions();
        if (positions == null) {
            return new HashSet<IConnectable>();
        }
        HashSet<IConnectable> result = new HashSet<IConnectable>();
        for (DimPos pos : positions) {
            TileEntity tileEntity;
            if (!pos.isLoaded() || (tileEntity = pos.getTileEntity(TileEntity.class)) == null || !tileEntity.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)) continue;
            result.add((IConnectable)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null));
        }
        return result;
    }

    private List<IConnectableItemAutoIO> getConnectablesIO() {
        Set<DimPos> positions = this.getConnectablePositions();
        if (positions == null) {
            return new ArrayList<IConnectableItemAutoIO>();
        }
        HashSet<Object> result = new HashSet<Object>();
        for (DimPos pos : positions) {
            TileEntity tileEntity;
            if (!pos.isLoaded() || (tileEntity = pos.getTileEntity(TileEntity.class)) == null || !tileEntity.hasCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null)) continue;
            result.add(tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null));
        }
        return result.stream().sorted(Comparator.comparingInt(IConnectableItemAutoIO::getPriority)).collect(Collectors.toList());
    }

    private List<IConnectableLink> getSortedConnectableStorage() {
        return this.getConnectableStorage().stream().sorted(Comparator.comparingInt(IConnectableLink::getPriority)).collect(Collectors.toList());
    }

    private Set<IConnectableLink> getConnectableStorage() {
        HashSet<IConnectableLink> result = new HashSet<IConnectableLink>();
        for (DimPos dimpos : this.getConnectablePositions()) {
            TileEntity tileEntity;
            if (!dimpos.isLoaded() || (tileEntity = dimpos.getTileEntity(TileEntity.class)) == null || !tileEntity.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null) || !tileEntity.hasCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null)) continue;
            result.add((IConnectableLink)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null));
        }
        return result;
    }

    public List<ProcessWrapper> getProcessors() {
        ArrayList<ProcessWrapper> result = new ArrayList<ProcessWrapper>();
        for (DimPos pos : this.getConnectablePositions()) {
            TileCableProcess cableProcess;
            if (!pos.isLoaded() || (cableProcess = pos.getTileEntity(TileCableProcess.class)) == null) continue;
            DimPos inventoryPos = pos.offset(cableProcess.getDirection());
            if (inventoryPos == null) {
                StorageNetwork.log("Error: processor null at  " + pos + "," + cableProcess.getDirection());
                continue;
            }
            IBlockState blockState = inventoryPos.getBlockState();
            String name = blockState.func_177230_c().func_149732_F();
            try {
                ItemStack pickBlock = blockState.func_177230_c().getPickBlock(blockState, null, inventoryPos.getWorld(), inventoryPos.getBlockPos(), null);
                if (!pickBlock.func_190926_b()) {
                    name = pickBlock.func_82833_r();
                }
            }
            catch (Exception e) {
                StorageNetwork.instance.logger.error("Error with display name ", (Throwable)e);
            }
            ProcessRequestModel proc = cableProcess.getProcessModel();
            ProcessWrapper processor = new ProcessWrapper(new DimPos(cableProcess.func_145831_w(), cableProcess.func_174877_v()), cableProcess.getFirstRecipeOut(), proc.getCount(), name, proc.isAlwaysActive());
            processor.ingredients = cableProcess.getProcessIngredients();
            processor.blockId = blockState.func_177230_c().getRegistryName();
            result.add(processor);
        }
        return result;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getConnectablePositions() == null || this.field_145850_b.func_82737_E() % ConfigHandler.refreshTicks == 0L || this.shouldRefresh) {
            try {
                this.connectables = this.getConnectables(this.getDimPos());
                this.shouldRefresh = false;
                this.field_145850_b.func_175726_f(this.field_174879_c).func_177427_f(true);
            }
            catch (Throwable e) {
                StorageNetwork.instance.logger.error("Refresh network error ", e);
            }
        }
        this.updateImports();
        this.updateExports();
        this.updateProcess();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.func_189515_b(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public Set<DimPos> getConnectablePositions() {
        if (this.connectables == null) {
            this.connectables = new HashSet<DimPos>();
        }
        return new HashSet<DimPos>(this.connectables);
    }

    @Override
    public void clearCache() {
        this.importCache = new HashMap<String, DimPos>();
    }
}

