/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.gui.IStorageContainer;
import mrriegel.storagenetwork.network.ClearRecipeMessage;
import mrriegel.storagenetwork.network.StackRefreshClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.UtilInventory;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeMessage
implements IMessage,
IMessageHandler<RecipeMessage, IMessage> {
    private NBTTagCompound nbt;
    private int index = 0;

    public RecipeMessage() {
    }

    public RecipeMessage(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.index = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        buf.writeInt(this.index);
    }

    public IMessage onMessage(final RecipeMessage message, MessageContext ctx) {
        final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer mainThread = (WorldServer)player.field_70170_p;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (!(player.field_71070_bA instanceof IStorageContainer)) {
                    return;
                }
                IStorageContainer ctr = (IStorageContainer)player.field_71070_bA;
                TileMaster master = ctr.getTileMaster();
                if (master == null) {
                    return;
                }
                ClearRecipeMessage.clearContainerRecipe(player, false);
                InventoryCrafting craftMatrix = ctr.getCraftMatrix();
                block0: for (int slot = 0; slot < 9; ++slot) {
                    int i;
                    boolean isOreDict;
                    HashMap<Integer, Object> map = new HashMap<Integer, Object>();
                    if (message.nbt.func_150297_b("s" + slot, 8)) {
                        isOreDict = true;
                        String[] oreDictKeys = message.nbt.func_74779_i("s" + slot).split(",");
                        ArrayList l = new ArrayList();
                        for (String oreKey : oreDictKeys) {
                            l.addAll(OreDictionary.getOres((String)oreKey));
                        }
                        for (i = 0; i < l.size(); ++i) {
                            map.put(i, l.get(i));
                        }
                    } else {
                        isOreDict = false;
                        NBTTagList invList = message.nbt.func_150295_c("s" + slot, 10);
                        for (i = 0; i < invList.func_74745_c(); ++i) {
                            NBTTagCompound stackTag = invList.func_150305_b(i);
                            ItemStack s = new ItemStack(stackTag);
                            map.put(i, s);
                        }
                    }
                    for (int i2 = 0; i2 < map.size(); ++i2) {
                        ItemStack ex;
                        ItemStack stackCurrent = (ItemStack)map.get(i2);
                        if (stackCurrent == null || stackCurrent.func_190926_b()) continue;
                        ItemStackMatcher itemStackMatcher = new ItemStackMatcher(stackCurrent);
                        itemStackMatcher.setNbt(true);
                        itemStackMatcher.setOre(isOreDict);
                        if (stackCurrent.func_77958_k() > 0) {
                            itemStackMatcher.setMeta(false);
                        }
                        if ((ex = UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), itemStackMatcher, 1, true)) != null && !ex.func_190926_b() && craftMatrix.func_70301_a(slot).func_190926_b()) {
                            UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), itemStackMatcher, 1, false);
                            craftMatrix.func_70299_a(slot, ex);
                            continue block0;
                        }
                        if ((stackCurrent = master.request(!stackCurrent.func_190926_b() ? itemStackMatcher : null, 1, false)).func_190926_b() || !craftMatrix.func_70301_a(slot).func_190926_b()) continue;
                        craftMatrix.func_70299_a(slot, stackCurrent);
                        continue block0;
                    }
                }
                ctr.slotChanged();
                List<ItemStack> list = master.getStacks();
                PacketRegistry.INSTANCE.sendTo((IMessage)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player);
            }
        });
        return null;
    }
}

