/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.algebra;

import ivorius.ivtoolkit.util.IvLists;
import ivorius.reccomplex.utils.algebra.Algebra;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class FunctionExpressionCache<T, A, U>
extends ExpressionCache<T> {
    protected final SortedSet<VariableType<T, ? super A, ? super U>> types = new TreeSet<VariableType<T, ? super A, ? super U>>();

    public FunctionExpressionCache(Algebra<T> algebra) {
        super(algebra);
    }

    public FunctionExpressionCache(Algebra<T> algebra, T emptyResult, String emptyResultRepresentation) {
        super(algebra, emptyResult, emptyResultRepresentation);
    }

    public void addType(VariableType<T, ? super A, ? super U> type) {
        this.types.add(type);
    }

    public void addTypes(Collection<VariableType<T, ? super A, ? super U>> types) {
        this.types.addAll(types);
    }

    @SafeVarargs
    public final void addTypes(VariableType<T, ? super A, ? super U> type, Function<VariableType<T, ? super A, ? super U>, VariableType<T, ? super A, ? super U>> ... functions) {
        this.addType(type);
        this.addTypes(IvLists.enumerate(type, functions));
    }

    public void removeType(VariableType<T, A, U> type) {
        this.types.remove(type);
    }

    public Set<VariableType<T, ? super A, ? super U>> types() {
        return Collections.unmodifiableSet(this.types);
    }

    @Nullable
    public VariableType<T, ? super A, ? super U> type(String var) {
        return this.types.stream().filter(input -> var.startsWith(input.prefix) && var.endsWith(input.suffix)).findFirst().orElseGet(() -> null);
    }

    public Validity variableValidity(String var, U u) {
        VariableType<T, A, U> type = this.type(var);
        return type == null ? Validity.ERROR : type.validity(var.substring(type.prefix.length()), u);
    }

    public Validity validity(U u) {
        Validity[] worst = new Validity[]{Validity.KNOWN};
        if (this.parsedExpression != null) {
            this.parsedExpression.walkVariables(s -> {
                Validity validity = this.variableValidity(s.identifier, u);
                if (validity.ordinal() > worst[0].ordinal()) {
                    worst[0] = validity;
                }
                return validity.ordinal() < Validity.values().length - 1;
            });
            return worst[0];
        }
        return Validity.ERROR;
    }

    @Override
    protected Algebra.VariableParser<Function<? extends SupplierCache<? super A>, T>> variableParser() {
        return var -> {
            VariableType<T, A, U> type = this.type(var);
            if (type != null) {
                return type.parse(var.substring(type.prefix.length()));
            }
            throw new ParseException(String.format("Type of '%s' unknown", var), 0);
        };
    }

    public T evaluate(SupplierCache<A> a) {
        Algebra.Expression expression = this.parsedExpression;
        return (T)(this.parsedExpression != null ? expression.evaluate((V fun) -> fun.apply(a)) : this.emptyExpressionResult);
    }

    public T evaluate(Supplier<A> a) {
        return this.evaluate((A)SupplierCache.of(a));
    }

    public T evaluate(A a) {
        return this.evaluate((A)SupplierCache.direct(a));
    }

    @Nonnull
    public String getDisplayString(U u) {
        return this.parsedExpression != null ? this.parsedExpression.toString(input -> this.variableDisplayString((String)input, u)) : TextFormatting.RED + this.expression;
    }

    public String variableDisplayString(String variable, U u) {
        VariableType<T, A, U> type = this.type(variable);
        return type != null ? type.getRepresentation(variable.substring(type.prefix.length()), type.prefix, type.suffix, u) : TextFormatting.RED + variable;
    }

    public static abstract class VariableType<T, A, U>
    implements Comparable<VariableType> {
        protected String prefix;
        protected String suffix;

        public VariableType(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public abstract Function<SupplierCache<A>, T> parse(String var1) throws ParseException;

        public abstract Validity validity(String var1, U var2);

        public TextFormatting getRepresentation(Validity validity) {
            return validity == Validity.KNOWN ? TextFormatting.GREEN : (validity == Validity.UNKNOWN ? TextFormatting.YELLOW : TextFormatting.RED);
        }

        public String getRepresentation(String var, String prefix, String suffix, U u) {
            return TextFormatting.BLUE + prefix + TextFormatting.RESET + this.getVarRepresentation(var, u) + TextFormatting.RESET + TextFormatting.BLUE + suffix + TextFormatting.RESET;
        }

        protected String getVarRepresentation(String var, U u) {
            return this.getRepresentation(this.validity(var, u)) + var;
        }

        @Override
        public int compareTo(@Nonnull VariableType o) {
            return o.prefix.compareTo(this.prefix);
        }

        public AliasType<T, A, U, VariableType<T, A, U>> alias(String prefix, String suffix) {
            return new AliasType(prefix, suffix, this);
        }
    }

    public static class AliasType<T, A, U, V extends VariableType<T, A, U>>
    extends VariableType<T, A, U> {
        public V parent;

        public AliasType(String prefix, String suffix, V parent) {
            super(prefix, suffix);
            this.parent = parent;
        }

        @Override
        public Function<SupplierCache<A>, T> parse(String var) throws ParseException {
            return ((VariableType)this.parent).parse(var);
        }

        @Override
        public Validity validity(String var, U u) {
            return ((VariableType)this.parent).validity(var, u);
        }

        @Override
        public String getRepresentation(String var, String prefix, String suffix, U u) {
            return ((VariableType)this.parent).getRepresentation(var, prefix, suffix, u);
        }
    }

    public static enum Validity {
        KNOWN,
        UNKNOWN,
        ERROR;

    }
}

