/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block.BetterRedstone;

import betterwithaddons.block.BetterRedstone.BlockPCB;
import betterwithaddons.block.ColorHandlers;
import betterwithaddons.block.IColorable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWirePCB
extends Block
implements IColorable {
    public static final PropertyEnum<EnumAttachPosition> NORTH = PropertyEnum.func_177709_a((String)"north", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> EAST = PropertyEnum.func_177709_a((String)"east", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> SOUTH = PropertyEnum.func_177709_a((String)"south", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> WEST = PropertyEnum.func_177709_a((String)"west", EnumAttachPosition.class);
    protected static final AxisAlignedBB[] REDSTONE_WIRE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0)};
    private boolean canProvidePower = true;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public BlockWirePCB() {
        super(Material.field_151594_q);
        this.func_180632_j(this.func_176223_P().func_177226_a(NORTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(EAST, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(SOUTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(WEST, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a((IProperty)BlockRedstoneWire.field_176351_O, (Comparable)Integer.valueOf(0)));
        this.func_149663_c("pcb_wire");
        this.setRegistryName(new ResourceLocation("betterwithaddons", "pcb_wire"));
    }

    @Override
    public IBlockColor getBlockColor() {
        return ColorHandlers.REDSTONE_COLORING;
    }

    @Override
    public IItemColor getItemColor() {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return REDSTONE_WIRE_AABB[BlockWirePCB.getAABBIndex(state.func_185899_b(world, pos))];
    }

    private static int getAABBIndex(IBlockState state) {
        boolean flag3;
        int i = 0;
        boolean flag = state.func_177229_b(NORTH) != EnumAttachPosition.NONE;
        boolean flag1 = state.func_177229_b(EAST) != EnumAttachPosition.NONE;
        boolean flag2 = state.func_177229_b(SOUTH) != EnumAttachPosition.NONE;
        boolean bl = flag3 = state.func_177229_b(WEST) != EnumAttachPosition.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a(WEST, (Comparable)((Object)this.getAttachPosition(world, pos, EnumFacing.WEST)));
        state = state.func_177226_a(EAST, (Comparable)((Object)this.getAttachPosition(world, pos, EnumFacing.EAST)));
        state = state.func_177226_a(NORTH, (Comparable)((Object)this.getAttachPosition(world, pos, EnumFacing.NORTH)));
        state = state.func_177226_a(SOUTH, (Comparable)((Object)this.getAttachPosition(world, pos, EnumFacing.SOUTH)));
        return state;
    }

    private EnumAttachPosition getAttachPosition(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing);
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(facing));
        if (this.pcbAllowsConnection(world, pos, facing)) {
            return EnumAttachPosition.SIDE;
        }
        return EnumAttachPosition.NONE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.isOnPCB((IBlockAccess)world, pos);
    }

    private IBlockState updateSurroundingRedstone(World world, BlockPos pos, IBlockState state) {
        state = this.calculateCurrentChanges(world, pos, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            world.func_175685_c(blockpos, (Block)this, true);
        }
        return state;
    }

    private boolean isRedstoneWire(IBlockState state) {
        return state.func_177230_c() == this || state.func_177230_c() instanceof BlockRedstoneWire;
    }

    private IBlockState calculateCurrentChanges(World world, BlockPos thispos, BlockPos p_calculateCurrentChanges_3_, IBlockState state) {
        IBlockState origState = state;
        int power = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        int maxCurrPower = this.getMaxCurrentStrength(world, p_calculateCurrentChanges_3_, 0);
        int maxinpower = 0;
        int maxadjacentpower = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = thispos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (!this.pcbAllowsConnection((IBlockAccess)world, thispos, enumfacing) || block == this && !this.pcbAllowsConnection((IBlockAccess)world, blockpos, enumfacing.func_176734_d())) continue;
            if (this.isRedstoneWire(world.func_180495_p(blockpos))) {
                maxadjacentpower = this.getMaxCurrentStrength(world, blockpos, maxadjacentpower);
                continue;
            }
            int redstonein = Math.max(world.func_175651_c(blockpos, enumfacing), world.func_175627_a(blockpos, enumfacing));
            maxinpower = Math.max(maxinpower, redstonein);
        }
        maxCurrPower = maxadjacentpower > maxCurrPower ? maxadjacentpower - 1 : (maxCurrPower > 0 ? --maxCurrPower : 0);
        if (maxinpower > maxCurrPower - 1) {
            maxCurrPower = maxinpower;
        }
        if (power != (maxCurrPower = MathHelper.func_76125_a((int)maxCurrPower, (int)0, (int)15))) {
            state = state.func_177226_a((IProperty)BlockRedstoneWire.field_176351_O, (Comparable)Integer.valueOf(maxCurrPower));
            if (world.func_180495_p(thispos) == origState) {
                world.func_180501_a(thispos, state, 2);
            }
            this.blocksNeedingUpdate.add(thispos);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                if (!this.pcbAllowsConnection((IBlockAccess)world, thispos, enumfacing)) continue;
                this.blocksNeedingUpdate.add(thispos.func_177972_a(enumfacing));
            }
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World world, BlockPos pos) {
        if (this.isRedstoneWire(world.func_180495_p(pos))) {
            world.func_175685_c(pos, (Block)this, true);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                world.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float x, float y, float z) {
        BlockPos bottompos = pos.func_177977_b();
        IBlockState bottomstate = world.func_180495_p(bottompos);
        return bottomstate.func_177230_c().func_180639_a(world, bottompos, bottomstate, player, hand, facing, x, y, z);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            this.updateSurroundingRedstone(world, pos, state);
            for (EnumFacing enumfacing2 : EnumFacing.Plane.VERTICAL) {
                world.func_175685_c(pos.func_177972_a(enumfacing2), (Block)this, true);
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(world, pos.func_177972_a(enumfacing2));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (world.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(world, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(world, blockpos.func_177977_b());
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                world.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
            }
            this.updateSurroundingRedstone(world, pos, state);
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(world, pos.func_177972_a(enumfacing));
            }
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                BlockPos var10 = pos.func_177972_a(enumfacing);
                if (world.func_180495_p(var10).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(world, var10.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(world, var10.func_177977_b());
            }
        }
    }

    private int getMaxCurrentStrength(World world, BlockPos pos, int strength) {
        IBlockState state = world.func_180495_p(pos);
        if (this.isRedstoneWire(state)) {
            int i = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            return i > strength ? i : strength;
        }
        return strength;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (fromPos.equals((Object)pos.func_177977_b())) {
                world.func_175685_c(pos, (Block)this, false);
            }
            if (this.func_176196_c(world, pos)) {
                this.updateSurroundingRedstone(world, pos, state);
            } else {
                this.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
            }
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int p_getItemDropped_3_) {
        return Items.field_151137_ax;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return !this.canProvidePower ? 0 : state.func_185911_a(world, pos, facing);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (!this.canProvidePower) {
            return 0;
        }
        int power = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        if (power == 0 || facing.func_176736_b() < 0) {
            return 0;
        }
        if (this.pcbAllowsConnection(world, pos, facing.func_176734_d())) {
            return power - 1;
        }
        return 0;
    }

    private boolean isOnPCB(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockPCB;
    }

    private boolean pcbAllowsConnection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() instanceof BlockPCB) {
            return BlockPCB.allowsFacing(state, facing);
        }
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (facing != null) {
            return this.pcbAllowsConnection(world, pos, facing.func_176734_d());
        }
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    @SideOnly(value=Side.CLIENT)
    public static int colorMultiplier(int strength) {
        float f = (float)strength / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (strength == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)pos.func_177956_o() + 0.0625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            world.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, (double)f1, (double)f2, (double)f3, new int[0]);
        }
    }

    public ItemStack func_185473_a(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.field_151137_ax);
    }

    public IBlockState func_176203_a(int p_getStateFromMeta_1_) {
        return this.func_176223_P().func_177226_a((IProperty)BlockRedstoneWire.field_176351_O, (Comparable)Integer.valueOf(p_getStateFromMeta_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState p_getMetaFromState_1_) {
        return (Integer)p_getMetaFromState_1_.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
    }

    public IBlockState func_185499_a(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_.ordinal()) {
            case 1: {
                return p_withRotation_1_.func_177226_a(NORTH, p_withRotation_1_.func_177229_b(SOUTH)).func_177226_a(EAST, p_withRotation_1_.func_177229_b(WEST)).func_177226_a(SOUTH, p_withRotation_1_.func_177229_b(NORTH)).func_177226_a(WEST, p_withRotation_1_.func_177229_b(EAST));
            }
            case 2: {
                return p_withRotation_1_.func_177226_a(NORTH, p_withRotation_1_.func_177229_b(EAST)).func_177226_a(EAST, p_withRotation_1_.func_177229_b(SOUTH)).func_177226_a(SOUTH, p_withRotation_1_.func_177229_b(WEST)).func_177226_a(WEST, p_withRotation_1_.func_177229_b(NORTH));
            }
            case 3: {
                return p_withRotation_1_.func_177226_a(NORTH, p_withRotation_1_.func_177229_b(WEST)).func_177226_a(EAST, p_withRotation_1_.func_177229_b(NORTH)).func_177226_a(SOUTH, p_withRotation_1_.func_177229_b(EAST)).func_177226_a(WEST, p_withRotation_1_.func_177229_b(SOUTH));
            }
        }
        return p_withRotation_1_;
    }

    public IBlockState func_185471_a(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        switch (p_withMirror_2_.ordinal()) {
            case 1: {
                return p_withMirror_1_.func_177226_a(NORTH, p_withMirror_1_.func_177229_b(SOUTH)).func_177226_a(SOUTH, p_withMirror_1_.func_177229_b(NORTH));
            }
            case 2: {
                return p_withMirror_1_.func_177226_a(EAST, p_withMirror_1_.func_177229_b(WEST)).func_177226_a(WEST, p_withMirror_1_.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(p_withMirror_1_, p_withMirror_2_);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, BlockRedstoneWire.field_176351_O});
    }

    static enum EnumAttachPosition implements IStringSerializable
    {
        UP("up"),
        SIDE("side"),
        NONE("none");

        private final String name;

        private EnumAttachPosition(String p_i45689_3_) {
            this.name = p_i45689_3_;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

