/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.AdobeType;
import betterwithaddons.block.BlockBase;
import betterwithaddons.util.IHasVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAdobe
extends BlockBase
implements IHasVariants {
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)7);
    public static final PropertyBool DRY_STATE = PropertyBool.func_177716_a((String)"dry");
    public AdobeType[] types;

    protected BlockAdobe(String name, AdobeType[] types) {
        super(name, Material.field_151571_B);
        this.types = types;
        for (int meta = 0; meta < types.length; ++meta) {
            types[meta].wetBlock = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)DRY_STATE, (Comparable)Boolean.valueOf(false));
            types[meta].dryBlock = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)DRY_STATE, (Comparable)Boolean.valueOf(true));
            types[meta].block = this;
        }
        this.func_149675_a(true);
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return this.types[(Integer)state.func_177229_b((IProperty)VARIANT)].getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (world == null) {
            return 15.0f;
        }
        IBlockState state = world.func_180495_p(pos);
        return this.types[(Integer)state.func_177229_b((IProperty)VARIANT)].getResistance();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (!((Boolean)state.func_177229_b((IProperty)DRY_STATE)).booleanValue() || this.types[(Integer)state.func_177229_b((IProperty)VARIANT)].dropsBlock()) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public Material func_149688_o(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DRY_STATE) != false ? Material.field_151576_e : Material.field_151571_B;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.func_177229_b((IProperty)DRY_STATE) != false ? SoundType.field_185851_d : SoundType.field_185849_b;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (!((Boolean)state.func_177229_b((IProperty)DRY_STATE)).booleanValue()) {
            worldIn.func_175684_a(pos, (Block)this, 2000);
        }
    }

    private boolean shouldDry(World world, BlockPos pos) {
        int light = world.func_175642_b(EnumSkyBlock.SKY, pos.func_177984_a());
        light = Math.max(light, world.func_175642_b(EnumSkyBlock.SKY, pos.func_177968_d()));
        light = Math.max(light, world.func_175642_b(EnumSkyBlock.SKY, pos.func_177978_c()));
        light = Math.max(light, world.func_175642_b(EnumSkyBlock.SKY, pos.func_177974_f()));
        light = Math.max(light, world.func_175642_b(EnumSkyBlock.SKY, pos.func_177976_e()));
        return world.func_72935_r() && !world.func_72896_J() && !world.func_72911_I() && light >= 15;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)DRY_STATE)).booleanValue()) {
            if (this.shouldDry(worldIn, pos) && rand.nextInt(3) < 1) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)DRY_STATE, (Comparable)Boolean.valueOf(true)), 2);
            } else {
                worldIn.func_175684_a(pos, (Block)this, 200);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, DRY_STATE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT) | ((Boolean)state.func_177229_b((IProperty)DRY_STATE) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta & 7)).func_177226_a((IProperty)DRY_STATE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int meta = 0; meta < 16; ++meta) {
            items.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    @Override
    public List<ModelResourceLocation> getVariantModels() {
        ArrayList<ModelResourceLocation> rlist = new ArrayList<ModelResourceLocation>();
        for (int i = 0; i < 16; ++i) {
            int variant = i % 8;
            boolean dry = i >= 8;
            rlist.add(new ModelResourceLocation(this.getRegistryName(), "dry=" + dry + ",variant=" + variant));
        }
        return rlist;
    }

    @Override
    public String getVariantName(int meta) {
        return meta >= 8 ? "dry" : "wet";
    }
}

