/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.crafting.recipes.INabeRecipe;
import betterwithaddons.crafting.recipes.ShapelessNabeRecipe;
import betterwithaddons.tileentity.TileEntityNabe;
import betterwithaddons.util.NabeResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CraftingManagerNabe {
    private static final CraftingManagerNabe instance = new CraftingManagerNabe();
    private List<INabeRecipe> recipes = new ArrayList<INabeRecipe>();

    public static CraftingManagerNabe getInstance() {
        return instance;
    }

    public void addRecipe(String name, NabeResult result, List<Ingredient> input, int time) {
        this.recipes.add(this.createRecipe(name, result, input, time));
    }

    public void addRecipe(INabeRecipe recipe) {
        this.recipes.add(recipe);
    }

    public List<INabeRecipe> findRecipeForRemoval(@Nonnull String name) {
        return this.recipes.stream().filter(recipe -> recipe.getName().equals(name)).collect(Collectors.toList());
    }

    public INabeRecipe getMostValidRecipe(TileEntityNabe tile, List<ItemStack> inv) {
        List<INabeRecipe> recipes = this.getValidCraftingRecipes(tile, inv);
        INabeRecipe picked = null;
        for (INabeRecipe recipe : recipes) {
            if (picked != null && recipe.compareTo(picked) <= 0) continue;
            picked = recipe;
        }
        return picked;
    }

    public List<INabeRecipe> getValidCraftingRecipes(TileEntityNabe tile, List<ItemStack> inv) {
        return this.recipes.stream().filter(recipe -> recipe.matches(tile, inv)).collect(Collectors.toCollection(ArrayList::new));
    }

    private INabeRecipe createRecipe(String name, NabeResult result, List<Ingredient> input, int time) {
        return new ShapelessNabeRecipe(name, result, input, time);
    }

    public List<INabeRecipe> getRecipes() {
        return this.recipes;
    }

    public boolean isValidItem(ItemStack stack) {
        return this.recipes.stream().anyMatch(recipe -> recipe.isValidItem(stack));
    }
}

