/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.block.EriottoMod.BlockNettedScreen;
import betterwithaddons.crafting.recipes.NetRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public abstract class CraftingManagerNet {
    private BlockNettedScreen.SifterType craftType;
    private List<NetRecipe> recipes;

    public CraftingManagerNet(BlockNettedScreen.SifterType craftType) {
        this.craftType = craftType;
        this.recipes = new ArrayList<NetRecipe>();
    }

    public void addRecipe(ItemStack[] outputs, Ingredient input, int sand) {
        this.recipes.add(this.createRecipe(outputs, input, sand));
    }

    public void addRecipe(ItemStack[] outputs, Ingredient input) {
        this.addRecipe(outputs, input, 0);
    }

    public void addRecipe(NetRecipe recipe) {
        this.recipes.add(recipe);
    }

    public List<NetRecipe> findRecipeForRemoval(@Nonnull ItemStack input) {
        return this.recipes.stream().filter(recipe -> recipe.matchesInput(input)).collect(Collectors.toList());
    }

    public NetRecipe getMostValidRecipe(List<EntityItem> inv, int sand) {
        List<NetRecipe> recipes = this.getValidCraftingRecipes(inv, sand);
        if (recipes == null || recipes.size() == 0) {
            return null;
        }
        return recipes.get(0);
    }

    public List<NetRecipe> getValidCraftingRecipes(List<EntityItem> inv, int sand) {
        return this.recipes.stream().filter(recipe -> recipe.matches(inv) && recipe.getSandRequired() <= sand).collect(Collectors.toCollection(ArrayList::new));
    }

    protected NetRecipe createRecipe(ItemStack[] outputs, Ingredient input, int sand) {
        return new NetRecipe(this.craftType, input, sand, outputs);
    }

    public List<NetRecipe> getRecipes() {
        return this.recipes;
    }
}

