/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.recipes;

import betterwithaddons.crafting.recipes.INabeRecipe;
import betterwithaddons.tileentity.TileEntityNabe;
import betterwithaddons.util.NabeResult;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.items.ItemStackHandler;

public class ShapelessNabeRecipe
implements INabeRecipe {
    public int time;
    List<Ingredient> ingredients;
    NabeResult result;
    String name;

    public ShapelessNabeRecipe(String name, NabeResult result, List<Ingredient> ingredients, int time) {
        this.name = name;
        this.ingredients = ingredients;
        this.result = result;
        this.time = time;
    }

    @Override
    public int getBoilingTime(TileEntityNabe tile) {
        return this.time;
    }

    @Override
    public boolean isValidItem(ItemStack stack) {
        return this.ingredients.stream().anyMatch(ingredient -> ingredient.apply(stack));
    }

    @Override
    public boolean matches(TileEntityNabe tile, List<ItemStack> stacks) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>(this.ingredients);
        for (ItemStack stack : stacks) {
            Optional<Ingredient> found = ingredients.stream().filter(x -> x.apply(stack)).findFirst();
            if (found.isPresent()) {
                ingredients.remove(found.get());
                continue;
            }
            return false;
        }
        return ingredients.isEmpty();
    }

    @Override
    public NabeResult craft(TileEntityNabe tile, List<ItemStack> stacks) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>(this.ingredients);
        ItemStackHandler inventory = tile.inventory;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack;
            ItemStack finalStack = stack = inventory.getStackInSlot(i);
            Optional<Ingredient> found = ingredients.stream().filter(x -> x.apply(finalStack)).findFirst();
            if (!found.isPresent()) continue;
            ingredients.remove(found.get());
            stack = tile.consumeItem(stack);
            inventory.setStackInSlot(i, stack);
        }
        return this.result.copy();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.ingredients.size();
    }
}

