/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AnimalCrossbreedHandler {
    private static ArrayList<AnimalMutation> mutationSet = new ArrayList();
    static Field inLove;

    public static void spawnEntityAt(World world, Vec3d pos, Entity entity) {
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        world.func_72838_d(entity);
    }

    public static void spawnBabyAt(World world, Vec3d pos, EntityAgeable entity) {
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        entity.func_70873_a(-24000);
        world.func_72838_d((Entity)entity);
    }

    public static int getSquidWeight(World world, Vec3d pos, EntityAnimal mother, EntityAnimal father) {
        BlockPos blockpos = new BlockPos(pos);
        IBlockState state = world.func_180495_p(blockpos);
        return state.func_185904_a() == Material.field_151586_h ? 50 : 0;
    }

    public static int getWolfWeight(World world, Vec3d pos, EntityAnimal mother, EntityAnimal father) {
        BlockPos blockpos = new BlockPos(pos);
        Biome biome = world.func_180494_b(blockpos);
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) ? 50 : 0;
    }

    public static int getOcelotWeight(World world, Vec3d pos, EntityAnimal mother, EntityAnimal father) {
        BlockPos blockpos = new BlockPos(pos);
        Biome biome = world.func_180494_b(blockpos);
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) ? 50 : 0;
    }

    public static void initialize() {
        inLove = ReflectionHelper.findField(EntityAnimal.class, (String[])new String[]{"field_70881_d", "inLove"});
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, (EntityAgeable)new EntityCow(world)), 100));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, (EntityAgeable)new EntitySheep(world)), 100));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, (EntityAgeable)new EntityPig(world)), 100));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, (EntityAgeable)new EntityChicken(world)), 50));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, (EntityAgeable)new EntityRabbit(world)), 75));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, mother.func_90011_a((EntityAgeable)mother)), 100));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, father.func_90011_a((EntityAgeable)father)), 100));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnEntityAt(world, pos, (Entity)new EntitySilverfish(world)), 200));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnEntityAt(world, pos, (Entity)new EntityCaveSpider(world)), 100));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnEntityAt(world, pos, (Entity)new EntitySlime(world)), 50));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnEntityAt(world, pos, (Entity)new EntitySquid(world)), 0).setCustomWeight(AnimalCrossbreedHandler::getSquidWeight));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, (EntityAgeable)new EntityWolf(world)), 0).setCustomWeight(AnimalCrossbreedHandler::getWolfWeight));
        mutationSet.add(new AnimalMutation((world, pos, mother, father) -> AnimalCrossbreedHandler.spawnBabyAt(world, pos, (EntityAgeable)new EntityOcelot(world)), 0).setCustomWeight(AnimalCrossbreedHandler::getOcelotWeight));
    }

    @SubscribeEvent
    public void crossBreedAnimal(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        BlockPos pos = entity.func_180425_c();
        try {
            if (!world.field_72995_K && entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (!animal.func_70880_s()) {
                    return;
                }
                if (world.func_175699_k(pos) >= 8 || (Integer)inLove.get(animal) > 20) {
                    return;
                }
                AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72321_a(8.0, 8.0, 8.0);
                List others = world.func_72872_a(EntityAnimal.class, aabb);
                EntityAnimal found = null;
                for (EntityAnimal other : others) {
                    if (other == animal || !other.func_70880_s()) continue;
                    if (this.isSameSpecies(animal, other)) {
                        return;
                    }
                    if (animal.func_174791_d().func_72436_e(other.func_174791_d()) > 12.25 || !this.isNotSitting(other) || world.func_175699_k(other.func_180425_c()) >= 8) continue;
                    found = other;
                    break;
                }
                if (found == null) {
                    return;
                }
                Vec3d spawnPos = new Vec3d((found.field_70165_t + animal.field_70165_t) / 2.0, (found.field_70163_u + animal.field_70163_u) / 2.0, (found.field_70161_v + animal.field_70161_v) / 2.0);
                BlockPos spawnBlockPos = new BlockPos(spawnPos);
                EntityAnimal finalFound = found;
                ArrayList mutations = mutationSet.stream().map(x -> x.copy().updateWeight(world, spawnPos, finalFound, animal)).collect(Collectors.toCollection(ArrayList::new));
                AnimalMutation mutation = (AnimalMutation)WeightedRandom.func_76271_a((Random)world.field_73012_v, (List)mutations);
                if (mutation != null) {
                    mutation.spawner.spawn(world, spawnPos, found, animal);
                }
                animal.func_70875_t();
                animal.func_70873_a(6000);
                found.func_70875_t();
                found.func_70873_a(6000);
                animal.func_70642_aH();
                found.func_70642_aH();
                animal.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 6000));
                found.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 6000));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private boolean isSameSpecies(EntityAnimal animalA, EntityAnimal animalB) {
        return animalA.getClass().isInstance(animalB) || animalB.getClass().isInstance(animalA);
    }

    private boolean isNotSitting(EntityAnimal animal) {
        if (animal instanceof EntityTameable) {
            EntityTameable tameable = (EntityTameable)animal;
            return tameable.func_70909_n() && !tameable.func_70906_o();
        }
        return true;
    }

    public static class AnimalMutation
    extends WeightedRandom.Item {
        IAnimalSpawner spawner;
        IAnimalWeight weight;

        public AnimalMutation(IAnimalSpawner spawner, int itemWeightIn) {
            super(itemWeightIn);
            this.spawner = spawner;
        }

        public AnimalMutation copy() {
            return new AnimalMutation(this.spawner, this.field_76292_a).setCustomWeight(this.weight);
        }

        public AnimalMutation setCustomWeight(IAnimalWeight weight) {
            this.weight = weight;
            return this;
        }

        public AnimalMutation updateWeight(World world, Vec3d pos, EntityAnimal mother, EntityAnimal father) {
            if (this.weight != null) {
                this.field_76292_a = this.weight.getCustomWeight(world, pos, mother, father);
            }
            return this;
        }
    }

    public static interface IAnimalWeight {
        public int getCustomWeight(World var1, Vec3d var2, EntityAnimal var3, EntityAnimal var4);
    }

    public static interface IAnimalSpawner {
        public void spawn(World var1, Vec3d var2, EntityAnimal var3, EntityAnimal var4);
    }
}

