/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;

public class MobTerritoryType {
    public static HashMap<String, MobTerritoryType> typeList = new HashMap();
    String identifier;
    ArrayList<Class<EntityLiving>> mobClasses;
    boolean canReplaceAnimals;

    public MobTerritoryType(String identifier) {
        typeList.put(identifier, this);
    }

    public void addEntityClass(Class<EntityLiving> entityclass) {
        if (!this.mobClasses.contains(entityclass)) {
            this.mobClasses.add(entityclass);
        }
    }

    public void removeEntityClass(Class<EntityLiving> entityclass) {
        if (this.mobClasses.contains(entityclass)) {
            this.mobClasses.remove(entityclass);
        }
    }

    public void setCanReplaceAnimals(boolean newval) {
        this.canReplaceAnimals = newval;
    }

    public boolean getCanReplaceAnimals() {
        return this.canReplaceAnimals;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean shouldReplace(EntityLiving living) {
        if (living instanceof EntityAnimal && !this.canReplaceAnimals) {
            return false;
        }
        boolean shouldReplace = true;
        for (Class<EntityLiving> entityclass : this.mobClasses) {
            if (!entityclass.isInstance(living)) continue;
            shouldReplace = false;
            break;
        }
        return shouldReplace;
    }
}

