/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.handler.RandomBlockTickEvent;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockPlanter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlantCrossbreedHandler {
    private static ArrayList<PlantMutation> mutationTree = new ArrayList();
    private static ArrayList<PlantMutation> mutationTreeFungi = new ArrayList();

    private static void addEvolution(PlantMutation parent, PlantMutation child, int weight) {
        NextMutation mutation = new NextMutation(child, weight);
        parent.addMutation(mutation);
    }

    private static void addEvolution(PlantMutation parent, PlantMutation child) {
        PlantCrossbreedHandler.addEvolution(parent, child, 1);
        PlantCrossbreedHandler.addEvolution(child, parent, 5);
    }

    public static void placeDirt(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        Block block = soil.func_177230_c();
        if (block == BWMBlocks.FERTILE_FARMLAND) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150458_ak.func_176223_P(), 3);
        } else if (block == BWMBlocks.PLANTER && soil.func_177229_b((IProperty)BlockPlanter.TYPE) == BlockPlanter.EnumType.FERTILE) {
            world.func_180501_a(pos.func_177977_b(), BWMBlocks.PLANTER.func_176223_P().func_177226_a((IProperty)BlockPlanter.TYPE, (Comparable)BlockPlanter.EnumType.DIRT), 3);
        }
    }

    public static void placeGrass(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        Block block = soil.func_177230_c();
        if (block == BWMBlocks.FERTILE_FARMLAND || block == Blocks.field_150346_d || block == Blocks.field_150458_ak) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150349_c.func_176223_P(), 3);
        } else if (block == BWMBlocks.PLANTER && (soil.func_177229_b((IProperty)BlockPlanter.TYPE) == BlockPlanter.EnumType.FERTILE || soil.func_177229_b((IProperty)BlockPlanter.TYPE) == BlockPlanter.EnumType.DIRT)) {
            world.func_180501_a(pos.func_177977_b(), BWMBlocks.PLANTER.func_176223_P().func_177226_a((IProperty)BlockPlanter.TYPE, (Comparable)BlockPlanter.EnumType.GRASS), 3);
        }
    }

    public static void placeMycelium(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        Block block = soil.func_177230_c();
        if (block == BWMBlocks.FERTILE_FARMLAND || block == Blocks.field_150346_d || block == Blocks.field_150458_ak) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150391_bh.func_176223_P(), 3);
        }
    }

    public static void placeFarmland(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        Block block = soil.func_177230_c();
        if (block == BWMBlocks.FERTILE_FARMLAND) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150458_ak.func_176223_P(), 3);
        } else if (block == BWMBlocks.PLANTER && soil.func_177229_b((IProperty)BlockPlanter.TYPE) == BlockPlanter.EnumType.FERTILE) {
            world.func_180501_a(pos.func_177977_b(), BWMBlocks.PLANTER.func_176223_P().func_177226_a((IProperty)BlockPlanter.TYPE, (Comparable)BlockPlanter.EnumType.DIRT), 3);
        }
    }

    public static boolean placePlant(World world, BlockPos pos, Block block) {
        return PlantCrossbreedHandler.placePlant(world, pos, block.func_176223_P());
    }

    public static boolean placePlant(World world, BlockPos pos, IBlockState state) {
        if (!state.func_177230_c().func_176196_c(world, pos)) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            Block block = soil.func_177230_c();
            PlantCrossbreedHandler.placeDirt(world, pos);
            if (!state.func_177230_c().func_176196_c(world, pos)) {
                world.func_180501_a(pos.func_177977_b(), soil, 3);
                return false;
            }
        }
        world.func_175656_a(pos, state);
        PlantCrossbreedHandler.placeFarmland(world, pos);
        return true;
    }

    public static boolean matchTallPlant(World world, BlockPos pos, IBlockState state, BlockDoublePlant.EnumPlantType type) {
        return state.func_177230_c() == Blocks.field_150398_cm && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == type;
    }

    public static boolean placeTallPlant(World world, BlockPos pos, BlockDoublePlant.EnumPlantType type) {
        if (!Blocks.field_150398_cm.func_176196_c(world, pos)) {
            return false;
        }
        Blocks.field_150398_cm.func_176491_a(world, pos, type, 3);
        PlantCrossbreedHandler.placeFarmland(world, pos);
        return true;
    }

    public static boolean placeCocoa(World world, BlockPos pos) {
        Random rand = world.field_73012_v;
        int initial = rand.nextInt(4);
        for (int i = 0; i < 4; ++i) {
            EnumFacing facing = EnumFacing.func_176731_b((int)((initial + i) % 4));
            IBlockState state = Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)facing);
            if (!(Blocks.field_150375_by instanceof BlockCocoa) || !((BlockCocoa)Blocks.field_150375_by).func_176499_e(world, pos, state)) continue;
            world.func_175656_a(pos, state);
            PlantCrossbreedHandler.placeFarmland(world, pos);
            return true;
        }
        return false;
    }

    public static boolean placeVines(World world, BlockPos pos) {
        IBlockState state = Blocks.field_150395_bd.func_176223_P();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!Blocks.field_150395_bd.func_176198_a(world, pos, facing)) continue;
            state = state.func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)facing), (Comparable)Boolean.valueOf(true));
        }
        world.func_175656_a(pos, state);
        PlantCrossbreedHandler.placeFarmland(world, pos);
        return true;
    }

    public static void initialize() {
        IBlockState grassState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
        IBlockState fernState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
        IBlockState dandelionState = Blocks.field_150327_N.func_176223_P().func_177226_a(Blocks.field_150327_N.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.DANDELION);
        IBlockState poppyState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY);
        IBlockState oakState = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.OAK);
        IBlockState spruceState = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
        IBlockState birchState = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.BIRCH);
        IBlockState jungleState = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState acaciaState = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.ACACIA);
        IBlockState darkoakState = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.DARK_OAK);
        IBlockState blueOrchidState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.BLUE_ORCHID);
        IBlockState aliumState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ALLIUM);
        IBlockState daisyState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.OXEYE_DAISY);
        IBlockState bluetState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA);
        IBlockState tulipRedState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.RED_TULIP);
        IBlockState tulipOrangeState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ORANGE_TULIP);
        IBlockState tulipPinkState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.PINK_TULIP);
        IBlockState tulipWhiteState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.WHITE_TULIP);
        PlantMutation grass = new PlantMutation().setCropMatcher(grassState).setCropPlacer((world, pos) -> {
            if (PlantCrossbreedHandler.placePlant(world, pos, grassState)) {
                PlantCrossbreedHandler.placeGrass(world, pos);
            }
        });
        PlantMutation wheat = new PlantMutation().setCropMatcher(Blocks.field_150464_aj).setCropPlacer(Blocks.field_150464_aj);
        PlantMutation hemp = new PlantMutation().setCropMatcher(BWMBlocks.HEMP).setCropPlacer(BWMBlocks.HEMP);
        PlantMutation dandelion = new PlantMutation().setCropMatcher(dandelionState).setCropPlacer(dandelionState);
        PlantMutation pumpkin = new PlantMutation().setCropMatcher(Blocks.field_150393_bb).setCropPlacer(Blocks.field_150393_bb);
        PlantMutation melon = new PlantMutation().setCropMatcher(Blocks.field_150394_bc).setCropPlacer(Blocks.field_150394_bc);
        PlantMutation sugarcane = new PlantMutation().setCropMatcher((Block)Blocks.field_150436_aH).setCropPlacer((Block)Blocks.field_150436_aH);
        PlantMutation cactus = new PlantMutation().setCropMatcher((Block)Blocks.field_150434_aF).setCropPlacer((Block)Blocks.field_150434_aF);
        PlantMutation poppy = new PlantMutation().setCropMatcher(poppyState).setCropPlacer(poppyState);
        PlantMutation fern = new PlantMutation().setCropMatcher(fernState).setCropPlacer((world, pos) -> {
            if (PlantCrossbreedHandler.placePlant(world, pos, fernState)) {
                PlantCrossbreedHandler.placeGrass(world, pos);
            }
        });
        PlantMutation lilypad = new PlantMutation().setCropMatcher(Blocks.field_150392_bi).setCropPlacer(Blocks.field_150392_bi);
        PlantMutation vines = new PlantMutation().setCropMatcher(Blocks.field_150395_bd).setCropPlacer(PlantCrossbreedHandler::placeVines);
        PlantMutation cocoa = new PlantMutation().setCropMatcher(Blocks.field_150375_by).setCropPlacer(PlantCrossbreedHandler::placeCocoa);
        PlantMutation oak = new PlantMutation().setCropMatcher(oakState).setCropPlacer(oakState);
        PlantMutation spruce = new PlantMutation().setCropMatcher(spruceState).setCropPlacer(spruceState);
        PlantMutation birch = new PlantMutation().setCropMatcher(birchState).setCropPlacer(birchState);
        PlantMutation jungle = new PlantMutation().setCropMatcher(jungleState).setCropPlacer(jungleState);
        PlantMutation acacia = new PlantMutation().setCropMatcher(acaciaState).setCropPlacer(acaciaState);
        PlantMutation darkoak = new PlantMutation().setCropMatcher(darkoakState).setCropPlacer(darkoakState);
        PlantMutation carrots = new PlantMutation().setCropMatcher(Blocks.field_150459_bM).setCropPlacer(Blocks.field_150459_bM);
        PlantMutation potatoes = new PlantMutation().setCropMatcher(Blocks.field_150469_bN).setCropPlacer(Blocks.field_150469_bN);
        PlantMutation beets = new PlantMutation().setCropMatcher(Blocks.field_185773_cZ).setCropPlacer(Blocks.field_185773_cZ);
        PlantMutation bigGrass = new PlantMutation().setCropMatcher((world, pos, state) -> PlantCrossbreedHandler.matchTallPlant(world, pos, state, BlockDoublePlant.EnumPlantType.GRASS)).setCropPlacer((world, pos) -> {
            if (PlantCrossbreedHandler.placeTallPlant(world, pos, BlockDoublePlant.EnumPlantType.GRASS)) {
                PlantCrossbreedHandler.placeGrass(world, pos);
            }
        });
        PlantMutation bigFern = new PlantMutation().setCropMatcher((world, pos, state) -> PlantCrossbreedHandler.matchTallPlant(world, pos, state, BlockDoublePlant.EnumPlantType.FERN)).setCropPlacer((world, pos) -> {
            if (PlantCrossbreedHandler.placeTallPlant(world, pos, BlockDoublePlant.EnumPlantType.FERN)) {
                PlantCrossbreedHandler.placeGrass(world, pos);
            }
        });
        PlantMutation sunflower = new PlantMutation().setCropMatcher((world, pos, state) -> PlantCrossbreedHandler.matchTallPlant(world, pos, state, BlockDoublePlant.EnumPlantType.SUNFLOWER)).setCropPlacer((world, pos) -> PlantCrossbreedHandler.placeTallPlant(world, pos, BlockDoublePlant.EnumPlantType.SUNFLOWER));
        PlantMutation peony = new PlantMutation().setCropMatcher((world, pos, state) -> PlantCrossbreedHandler.matchTallPlant(world, pos, state, BlockDoublePlant.EnumPlantType.PAEONIA)).setCropPlacer((world, pos) -> PlantCrossbreedHandler.placeTallPlant(world, pos, BlockDoublePlant.EnumPlantType.PAEONIA));
        PlantMutation lilac = new PlantMutation().setCropMatcher((world, pos, state) -> PlantCrossbreedHandler.matchTallPlant(world, pos, state, BlockDoublePlant.EnumPlantType.SYRINGA)).setCropPlacer((world, pos) -> PlantCrossbreedHandler.placeTallPlant(world, pos, BlockDoublePlant.EnumPlantType.SYRINGA));
        PlantMutation rose = new PlantMutation().setCropMatcher((world, pos, state) -> PlantCrossbreedHandler.matchTallPlant(world, pos, state, BlockDoublePlant.EnumPlantType.ROSE)).setCropPlacer((world, pos) -> PlantCrossbreedHandler.placeTallPlant(world, pos, BlockDoublePlant.EnumPlantType.ROSE));
        PlantMutation blueOrchid = new PlantMutation().setCropMatcher(blueOrchidState).setCropPlacer(blueOrchidState);
        PlantMutation alium = new PlantMutation().setCropMatcher(aliumState).setCropPlacer(aliumState);
        PlantMutation daisy = new PlantMutation().setCropMatcher(daisyState).setCropPlacer(daisyState);
        PlantMutation bluet = new PlantMutation().setCropMatcher(bluetState).setCropPlacer(bluetState);
        PlantMutation tulipRed = new PlantMutation().setCropMatcher(tulipRedState).setCropPlacer(tulipRedState);
        PlantMutation tulipOrange = new PlantMutation().setCropMatcher(tulipOrangeState).setCropPlacer(tulipOrangeState);
        PlantMutation tulipPink = new PlantMutation().setCropMatcher(tulipPinkState).setCropPlacer(tulipPinkState);
        PlantMutation tulipWhite = new PlantMutation().setCropMatcher(tulipWhiteState).setCropPlacer(tulipWhiteState);
        mutationTree.addAll(Lists.newArrayList((Object[])new PlantMutation[]{grass, wheat, hemp, dandelion, pumpkin, melon, sugarcane, cactus, poppy, fern, lilypad, vines, cocoa, oak, spruce, birch, jungle, acacia, darkoak, carrots, potatoes, beets, bigGrass, bigFern, sunflower, peony, lilac, rose, blueOrchid, alium, daisy, bluet, tulipRed, tulipOrange, tulipPink, tulipWhite}));
        PlantCrossbreedHandler.addEvolution(grass, wheat);
        PlantCrossbreedHandler.addEvolution(grass, hemp);
        PlantCrossbreedHandler.addEvolution(grass, dandelion);
        PlantCrossbreedHandler.addEvolution(hemp, pumpkin);
        PlantCrossbreedHandler.addEvolution(pumpkin, melon);
        PlantCrossbreedHandler.addEvolution(hemp, sugarcane);
        PlantCrossbreedHandler.addEvolution(sugarcane, cactus);
        PlantCrossbreedHandler.addEvolution(dandelion, poppy);
        PlantCrossbreedHandler.addEvolution(poppy, fern);
        PlantCrossbreedHandler.addEvolution(fern, lilypad);
        PlantCrossbreedHandler.addEvolution(fern, vines);
        PlantCrossbreedHandler.addEvolution(vines, cocoa);
        PlantCrossbreedHandler.addEvolution(dandelion, oak);
        PlantCrossbreedHandler.addEvolution(oak, birch);
        PlantCrossbreedHandler.addEvolution(birch, spruce);
        PlantCrossbreedHandler.addEvolution(spruce, jungle);
        PlantCrossbreedHandler.addEvolution(oak, darkoak);
        PlantCrossbreedHandler.addEvolution(jungle, acacia);
        PlantCrossbreedHandler.addEvolution(wheat, potatoes);
        PlantCrossbreedHandler.addEvolution(potatoes, carrots);
        PlantCrossbreedHandler.addEvolution(potatoes, beets);
        PlantCrossbreedHandler.addEvolution(grass, bigGrass);
        PlantCrossbreedHandler.addEvolution(fern, bigFern);
        PlantCrossbreedHandler.addEvolution(dandelion, sunflower);
        PlantCrossbreedHandler.addEvolution(bluet, peony);
        PlantCrossbreedHandler.addEvolution(alium, lilac);
        PlantCrossbreedHandler.addEvolution(dandelion, daisy);
        PlantCrossbreedHandler.addEvolution(daisy, bluet);
        PlantCrossbreedHandler.addEvolution(bluet, blueOrchid);
        PlantCrossbreedHandler.addEvolution(blueOrchid, alium);
        PlantCrossbreedHandler.addEvolution(poppy, rose);
        PlantCrossbreedHandler.addEvolution(poppy, tulipRed);
        PlantCrossbreedHandler.addEvolution(tulipRed, tulipOrange);
        PlantCrossbreedHandler.addEvolution(tulipRed, tulipPink);
        PlantCrossbreedHandler.addEvolution(tulipPink, tulipWhite);
        PlantMutation mushroom = new PlantMutation().setCropMatcher((Block)Blocks.field_150338_P).setCropPlacer((world, pos) -> {
            if (PlantCrossbreedHandler.placePlant(world, pos, (Block)Blocks.field_150338_P)) {
                PlantCrossbreedHandler.placeMycelium(world, pos);
            }
        });
        PlantMutation amanita = new PlantMutation().setCropMatcher((Block)Blocks.field_150337_Q).setCropPlacer((world, pos) -> {
            if (PlantCrossbreedHandler.placePlant(world, pos, (Block)Blocks.field_150337_Q)) {
                PlantCrossbreedHandler.placeMycelium(world, pos);
            }
        });
        PlantMutation netherwart = new PlantMutation().setCropMatcher(Blocks.field_150388_bm).setCropPlacer(Blocks.field_150388_bm);
        PlantMutation chorus = new PlantMutation().setCropMatcher(Blocks.field_185766_cS).setCropPlacer(Blocks.field_185766_cS);
        mutationTreeFungi.addAll(Lists.newArrayList((Object[])new PlantMutation[]{mushroom, amanita, netherwart, chorus}));
        PlantCrossbreedHandler.addEvolution(mushroom, amanita);
        PlantCrossbreedHandler.addEvolution(amanita, netherwart);
        PlantCrossbreedHandler.addEvolution(netherwart, chorus);
    }

    public static PlantMutation getMutation(List<PlantMutation> tree, World world, BlockPos pos, IBlockState state) {
        for (PlantMutation plant : tree) {
            if (!plant.matches(world, pos, state)) continue;
            return plant;
        }
        return null;
    }

    @SubscribeEvent
    public void crossBreedPlants(RandomBlockTickEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos().func_177984_a();
        IBlockState state = event.getState();
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        Random random = event.getRandom();
        if (world.field_72995_K || !state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || !this.isValidSoil(soil)) {
            return;
        }
        ArrayList<PlantMutation> tree = mutationTree;
        int lightlevel = world.func_175699_k(pos);
        if (lightlevel <= 7) {
            tree = mutationTreeFungi;
        }
        HashSet<PlantMutation> nearby = new HashSet<PlantMutation>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos checkpos = pos.func_177982_a(x, 0, z);
                PlantMutation plant = PlantCrossbreedHandler.getMutation(tree, world, checkpos, world.func_180495_p(checkpos));
                if (plant == null) continue;
                nearby.add(plant);
            }
        }
        if (nearby.size() < 2) {
            return;
        }
        ArrayList nextMutations = Lists.newArrayList((Object[])new NextMutation[]{new NextMutation(mutationTree.get(0), 10)});
        for (PlantMutation plant : nearby) {
            for (NextMutation mutation : plant.nextMutations) {
                mutation.mergeInto(nextMutations);
            }
        }
        NextMutation pickedMutation = (NextMutation)WeightedRandom.func_76271_a((Random)random, (List)nextMutations);
        if (pickedMutation != null) {
            pickedMutation.mutation.grow(world, pos);
        }
    }

    private boolean isValidSoil(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150425_aM || block == Blocks.field_150377_bs || block == BWMBlocks.FERTILE_FARMLAND || block == BWMBlocks.PLANTER;
    }

    public static class PlantMutation {
        ICropMatcher block;
        ICropPlacer createdBlock;
        ArrayList<NextMutation> nextMutations = new ArrayList();

        public PlantMutation setCropPlacer(Block block) {
            return this.setCropPlacer(block.func_176223_P());
        }

        public PlantMutation setCropPlacer(IBlockState state) {
            this.createdBlock = (world, pos) -> PlantCrossbreedHandler.placePlant(world, pos, state);
            return this;
        }

        public PlantMutation setCropPlacer(ICropPlacer placer) {
            this.createdBlock = placer;
            return this;
        }

        public PlantMutation setCropMatcher(Block block) {
            this.block = (world, pos, state) -> block == state.func_177230_c();
            return this;
        }

        public PlantMutation setCropMatcher(IBlockState checkstate) {
            this.block = (world, pos, state) -> state.equals(checkstate);
            return this;
        }

        public PlantMutation setCropMatcher(ICropMatcher matcher) {
            this.block = matcher;
            return this;
        }

        public boolean matches(World world, BlockPos pos, IBlockState state) {
            return this.block.matches(world, pos, state);
        }

        public void grow(World world, BlockPos pos) {
            this.createdBlock.place(world, pos);
        }

        public void addMutation(NextMutation mutation) {
            mutation.mergeInto(this.nextMutations);
        }
    }

    public static class NextMutation
    extends WeightedRandom.Item {
        PlantMutation mutation;

        public PlantMutation getMutation() {
            return this.mutation;
        }

        public NextMutation(PlantMutation mutation, int itemWeightIn) {
            super(itemWeightIn);
            this.mutation = mutation;
        }

        public NextMutation copy() {
            return new NextMutation(this.mutation, this.field_76292_a);
        }

        public boolean add(NextMutation other) {
            if (this.mutation.equals(other.mutation)) {
                this.field_76292_a += other.field_76292_a;
                return true;
            }
            return false;
        }

        public void mergeInto(List<NextMutation> list) {
            boolean added = false;
            for (NextMutation other : list) {
                added |= other.add(this);
            }
            if (!added) {
                list.add(this);
            }
        }
    }

    public static interface ICropPlacer {
        public void place(World var1, BlockPos var2);
    }

    public static interface ICropMatcher {
        public boolean matches(World var1, BlockPos var2, IBlockState var3);
    }
}

